/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.runtime.registry;

import io.github.dddplus.annotation.DomainAbility;
import io.github.dddplus.ext.IDomainExtension;
import io.github.dddplus.model.IDomainModel;
import io.github.dddplus.runtime.BaseDomainAbility;
import io.github.dddplus.runtime.registry.BootstrapException;
import io.github.dddplus.runtime.registry.CoreAopUtils;
import io.github.dddplus.runtime.registry.IRegistryAware;
import io.github.dddplus.runtime.registry.InternalIndexer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DomainAbilityDef
implements IRegistryAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DomainAbilityDef.class);
    private String domain;
    private String name;
    private BaseDomainAbility domainAbilityBean;
    private Class<? extends BaseDomainAbility> domainAbilityClass;
    private Class<? extends IDomainModel> modelClazz;
    private Class<? extends IDomainExtension> extClazz;

    DomainAbilityDef() {
    }

    @Override
    public void registerBean(@NotNull Object bean) {
        DomainAbility domainAbility = CoreAopUtils.getAnnotation(bean, DomainAbility.class);
        this.domain = domainAbility.domain();
        this.name = domainAbility.name();
        if (!(bean instanceof BaseDomainAbility)) {
            throw BootstrapException.ofMessage(bean.getClass().getCanonicalName(), " MUST extend BaseDomainAbility");
        }
        this.domainAbilityBean = (BaseDomainAbility)bean;
        this.domainAbilityClass = CoreAopUtils.getTarget(bean).getClass();
        Type type = CoreAopUtils.getGenericSuperclass(bean);
        if (type == null || !(type instanceof ParameterizedType)) {
            throw BootstrapException.ofMessage("cannot find ParameterizedType for:", bean.getClass().getCanonicalName());
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        if (parameterizedType == null || parameterizedType.getActualTypeArguments().length < 2) {
            throw BootstrapException.ofMessage("illegal generic declaration for:", bean.getClass().getCanonicalName());
        }
        this.modelClazz = (Class)parameterizedType.getActualTypeArguments()[0];
        this.extClazz = (Class)parameterizedType.getActualTypeArguments()[1];
        log.debug("domain ability:{} model:{} ext:{}", new Object[]{bean.getClass().getCanonicalName(), this.modelClazz.getCanonicalName(), this.extClazz.getCanonicalName()});
        InternalIndexer.index(this);
    }

    @Generated
    public String toString() {
        return "DomainAbilityDef(domain=" + this.getDomain() + ", name=" + this.getName() + ", domainAbilityBean=" + this.getDomainAbilityBean() + ", domainAbilityClass=" + this.getDomainAbilityClass() + ", modelClazz=" + this.getModelClazz() + ", extClazz=" + this.getExtClazz() + ")";
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public BaseDomainAbility getDomainAbilityBean() {
        return this.domainAbilityBean;
    }

    @Generated
    public Class<? extends BaseDomainAbility> getDomainAbilityClass() {
        return this.domainAbilityClass;
    }

    @Generated
    public Class<? extends IDomainModel> getModelClazz() {
        return this.modelClazz;
    }

    @Generated
    public Class<? extends IDomainExtension> getExtClazz() {
        return this.extClazz;
    }
}

