/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.runtime.registry;

import io.github.dddplus.ext.IDomainExtension;
import io.github.dddplus.model.IDomainModel;
import io.github.dddplus.runtime.BaseDomainAbility;
import io.github.dddplus.runtime.registry.BootstrapException;
import io.github.dddplus.runtime.registry.DomainAbilityDef;
import io.github.dddplus.runtime.registry.DomainDef;
import io.github.dddplus.runtime.registry.DomainServiceDef;
import io.github.dddplus.runtime.registry.ExtensionDef;
import io.github.dddplus.runtime.registry.PartnerDef;
import io.github.dddplus.runtime.registry.PatternDef;
import io.github.dddplus.runtime.registry.StepDef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalIndexer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InternalIndexer.class);
    private static final List<StepDef> emptySteps = Collections.emptyList();
    static final Map<String, DomainDef> domainDefMap = new HashMap<String, DomainDef>();
    static final Map<Class<? extends BaseDomainAbility>, DomainAbilityDef> domainAbilityDefMap = new HashMap<Class<? extends BaseDomainAbility>, DomainAbilityDef>();
    static final Map<String, Map<String, StepDef>> domainStepDefMap = new HashMap<String, Map<String, StepDef>>();
    static final Map<String, PatternDef> patternDefMap = new HashMap<String, PatternDef>();
    static final Map<Class<? extends IDomainExtension>, List<PatternDef>> sortedPatternMap = new HashMap<Class<? extends IDomainExtension>, List<PatternDef>>();
    static final Map<String, PartnerDef> partnerDefMap = new ConcurrentHashMap<String, PartnerDef>();
    static PartnerDef partnerDefPrepared = null;

    private InternalIndexer() {
    }

    public static <T extends BaseDomainAbility> T findDomainAbility(@NotNull Class<? extends T> clazz) {
        DomainAbilityDef domainAbilityDef = domainAbilityDefMap.get(clazz);
        if (domainAbilityDef == null) {
            log.error("{} forgot to apply @DomainAbility, ArchitectureEnforcer turned off? indexed:{}", (Object)clazz.getCanonicalName(), domainAbilityDefMap.keySet());
            return null;
        }
        return (T)domainAbilityDef.getDomainAbilityBean();
    }

    public static Class<? extends IDomainExtension> getDomainAbilityExtDeclaration(@NotNull Class<? extends BaseDomainAbility> clazz) {
        DomainAbilityDef domainAbilityDef = domainAbilityDefMap.get(clazz);
        if (domainAbilityDef == null) {
            log.error("{} not apply @DomainAbility, ArchitectureEnforcer turned off?", (Object)clazz.getCanonicalName());
            return null;
        }
        return domainAbilityDef.getExtClazz();
    }

    @NotNull
    public static List<ExtensionDef> findEffectiveExtensions(@NotNull Class<? extends IDomainExtension> extClazz, @NotNull IDomainModel model, boolean firstStop) {
        ExtensionDef extensionDef;
        LinkedList<ExtensionDef> effectiveExtensions = new LinkedList<ExtensionDef>();
        List<PatternDef> sortedPatternDefs = sortedPatternMap.get(extClazz);
        if (sortedPatternDefs != null && !sortedPatternDefs.isEmpty()) {
            log.debug("{} found patterns:{}", (Object)extClazz.getCanonicalName(), sortedPatternDefs);
            for (PatternDef patternDef : sortedPatternDefs) {
                if (!patternDef.match(model)) continue;
                extensionDef = patternDef.getExtension(extClazz);
                if (extensionDef != null) {
                    effectiveExtensions.add(extensionDef);
                }
                if (!firstStop || effectiveExtensions.isEmpty()) continue;
                return effectiveExtensions;
            }
        }
        for (PartnerDef partnerDef : partnerDefMap.values()) {
            if (!partnerDef.match(model) || (extensionDef = partnerDef.getExtension(extClazz)) == null) continue;
            effectiveExtensions.add(extensionDef);
            break;
        }
        return effectiveExtensions;
    }

    @NotNull
    public static List<StepDef> findDomainSteps(@NotNull String activityCode, @NotNull List<String> stepCodeList) {
        Map<String, StepDef> childMap = domainStepDefMap.get(activityCode);
        if (childMap == null || childMap.isEmpty()) {
            log.error("found NO activity:{}", (Object)activityCode);
            return emptySteps;
        }
        LinkedList<StepDef> result = new LinkedList<StepDef>();
        for (String code : stepCodeList) {
            StepDef stepDef = childMap.get(code);
            if (stepDef == null) continue;
            result.add(stepDef);
        }
        if (result.size() != stepCodeList.size()) {
            log.warn("expected:{}, got:{} domain steps", (Object)stepCodeList.size(), (Object)result.size());
        }
        return result;
    }

    static void index(StepDef stepDef) {
        Map<String, StepDef> childMap;
        if (!domainStepDefMap.containsKey(stepDef.getActivity())) {
            domainStepDefMap.put(stepDef.getActivity(), new HashMap());
        }
        if ((childMap = domainStepDefMap.get(stepDef.getActivity())).containsKey(stepDef.getCode())) {
            throw BootstrapException.ofMessage("duplicated step code: ", stepDef.getCode());
        }
        childMap.put(stepDef.getCode(), stepDef);
        log.debug("indexed {} ", (Object)stepDef);
    }

    static void index(DomainDef domainDef) {
        if (domainDefMap.containsKey(domainDef.getCode())) {
            throw BootstrapException.ofMessage("duplicated domain code: ", domainDef.getCode());
        }
        domainDefMap.put(domainDef.getCode(), domainDef);
        log.debug("indexed {}", (Object)domainDef);
    }

    static void index(DomainAbilityDef domainAbilityDef) {
        if (!domainDefMap.containsKey(domainAbilityDef.getDomain())) {
            throw BootstrapException.ofMessage("DomainAbility domain not found: ", domainAbilityDef.getDomain());
        }
        if (domainAbilityDefMap.containsKey(domainAbilityDef.getDomainAbilityClass())) {
            throw BootstrapException.ofMessage("duplicated domain ability: ", domainAbilityDef.getDomainAbilityBean().toString());
        }
        domainAbilityDefMap.put(domainAbilityDef.getDomainAbilityClass(), domainAbilityDef);
        log.debug("indexed {}", (Object)domainAbilityDef);
    }

    static void index(DomainServiceDef domainServiceDef) {
        if (!domainDefMap.containsKey(domainServiceDef.getDomain())) {
            throw BootstrapException.ofMessage("DomainService domain not found: ", domainServiceDef.getDomain());
        }
        log.debug("indexed {}", (Object)domainServiceDef);
    }

    static void index(ExtensionDef extensionDef) {
        if (patternDefMap.containsKey(extensionDef.getCode())) {
            PatternDef patternDef = patternDefMap.get(extensionDef.getCode());
            patternDef.registerExtensionDef(extensionDef);
            log.debug("indexed {} on {}", (Object)extensionDef, (Object)patternDef);
            return;
        }
        if (partnerDefMap.containsKey(extensionDef.getCode())) {
            PartnerDef partnerDef = partnerDefMap.get(extensionDef.getCode());
            partnerDef.registerExtensionDef(extensionDef);
            log.debug("indexed {} on {}", (Object)extensionDef, (Object)partnerDef);
            return;
        }
        if (!"_default__".equals(extensionDef.getCode())) {
            throw BootstrapException.ofMessage("invalid extension code: ", extensionDef.getCode());
        }
    }

    static void index(PatternDef patternDef) {
        if (patternDefMap.containsKey(patternDef.getCode())) {
            throw BootstrapException.ofMessage("duplicated pattern code: ", patternDef.getCode());
        }
        if (partnerDefMap.containsKey(patternDef.getCode())) {
            throw BootstrapException.ofMessage("pattern: ", patternDef.getCode(), " conflicts with partner code");
        }
        patternDefMap.put(patternDef.getCode(), patternDef);
        log.debug("indexed {}", (Object)patternDef);
    }

    static void index(PartnerDef partnerDef) {
        if (partnerDefMap.containsKey(partnerDef.getCode())) {
            throw BootstrapException.ofMessage("duplicated partner code: ", partnerDef.getCode());
        }
        if (patternDefMap.containsKey(partnerDef.getCode())) {
            throw BootstrapException.ofMessage("partner: ", partnerDef.getCode(), " conflicts with pattern code");
        }
        partnerDefMap.put(partnerDef.getCode(), partnerDef);
        log.debug("indexed {}", (Object)partnerDef);
    }

    static void postIndexing() {
        for (PatternDef patternDef : patternDefMap.values()) {
            for (Class<? extends IDomainExtension> extClazz : patternDef.extClazzSet()) {
                if (!sortedPatternMap.containsKey(extClazz)) {
                    sortedPatternMap.put(extClazz, new ArrayList());
                }
                sortedPatternMap.get(extClazz).add(patternDef);
            }
        }
        for (List list : sortedPatternMap.values()) {
            Collections.sort(list, (p1, p2) -> p1.getPriority() - p2.getPriority());
        }
        patternDefMap.clear();
    }

    static void prepare(PartnerDef partnerDef) {
        partnerDefPrepared = partnerDef;
    }

    static void prepare(ExtensionDef extensionDef) {
        if (partnerDefPrepared == null) {
            throw BootstrapException.ofMessage("Partner must reside in Plugin Jar with its extensions!");
        }
        partnerDefPrepared.registerExtensionDef(extensionDef);
    }

    static void commitPartner() {
        partnerDefMap.put(partnerDefPrepared.getCode(), partnerDefPrepared);
        log.warn("Partner({}) committed", (Object)partnerDefPrepared.getCode());
        partnerDefPrepared = null;
    }
}

