/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.runtime.registry;

import io.github.dddplus.annotation.Domain;
import io.github.dddplus.annotation.DomainAbility;
import io.github.dddplus.annotation.DomainService;
import io.github.dddplus.annotation.Extension;
import io.github.dddplus.annotation.Partner;
import io.github.dddplus.annotation.Pattern;
import io.github.dddplus.annotation.Step;
import io.github.dddplus.ext.IPlugable;
import io.github.dddplus.runtime.registry.BootstrapException;
import io.github.dddplus.runtime.registry.DomainAbilityDef;
import io.github.dddplus.runtime.registry.DomainDef;
import io.github.dddplus.runtime.registry.DomainServiceDef;
import io.github.dddplus.runtime.registry.ExtensionDef;
import io.github.dddplus.runtime.registry.IPrepareAware;
import io.github.dddplus.runtime.registry.IRegistryAware;
import io.github.dddplus.runtime.registry.InternalIndexer;
import io.github.dddplus.runtime.registry.PartnerDef;
import io.github.dddplus.runtime.registry.PatternDef;
import io.github.dddplus.runtime.registry.StepDef;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
class RegistryFactory
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegistryFactory.class);
    private static List<RegistryEntry> validRegistryEntries = new ArrayList<RegistryEntry>();
    private static Map<Class<? extends Annotation>, PrepareEntry> validPrepareEntries = new HashMap<Class<? extends Annotation>, PrepareEntry>(3);

    RegistryFactory() {
    }

    void register(ApplicationContext applicationContext) {
        for (RegistryEntry registryEntry : validRegistryEntries) {
            log.info("register {}'s ...", (Object)registryEntry.annotation.getSimpleName());
            for (Object springBean : applicationContext.getBeansWithAnnotation(registryEntry.annotation).values()) {
                registryEntry.create().registerBean(springBean);
            }
        }
        InternalIndexer.postIndexing();
    }

    static void preparePlugins(Class<? extends Annotation> annotation, Object bean) {
        if (!(bean instanceof IPlugable)) {
            throw BootstrapException.ofMessage(bean.getClass().getCanonicalName() + " must be IPlugable");
        }
        PrepareEntry prepareEntry = validPrepareEntries.get(annotation);
        if (prepareEntry == null) {
            throw BootstrapException.ofMessage(annotation.getCanonicalName() + " not supported");
        }
        prepareEntry.create().prepare(bean);
    }

    public void afterPropertiesSet() throws Exception {
        log.info("setup the discoverable Spring beans...");
        validRegistryEntries.add(new RegistryEntry(Domain.class, () -> new DomainDef()));
        validRegistryEntries.add(new RegistryEntry(DomainService.class, () -> new DomainServiceDef()));
        validRegistryEntries.add(new RegistryEntry(Step.class, () -> new StepDef()));
        validRegistryEntries.add(new RegistryEntry(DomainAbility.class, () -> new DomainAbilityDef()));
        validRegistryEntries.add(new RegistryEntry(Partner.class, () -> new PartnerDef()));
        validRegistryEntries.add(new RegistryEntry(Pattern.class, () -> new PatternDef()));
        validRegistryEntries.add(new RegistryEntry(Extension.class, () -> new ExtensionDef()));
        validPrepareEntries.put(Partner.class, new PrepareEntry(() -> new PartnerDef()));
        validPrepareEntries.put(Extension.class, new PrepareEntry(() -> new ExtensionDef()));
    }

    private static class PrepareEntry {
        private final Supplier<IPrepareAware> supplier;

        PrepareEntry(Supplier<IPrepareAware> supplier) {
            this.supplier = supplier;
        }

        IPrepareAware create() {
            return this.supplier.get();
        }
    }

    private static class RegistryEntry {
        private final Class<? extends Annotation> annotation;
        private final Supplier<IRegistryAware> supplier;

        RegistryEntry(Class<? extends Annotation> annotation, Supplier<IRegistryAware> supplier) {
            this.annotation = annotation;
            this.supplier = supplier;
        }

        IRegistryAware create() {
            return this.supplier.get();
        }
    }
}

