/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.runtime.registry;

import io.github.dddplus.annotation.Step;
import io.github.dddplus.runtime.registry.BootstrapException;
import io.github.dddplus.runtime.registry.CoreAopUtils;
import io.github.dddplus.runtime.registry.IRegistryAware;
import io.github.dddplus.runtime.registry.InternalIndexer;
import io.github.dddplus.step.IDomainStep;
import java.util.Arrays;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class StepDef
implements IRegistryAware {
    private String activity;
    private String code;
    private String name;
    private String[] tags;
    private IDomainStep stepBean;

    @Override
    public void registerBean(@NotNull Object bean) {
        Step domainStep = CoreAopUtils.getAnnotation(bean, Step.class);
        this.name = domainStep.name();
        this.tags = domainStep.tags();
        if (!(bean instanceof IDomainStep)) {
            throw BootstrapException.ofMessage(bean.getClass().getCanonicalName(), " MUST implement IDomainStep");
        }
        this.stepBean = (IDomainStep)bean;
        this.activity = this.stepBean.activityCode();
        this.code = this.stepBean.stepCode();
        if (this.activity == null || this.activity.trim().isEmpty()) {
            throw BootstrapException.ofMessage(bean.getClass().getCanonicalName(), " activityCode cannot be empty");
        }
        if (this.code == null || this.code.trim().isEmpty()) {
            throw BootstrapException.ofMessage(bean.getClass().getCanonicalName(), " stepCode cannot be empty");
        }
        InternalIndexer.index(this);
    }

    @Generated
    public String toString() {
        return "StepDef(activity=" + this.getActivity() + ", code=" + this.getCode() + ", name=" + this.getName() + ", tags=" + Arrays.deepToString(this.getTags()) + ", stepBean=" + this.getStepBean() + ")";
    }

    @Generated
    public String getActivity() {
        return this.activity;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String[] getTags() {
        return this.tags;
    }

    @Generated
    public IDomainStep getStepBean() {
        return this.stepBean;
    }
}

