/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.protobuf.lite;

import com.google.common.base.Preconditions;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.protobuf.lite.ProtoInputStream;
import java.io.InputStream;

public class ProtoLiteUtils {
    private static volatile ExtensionRegistryLite globalRegistry = ExtensionRegistryLite.getEmptyRegistry();

    public static void setExtensionRegistry(ExtensionRegistryLite newRegistry) {
        globalRegistry = (ExtensionRegistryLite)Preconditions.checkNotNull((Object)newRegistry, (Object)"newRegistry");
    }

    public static <T extends MessageLite> MethodDescriptor.Marshaller<T> marshaller(T defaultInstance) {
        final Parser parser = defaultInstance.getParserForType();
        return new MethodDescriptor.Marshaller<T>(){

            public InputStream stream(T value) {
                return new ProtoInputStream((MessageLite)value, (Parser<?>)parser);
            }

            public T parse(InputStream stream) {
                ProtoInputStream protoStream;
                if (stream instanceof ProtoInputStream && (protoStream = (ProtoInputStream)stream).parser() == parser) {
                    try {
                        MessageLite message = ((ProtoInputStream)stream).message();
                        return message;
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                try {
                    return this.parseFrom(stream);
                }
                catch (InvalidProtocolBufferException ipbe) {
                    throw Status.INTERNAL.withDescription("Invalid protobuf byte sequence").withCause((Throwable)ipbe).asRuntimeException();
                }
            }

            private T parseFrom(InputStream stream) throws InvalidProtocolBufferException {
                CodedInputStream codedInput = CodedInputStream.newInstance((InputStream)stream);
                codedInput.setSizeLimit(Integer.MAX_VALUE);
                MessageLite message = (MessageLite)parser.parseFrom(codedInput, globalRegistry);
                try {
                    codedInput.checkLastTagWas(0);
                    return message;
                }
                catch (InvalidProtocolBufferException e) {
                    e.setUnfinishedMessage(message);
                    throw e;
                }
            }
        };
    }

    public static <T extends MessageLite> Metadata.BinaryMarshaller<T> metadataMarshaller(final T instance) {
        return new Metadata.BinaryMarshaller<T>(){

            public byte[] toBytes(T value) {
                return value.toByteArray();
            }

            public T parseBytes(byte[] serialized) {
                try {
                    return (MessageLite)instance.getParserForType().parseFrom(serialized, globalRegistry);
                }
                catch (InvalidProtocolBufferException ipbe) {
                    throw new IllegalArgumentException(ipbe);
                }
            }
        };
    }

    private ProtoLiteUtils() {
    }
}

