/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.ReadFrom;
import io.lettuce.core.internal.LettuceLists;
import io.lettuce.core.models.role.RedisInstance;
import io.lettuce.core.models.role.RedisNodeDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

class ReadFromImpl {
    private static final Predicate<RedisNodeDescription> IS_MASTER = node -> node.getRole() == RedisInstance.Role.MASTER;
    private static final Predicate<RedisNodeDescription> IS_REPLICA = node -> node.getRole() == RedisInstance.Role.SLAVE;

    ReadFromImpl() {
    }

    static class UnorderedPredicateReadFromAdapter
    extends OrderedPredicateReadFromAdapter {
        @SafeVarargs
        UnorderedPredicateReadFromAdapter(Predicate<RedisNodeDescription> ... predicates) {
            super(predicates);
        }

        @Override
        protected boolean isOrderSensitive() {
            return false;
        }
    }

    static class OrderedPredicateReadFromAdapter
    extends ReadFrom {
        private final Predicate<RedisNodeDescription>[] predicates;

        @SafeVarargs
        OrderedPredicateReadFromAdapter(Predicate<RedisNodeDescription> ... predicates) {
            this.predicates = predicates;
        }

        @Override
        public List<RedisNodeDescription> select(ReadFrom.Nodes nodes) {
            ArrayList<RedisNodeDescription> result = new ArrayList<RedisNodeDescription>(nodes.getNodes().size());
            for (Predicate<RedisNodeDescription> predicate : this.predicates) {
                for (RedisNodeDescription node : nodes) {
                    if (!predicate.test(node)) continue;
                    result.add(node);
                }
            }
            return result;
        }

        @Override
        protected boolean isOrderSensitive() {
            return true;
        }
    }

    static final class ReadFromAnyNode
    extends UnorderedPredicateReadFromAdapter {
        public ReadFromAnyNode() {
            super(x -> true);
        }
    }

    static final class ReadFromNearest
    extends ReadFrom {
        ReadFromNearest() {
        }

        @Override
        public List<RedisNodeDescription> select(ReadFrom.Nodes nodes) {
            return nodes.getNodes();
        }

        @Override
        protected boolean isOrderSensitive() {
            return true;
        }
    }

    static final class ReadFromReplicaPreferred
    extends OrderedPredicateReadFromAdapter {
        ReadFromReplicaPreferred() {
            super(IS_REPLICA, IS_MASTER);
        }
    }

    static final class ReadFromReplica
    extends OrderedPredicateReadFromAdapter {
        ReadFromReplica() {
            super(IS_REPLICA);
        }
    }

    static final class ReadFromMasterPreferred
    extends OrderedPredicateReadFromAdapter {
        ReadFromMasterPreferred() {
            super(IS_MASTER, IS_REPLICA);
        }
    }

    static final class ReadFromMaster
    extends ReadFrom {
        ReadFromMaster() {
        }

        @Override
        public List<RedisNodeDescription> select(ReadFrom.Nodes nodes) {
            for (RedisNodeDescription node : nodes) {
                if (node.getRole() != RedisInstance.Role.MASTER) continue;
                return LettuceLists.newList(node);
            }
            return Collections.emptyList();
        }
    }
}

