/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.java.spring.zipkin.starter;

import brave.Tracing;
import brave.opentracing.BraveTracer;
import brave.sampler.BoundarySampler;
import brave.sampler.CountingSampler;
import brave.sampler.Sampler;
import io.opentracing.Tracer;
import io.opentracing.contrib.java.spring.zipkin.starter.ZipkinConfigurationProperties;
import io.opentracing.contrib.java.spring.zipkin.starter.ZipkinTracerCustomizer;
import io.opentracing.contrib.spring.tracer.configuration.TracerAutoConfiguration;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.Sender;
import zipkin2.reporter.okhttp3.OkHttpSender;

@Configuration
@ConditionalOnClass(value={BraveTracer.class})
@ConditionalOnMissingBean(value={Tracer.class})
@ConditionalOnProperty(value={"opentracing.zipkin.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureBefore(value={TracerAutoConfiguration.class})
@EnableConfigurationProperties(value={ZipkinConfigurationProperties.class})
public class ZipkinAutoConfiguration {
    @Autowired(required=false)
    private List<ZipkinTracerCustomizer> tracerCustomizers = Collections.emptyList();
    @Value(value="${spring.application.name:unknown-spring-boot}")
    private String serviceName;

    @Bean
    @ConditionalOnMissingBean
    public Tracer tracer(Reporter<Span> reporter, Sampler sampler) {
        Tracing.Builder builder = Tracing.newBuilder().sampler(sampler).localServiceName(this.serviceName).spanReporter(reporter);
        this.tracerCustomizers.forEach(c -> c.customize(builder));
        return BraveTracer.create((Tracing)builder.build());
    }

    @Bean
    @ConditionalOnMissingBean
    public Reporter<Span> reporter(ZipkinConfigurationProperties properties) {
        String url = properties.getHttpSender().getBaseUrl();
        if (properties.getHttpSender().getEncoder().equals((Object)SpanBytesEncoder.JSON_V2) || properties.getHttpSender().getEncoder().equals((Object)SpanBytesEncoder.PROTO3)) {
            url = url + (url.endsWith("/") ? "" : "/") + "api/v2/spans";
        } else if (properties.getHttpSender().getEncoder().equals((Object)SpanBytesEncoder.JSON_V1)) {
            url = url + (url.endsWith("/") ? "" : "/") + "api/v1/spans";
        }
        OkHttpSender sender = OkHttpSender.newBuilder().endpoint(url).encoding(properties.getHttpSender().getEncoder().encoding()).build();
        return AsyncReporter.builder((Sender)sender).build((BytesEncoder)properties.getHttpSender().getEncoder());
    }

    @Bean
    @ConditionalOnMissingBean
    public Sampler sampler(ZipkinConfigurationProperties properties) {
        if (properties.getBoundarySampler().getRate() != null) {
            return BoundarySampler.create((float)properties.getBoundarySampler().getRate().floatValue());
        }
        if (properties.getCountingSampler().getRate() != null) {
            return CountingSampler.create((float)properties.getCountingSampler().getRate().floatValue());
        }
        return Sampler.ALWAYS_SAMPLE;
    }
}

