/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.java.spring.zipkin.starter;

import org.springframework.boot.context.properties.ConfigurationProperties;
import zipkin2.codec.SpanBytesEncoder;

@ConfigurationProperties(value="opentracing.zipkin")
public class ZipkinConfigurationProperties {
    private final HttpSender httpSender = new HttpSender();
    private final BoundarySampler boundarySampler = new BoundarySampler();
    private final CountingSampler countingSampler = new CountingSampler();
    private boolean enabled = true;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public HttpSender getHttpSender() {
        return this.httpSender;
    }

    public BoundarySampler getBoundarySampler() {
        return this.boundarySampler;
    }

    public CountingSampler getCountingSampler() {
        return this.countingSampler;
    }

    public static class CountingSampler {
        private Float rate;

        public Float getRate() {
            return this.rate;
        }

        public void setRate(Float rate) {
            this.rate = rate;
        }
    }

    public static class BoundarySampler {
        private Float rate;

        public Float getRate() {
            return this.rate;
        }

        public void setRate(Float rate) {
            this.rate = rate;
        }
    }

    public static class HttpSender {
        private String baseUrl = "http://localhost:9411/";
        private SpanBytesEncoder encoder = SpanBytesEncoder.JSON_V2;

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public void setBaseUrl(String url) {
            this.baseUrl = url;
        }

        public SpanBytesEncoder getEncoder() {
            return this.encoder;
        }

        public void setEncoder(SpanBytesEncoder encoder) {
            this.encoder = encoder;
        }
    }
}

