/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.urlresolver.matchers;

import io.swagger.parser.urlresolver.utils.NetUtils;
import java.net.IDN;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class UrlPatternMatcher {
    private final List<String> patterns = new ArrayList<String>();

    public UrlPatternMatcher(List<String> patterns) {
        patterns.forEach(pattern -> {
            String port;
            String patternLower = pattern.toLowerCase();
            String hostAndPort = pattern.contains(":") ? patternLower : patternLower + ":*";
            String[] split = hostAndPort.split(":");
            String host = Character.isDigit(split[0].charAt(0)) ? split[0] : IDN.toASCII(split[0], 1);
            String string = port = split.length > 1 ? split[1] : "*";
            if (host.length() > 1 && !NetUtils.isIPv4(host.replace("*", "0")) && host.endsWith("*")) {
                return;
            }
            this.patterns.add(String.format("%s:%s", host, port));
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(String url) {
        String hostAndPort;
        URL parsed;
        try {
            parsed = new URL(url.toLowerCase());
        }
        catch (MalformedURLException e) {
            return false;
        }
        String host = IDN.toASCII(parsed.getHost(), 1);
        if (parsed.getPort() == -1) {
            if (parsed.getProtocol().equals("http")) {
                hostAndPort = host + ":80";
                return this.patterns.stream().anyMatch(pattern -> FilenameUtils.wildcardMatch((String)hostAndPort, (String)pattern));
            } else {
                if (!parsed.getProtocol().equals("https")) return false;
                hostAndPort = host + ":443";
            }
            return this.patterns.stream().anyMatch(pattern -> FilenameUtils.wildcardMatch((String)hostAndPort, (String)pattern));
        } else {
            hostAndPort = host + ":" + parsed.getPort();
        }
        return this.patterns.stream().anyMatch(pattern -> FilenameUtils.wildcardMatch((String)hostAndPort, (String)pattern));
    }
}

