/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.builders;

import java.awt.Dimension;
import java.awt.image.BufferedImage;

public final class BufferedImageBuilder {
    private static final int DEFAULT_TYPE = 2;
    private int imageType;
    private int width;
    private int height;

    public BufferedImageBuilder(Dimension dimension) {
        this(dimension.width, dimension.height);
    }

    public BufferedImageBuilder(Dimension dimension, int n) {
        this(dimension.width, dimension.height, n);
    }

    public BufferedImageBuilder(int n, int n2) {
        this(n, n2, 2);
    }

    public BufferedImageBuilder(int n, int n2, int n3) {
        this.size(n, n2);
        this.imageType(n3);
    }

    public BufferedImage build() {
        return new BufferedImage(this.width, this.height, this.imageType);
    }

    public BufferedImageBuilder imageType(int n) {
        if (n == 0) {
            n = 2;
        }
        this.imageType = n;
        return this;
    }

    public BufferedImageBuilder size(int n, int n2) {
        this.width(n);
        this.height(n2);
        return this;
    }

    public BufferedImageBuilder width(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Width must be greater than 0.");
        }
        this.width = n;
        return this;
    }

    public BufferedImageBuilder height(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Height must be greater than 0.");
        }
        this.height = n;
        return this;
    }
}

