/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.NonExistentPartition$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionStateMachine;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.TopicDeletionManager$;
import kafka.controller.TopicDeletionManager$$anonfun$kafka$controller$TopicDeletionManager$;
import kafka.controller.TopicDeletionManager$DeleteTopicsThread$;
import kafka.server.ConfigType$;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ShutdownableThread;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\u0015d\u0001B\u0001\u0003\u0001\u001d\u0011A\u0003V8qS\u000e$U\r\\3uS>tW*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\u0005\t\u0007\u0001\u0011\t\u0011)A\u0005+A\u0011acF\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe\"A!\u0004\u0001B\u0001B\u0003%1$\u0001\rj]&$\u0018.\u00197U_BL7m\u001d+p\u0005\u0016$U\r\\3uK\u0012\u00042\u0001H\u0010\"\u001b\u0005i\"B\u0001\u0010\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Au\u00111aU3u!\t\u0011SE\u0004\u0002\nG%\u0011AEC\u0001\u0007!J,G-\u001a4\n\u0005\u0019:#AB*ue&twM\u0003\u0002%\u0015!A\u0011\u0006\u0001B\u0001B\u0003%1$\u0001\u0012j]&$\u0018.\u00197U_BL7m]%oK2Lw-\u001b2mK\u001a{'\u000fR3mKRLwN\u001c\u0005\u0006W\u0001!\t\u0001L\u0001\u0007y%t\u0017\u000e\u001e \u0015\t5rs\u0006\r\t\u0003-\u0001AQa\u0001\u0016A\u0002UAqA\u0007\u0016\u0011\u0002\u0003\u00071\u0004C\u0004*UA\u0005\t\u0019A\u000e\t\u000fI\u0002!\u0019!C\u0001g\u0005\t2m\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0016\u0003Q\u0002\"AF\u001b\n\u0005Y\u0012!!E\"p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yi\"1\u0001\b\u0001Q\u0001\nQ\n!cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=uA!9!\b\u0001b\u0001\n\u0003Y\u0014!\u00069beRLG/[8o'R\fG/Z'bG\"Lg.Z\u000b\u0002yA\u0011a#P\u0005\u0003}\t\u0011Q\u0003U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tW\r\u0003\u0004A\u0001\u0001\u0006I\u0001P\u0001\u0017a\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8fA!9!\t\u0001b\u0001\n\u0003\u0019\u0015a\u0005:fa2L7-Y*uCR,W*Y2iS:,W#\u0001#\u0011\u0005Y)\u0015B\u0001$\u0003\u0005M\u0011V\r\u001d7jG\u0006\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f\u0011\u0019A\u0005\u0001)A\u0005\t\u0006!\"/\u001a9mS\u000e\f7\u000b^1uK6\u000b7\r[5oK\u0002BqA\u0013\u0001C\u0002\u0013\u00051*\u0001\u0006eK2,G/\u001a'pG.,\u0012\u0001\u0014\t\u0003\u001bZk\u0011A\u0014\u0006\u0003\u001fB\u000bQ\u0001\\8dWNT!!\u0015*\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002T)\u0006!Q\u000f^5m\u0015\u0005)\u0016\u0001\u00026bm\u0006L!a\u0016(\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0011\u0019I\u0006\u0001)A\u0005\u0019\u0006YA-\u001a7fi\u0016dunY6!\u0011\u001dY\u0006A1A\u0005\u0002q\u000b\u0001\u0003Z3mKR,Gk\u001c9jGN\u001cuN\u001c3\u0016\u0003u\u0003\"!\u00140\n\u0005}s%!C\"p]\u0012LG/[8o\u0011\u0019\t\u0007\u0001)A\u0005;\u0006\tB-\u001a7fi\u0016$v\u000e]5dg\u000e{g\u000e\u001a\u0011\t\u000f\r\u0004!\u0019!C\u0001I\u00069B-\u001a7fi\u0016$v\u000e]5d'R\fG/Z\"iC:<W\rZ\u000b\u0002KB\u0011a-[\u0007\u0002O*\u0011\u0001\u000eU\u0001\u0007CR|W.[2\n\u0005)<'!D!u_6L7MQ8pY\u0016\fg\u000e\u0003\u0004m\u0001\u0001\u0006I!Z\u0001\u0019I\u0016dW\r^3U_BL7m\u0015;bi\u0016\u001c\u0005.\u00198hK\u0012\u0004\u0003b\u00028\u0001\u0001\u0004%\ta\\\u0001\u0013I\u0016dW\r^3U_BL7m\u001d+ie\u0016\fG-F\u0001q!\t\t(/D\u0001\u0001\r\u0011\u0019\b\u0001\u0001;\u0003%\u0011+G.\u001a;f)>\u0004\u0018nY:UQJ,\u0017\rZ\n\u0003eV\u0004\"a\u0004<\n\u0005]\u0004\"AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012DQa\u000b:\u0005\u0002e$\u0012\u0001\u001d\u0005\bwJ\u0014\r\u0011\"\u0001}\u0003\u001dQ8.\u0016;jYN,\u0012! \t\u0003\u001fyL!a \t\u0003\u000fi[W\u000b^5mg\"9\u00111\u0001:!\u0002\u0013i\u0018\u0001\u0003>l+RLGn\u001d\u0011\t\u000f\u0005\u001d!\u000f\"\u0011\u0002\n\u00051Am\\,pe.$\"!a\u0003\u0011\u0007%\ti!C\u0002\u0002\u0010)\u0011A!\u00168ji\"I\u00111\u0003\u0001A\u0002\u0013\u0005\u0011QC\u0001\u0017I\u0016dW\r^3U_BL7m\u001d+ie\u0016\fGm\u0018\u0013fcR!\u00111BA\f\u0011%\tI\"!\u0005\u0002\u0002\u0003\u0007\u0001/A\u0002yIEBq!!\b\u0001A\u0003&\u0001/A\neK2,G/\u001a+pa&\u001c7\u000f\u00165sK\u0006$\u0007\u0005C\u0005\u0002\"\u0001\u0011\r\u0011\"\u0001\u0002$\u0005!\u0012n\u001d#fY\u0016$X\rV8qS\u000e,e.\u00192mK\u0012,\"!!\n\u0011\t\u0005\u001d\u0012QF\u0007\u0003\u0003SQ1!a\u000bU\u0003\u0011a\u0017M\\4\n\t\u0005=\u0012\u0011\u0006\u0002\b\u0005>|G.Z1o\u0011!\t\u0019\u0004\u0001Q\u0001\n\u0005\u0015\u0012!F5t\t\u0016dW\r^3U_BL7-\u00128bE2,G\r\t\u0005\n\u0003o\u0001!\u0019!C\u0001\u0003s\t\u0011\u0003^8qS\u000e\u001cHk\u001c\"f\t\u0016dW\r^3e+\t\tY\u0004E\u0003\u0002>\u0005\r\u0013%\u0004\u0002\u0002@)\u0019\u0011\u0011I\u000f\u0002\u000f5,H/\u00192mK&\u0019\u0001%a\u0010\t\u0011\u0005\u001d\u0003\u0001)A\u0005\u0003w\t!\u0003^8qS\u000e\u001cHk\u001c\"f\t\u0016dW\r^3eA!I\u00111\n\u0001C\u0002\u0013\u0005\u0011\u0011H\u0001\u001ci>\u0004\u0018nY:J]\u0016d\u0017nZ5cY\u00164uN\u001d#fY\u0016$\u0018n\u001c8\t\u0011\u0005=\u0003\u0001)A\u0005\u0003w\tA\u0004^8qS\u000e\u001c\u0018J\\3mS\u001eL'\r\\3G_J$U\r\\3uS>t\u0007\u0005C\u0005\u0002T\u0001\u0011\r\u0011\"\u0001\u0002V\u0005)\u0002/\u0019:uSRLwN\\:U_\n+G)\u001a7fi\u0016$WCAA,!\u0019\ti$a\u0011\u0002ZA!\u00111LA1\u001b\t\tiFC\u0002\u0002`\u0011\taaY8n[>t\u0017\u0002BA2\u0003;\u0012\u0011\u0003V8qS\u000e\fe\u000e\u001a)beRLG/[8o\u0011!\t9\u0007\u0001Q\u0001\n\u0005]\u0013A\u00069beRLG/[8ogR{')\u001a#fY\u0016$X\r\u001a\u0011\t\u000f\u0005-\u0004\u0001\"\u0001\u0002\n\u0005)1\u000f^1si\"9\u0011q\u000e\u0001\u0005\u0002\u0005%\u0011\u0001C:ikR$wn\u001e8\t\u000f\u0005M\u0004\u0001\"\u0001\u0002v\u0005ARM\\9vKV,Gk\u001c9jGN4uN\u001d#fY\u0016$\u0018n\u001c8\u0015\t\u0005-\u0011q\u000f\u0005\b\u0003s\n\t\b1\u0001\u001c\u0003\u0019!x\u000e]5dg\"9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0014a\u0006:fgVlW\rR3mKRLwN\u001c$peR{\u0007/[2t)\u0011\tY!!!\t\u0013\u0005e\u00141\u0010I\u0001\u0002\u0004Y\u0002bBAC\u0001\u0011\u0005\u0011qQ\u0001\u0014M\u0006LGNU3qY&\u001c\u0017\rR3mKRLwN\u001c\u000b\u0005\u0003\u0017\tI\t\u0003\u0005\u0002\f\u0006\r\u0005\u0019AAG\u0003!\u0011X\r\u001d7jG\u0006\u001c\b\u0003\u0002\u000f \u0003\u001f\u00032AFAI\u0013\r\t\u0019J\u0001\u0002\u0014!\u0006\u0014H/\u001b;j_:\fe\u000e\u001a*fa2L7-\u0019\u0005\b\u0003/\u0003A\u0011AAM\u0003yi\u0017M]6U_BL7-\u00138fY&<\u0017N\u00197f\r>\u0014H)\u001a7fi&|g\u000e\u0006\u0003\u0002\f\u0005m\u0005bBA=\u0003+\u0003\ra\u0007\u0005\b\u0003?\u0003A\u0011AAQ\u0003qI7\u000fV8qS\u000eLe.\u001a7jO&\u0014G.\u001a$pe\u0012+G.\u001a;j_:$B!a)\u0002(B\u0019\u0011\"!*\n\u0007\u0005=\"\u0002C\u0004\u0002*\u0006u\u0005\u0019A\u0011\u0002\u000bQ|\u0007/[2\t\u000f\u00055\u0006\u0001\"\u0001\u00020\u0006I\u0012n\u001d+pa&\u001cG)\u001a7fi&|g.\u00138Qe><'/Z:t)\u0011\t\u0019+!-\t\u000f\u0005%\u00161\u0016a\u0001C!9\u0011Q\u0017\u0001\u0005\u0002\u0005]\u0016AF5t!\u0006\u0014H/\u001b;j_:$vNQ3EK2,G/\u001a3\u0015\t\u0005\r\u0016\u0011\u0018\u0005\t\u0003w\u000b\u0019\f1\u0001\u0002Z\u0005\tBo\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\t\u000f\u0005}\u0006\u0001\"\u0001\u0002B\u0006Q\u0012n\u001d+pa&\u001c\u0017+^3vK\u0012,\u0006OR8s\t\u0016dW\r^5p]R!\u00111UAb\u0011\u001d\tI+!0A\u0002\u0005Bq!a2\u0001\t\u0013\tI!\u0001\u0010bo\u0006LG\u000fV8qS\u000e$U\r\\3uS>tgj\u001c;jM&\u001c\u0017\r^5p]\"9\u00111\u001a\u0001\u0005\n\u0005%\u0011!\u0007:fgVlW\rV8qS\u000e$U\r\\3uS>tG\u000b\u001b:fC\u0012Dq!a4\u0001\t\u0013\t\t.A\fd_6\u0004H.\u001a;f%\u0016\u0004H.[2b\t\u0016dW\r^5p]R!\u00111BAj\u0011!\tY)!4A\u0002\u00055\u0005bBAl\u0001\u0011%\u0011\u0011\\\u0001\u001bSN$v\u000e]5d\u000b2Lw-\u001b2mK\u001a{'\u000fR3mKRLwN\u001c\u000b\u0005\u0003G\u000bY\u000eC\u0004\u0002*\u0006U\u0007\u0019A\u0011\t\u000f\u0005}\u0007\u0001\"\u0003\u0002b\u0006IR.\u0019:l)>\u0004\u0018n\u0019$pe\u0012+G.\u001a;j_:\u0014V\r\u001e:z)\u0011\tY!a9\t\u000f\u0005%\u0016Q\u001ca\u0001C!9\u0011q\u001d\u0001\u0005\n\u0005%\u0018aE2p[BdW\r^3EK2,G/\u001a+pa&\u001cG\u0003BA\u0006\u0003WDq!!+\u0002f\u0002\u0007\u0011\u0005C\u0004\u0002p\u0002!I!!=\u0002\u001f=tGk\u001c9jG\u0012+G.\u001a;j_:$B!a\u0003\u0002t\"9\u0011\u0011PAw\u0001\u0004Y\u0002bBA|\u0001\u0011%\u0011\u0011`\u0001\u0015gR\f'\u000f\u001e*fa2L7-\u0019#fY\u0016$\u0018n\u001c8\u0015\t\u0005-\u00111 \u0005\t\u0003{\f)\u00101\u0001\u0002\u000e\u0006a\"/\u001a9mS\u000e\f7OR8s)>\u0004\u0018nY:U_\n+G)\u001a7fi\u0016$\u0007b\u0002B\u0001\u0001\u0011%!1A\u0001\u0014_:\u0004\u0016M\u001d;ji&|g\u000eR3mKRLwN\u001c\u000b\u0005\u0003\u0017\u0011)\u0001\u0003\u0005\u0002T\u0005}\b\u0019\u0001B\u0004!\u0011ar$!\u0017\t\u000f\t-\u0001\u0001\"\u0003\u0003\u000e\u0005qB-\u001a7fi\u0016$v\u000e]5d'R|\u0007OU3qY&\u001c\u0017mQ1mY\n\f7m\u001b\u000b\u0007\u0003\u0017\u0011yAa\u000b\t\u0011\tE!\u0011\u0002a\u0001\u0005'\tac\u001d;paJ+\u0007\u000f\\5dCJ+7\u000f]8og\u0016|%M\u001b\t\u0005\u0005+\u00119#\u0004\u0002\u0003\u0018)!!\u0011\u0004B\u000e\u0003!\u0011X-];fgR\u001c(\u0002BA0\u0005;Q1!\u0002B\u0010\u0015\u0011\u0011\tCa\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\u0011)#A\u0002pe\u001eLAA!\u000b\u0003\u0018\t\u0001\u0012IY:ue\u0006\u001cGOU3ta>t7/\u001a\u0005\t\u0005[\u0011I\u00011\u0001\u00030\u0005I!/\u001a9mS\u000e\f\u0017\n\u001a\t\u0004\u0013\tE\u0012b\u0001B\u001a\u0015\t\u0019\u0011J\u001c;\t\u0013\t]\u0002!%A\u0005\u0002\te\u0012!\t:fgVlW\rR3mKRLwN\u001c$peR{\u0007/[2tI\u0011,g-Y;mi\u0012\nTC\u0001B\u001eU\rY\"QH\u0016\u0003\u0005\u007f\u0001BA!\u0011\u0003L5\u0011!1\t\u0006\u0005\u0005\u000b\u00129%A\u0005v]\u000eDWmY6fI*\u0019!\u0011\n\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003N\t\r#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u001eI!\u0011\u000b\u0002\u0002\u0002#\u0005!1K\u0001\u0015)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8NC:\fw-\u001a:\u0011\u0007Y\u0011)F\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012\u0001B,'\r\u0011)\u0006\u0003\u0005\bW\tUC\u0011\u0001B.)\t\u0011\u0019\u0006\u0003\u0006\u0003`\tU\u0013\u0013!C\u0001\u0005s\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0004B\u0003B2\u0005+\n\n\u0011\"\u0001\u0003:\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\u0002")
public class TopicDeletionManager
implements Logging {
    public final KafkaController kafka$controller$TopicDeletionManager$$controller;
    private final ControllerContext controllerContext;
    private final PartitionStateMachine partitionStateMachine;
    private final ReplicaStateMachine replicaStateMachine;
    private final ReentrantLock deleteLock;
    private final Condition deleteTopicsCond;
    private final AtomicBoolean deleteTopicStateChanged;
    private DeleteTopicsThread deleteTopicsThread;
    private final Boolean isDeleteTopicEnabled;
    private final scala.collection.mutable.Set<String> topicsToBeDeleted;
    private final scala.collection.mutable.Set<String> topicsIneligibleForDeletion;
    private final scala.collection.mutable.Set<TopicAndPartition> partitionsToBeDeleted;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Set<String> $lessinit$greater$default$3() {
        return TopicDeletionManager$.MODULE$.$lessinit$greater$default$3();
    }

    public static Set<String> $lessinit$greater$default$2() {
        return TopicDeletionManager$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TopicDeletionManager topicDeletionManager = this;
        synchronized (topicDeletionManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public PartitionStateMachine partitionStateMachine() {
        return this.partitionStateMachine;
    }

    public ReplicaStateMachine replicaStateMachine() {
        return this.replicaStateMachine;
    }

    public ReentrantLock deleteLock() {
        return this.deleteLock;
    }

    public Condition deleteTopicsCond() {
        return this.deleteTopicsCond;
    }

    public AtomicBoolean deleteTopicStateChanged() {
        return this.deleteTopicStateChanged;
    }

    public DeleteTopicsThread deleteTopicsThread() {
        return this.deleteTopicsThread;
    }

    public void deleteTopicsThread_$eq(DeleteTopicsThread x$1) {
        this.deleteTopicsThread = x$1;
    }

    public Boolean isDeleteTopicEnabled() {
        return this.isDeleteTopicEnabled;
    }

    public scala.collection.mutable.Set<String> topicsToBeDeleted() {
        return this.topicsToBeDeleted;
    }

    public scala.collection.mutable.Set<String> topicsIneligibleForDeletion() {
        return this.topicsIneligibleForDeletion;
    }

    public scala.collection.mutable.Set<TopicAndPartition> partitionsToBeDeleted() {
        return this.partitionsToBeDeleted;
    }

    public void start() {
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) {
            this.deleteTopicsThread_$eq(new DeleteTopicsThread());
            if (this.topicsToBeDeleted().nonEmpty()) {
                this.deleteTopicStateChanged().set(true);
            }
            this.deleteTopicsThread().start();
        }
    }

    public void shutdown() {
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) && this.deleteTopicsThread().initiateShutdown()) {
            this.resumeTopicDeletionThread();
            this.deleteTopicsThread().awaitShutdown();
            this.topicsToBeDeleted().clear();
            this.partitionsToBeDeleted().clear();
            this.topicsIneligibleForDeletion().clear();
        }
    }

    public void enqueueTopicsForDeletion(Set<String> topics) {
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) {
            this.topicsToBeDeleted().$plus$plus$eq(topics);
            this.partitionsToBeDeleted().$plus$plus$eq((TraversableOnce)topics.flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicDeletionManager $outer;

                public final Set<TopicAndPartition> apply(String topic) {
                    return this.$outer.controllerContext().partitionsForTopic(topic);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Set$.MODULE$.canBuildFrom()));
            this.resumeTopicDeletionThread();
        }
    }

    public void resumeDeletionForTopics(Set<String> topics) {
        Set topicsToResumeDeletion;
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) && (topicsToResumeDeletion = (Set)topics.$amp(this.topicsToBeDeleted())).nonEmpty()) {
            this.topicsIneligibleForDeletion().$minus$minus$eq((TraversableOnce)topicsToResumeDeletion);
            this.resumeTopicDeletionThread();
        }
    }

    public Set<String> resumeDeletionForTopics$default$1() {
        return Set$.MODULE$.empty();
    }

    public void failReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set replicasThatFailedToDelete;
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) && (replicasThatFailedToDelete = (Set)replicas.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final boolean apply(PartitionAndReplica r) {
                return this.$outer.isTopicQueuedUpForDeletion(r.topic());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })).nonEmpty()) {
            Set topics = (Set)replicasThatFailedToDelete.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(PartitionAndReplica x$1) {
                    return x$1.topic();
                }
            }, Set$.MODULE$.canBuildFrom());
            this.debug((Function0<String>)new Serializable(this, replicasThatFailedToDelete, topics){
                public static final long serialVersionUID = 0L;
                private final Set replicasThatFailedToDelete$1;
                private final Set topics$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Deletion failed for replicas %s. Halting deletion for topics %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicasThatFailedToDelete$1.mkString(","), this.topics$1}));
                }
                {
                    this.replicasThatFailedToDelete$1 = replicasThatFailedToDelete$1;
                    this.topics$1 = topics$1;
                }
            });
            this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)replicasThatFailedToDelete, ReplicaDeletionIneligible$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
            this.markTopicIneligibleForDeletion((Set<String>)topics);
            this.resumeTopicDeletionThread();
        }
    }

    public void markTopicIneligibleForDeletion(Set<String> topics) {
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) {
            scala.collection.mutable.Set newTopicsToHaltDeletion = (scala.collection.mutable.Set)this.topicsToBeDeleted().$amp(topics);
            this.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)newTopicsToHaltDeletion);
            if (newTopicsToHaltDeletion.nonEmpty()) {
                this.info((Function0<String>)new Serializable(this, newTopicsToHaltDeletion){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.mutable.Set newTopicsToHaltDeletion$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Halted deletion of topics %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newTopicsToHaltDeletion$1.mkString(",")}));
                    }
                    {
                        this.newTopicsToHaltDeletion$1 = newTopicsToHaltDeletion$1;
                    }
                });
            }
        }
    }

    public boolean isTopicIneligibleForDeletion(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.topicsIneligibleForDeletion().contains((Object)topic) : true;
    }

    public boolean isTopicDeletionInProgress(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic) : false;
    }

    public boolean isPartitionToBeDeleted(TopicAndPartition topicAndPartition) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.partitionsToBeDeleted().contains((Object)topicAndPartition) : false;
    }

    public boolean isTopicQueuedUpForDeletion(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.topicsToBeDeleted().contains((Object)topic) : false;
    }

    public void kafka$controller$TopicDeletionManager$$awaitTopicDeletionNotification() {
        CoreUtils$.MODULE$.inLock(this.deleteLock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                while (this.$outer.deleteTopicsThread().isRunning().get() && !this.$outer.deleteTopicStateChanged().compareAndSet(true, false)) {
                    this.$outer.debug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Waiting for signal to start or continue topic deletion";
                        }
                    });
                    this.$outer.deleteTopicsCond().await();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private void resumeTopicDeletionThread() {
        this.deleteTopicStateChanged().set(true);
        CoreUtils$.MODULE$.inLock(this.deleteLock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.deleteTopicsCond().signal();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void kafka$controller$TopicDeletionManager$$completeReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set successfullyDeletedReplicas = (Set)replicas.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final boolean apply(PartitionAndReplica r) {
                return this.$outer.isTopicQueuedUpForDeletion(r.topic());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.debug((Function0<String>)new Serializable(this, successfullyDeletedReplicas){
            public static final long serialVersionUID = 0L;
            private final Set successfullyDeletedReplicas$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Deletion successfully completed for replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.successfullyDeletedReplicas$1.mkString(",")}));
            }
            {
                this.successfullyDeletedReplicas$1 = successfullyDeletedReplicas$1;
            }
        });
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)successfullyDeletedReplicas, ReplicaDeletionSuccessful$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
        this.resumeTopicDeletionThread();
    }

    public boolean kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(String topic) {
        return this.topicsToBeDeleted().contains((Object)topic) && !this.isTopicDeletionInProgress(topic) && !this.isTopicIneligibleForDeletion(topic);
    }

    public void kafka$controller$TopicDeletionManager$$markTopicForDeletionRetry(String topic) {
        Set<PartitionAndReplica> failedReplicas = this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionIneligible$.MODULE$);
        this.info((Function0<String>)new Serializable(this, topic, failedReplicas){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final Set failedReplicas$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Retrying delete topic for topic %s since replicas %s were not successfully deleted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.failedReplicas$1.mkString(",")}));
            }
            {
                this.topic$1 = topic$1;
                this.failedReplicas$1 = failedReplicas$1;
            }
        });
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges(failedReplicas, OfflineReplica$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
    }

    public void kafka$controller$TopicDeletionManager$$completeDeleteTopic(String topic) {
        this.partitionStateMachine().deregisterPartitionChangeListener(topic);
        Set<PartitionAndReplica> replicasForDeletedTopic = this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
        this.replicaStateMachine().handleStateChanges(replicasForDeletedTopic, NonExistentReplica$.MODULE$, this.replicaStateMachine().handleStateChanges$default$3());
        Set<TopicAndPartition> partitionsForDeletedTopic = this.controllerContext().partitionsForTopic(topic);
        this.partitionStateMachine().handleStateChanges(partitionsForDeletedTopic, OfflinePartition$.MODULE$, this.partitionStateMachine().handleStateChanges$default$3(), this.partitionStateMachine().handleStateChanges$default$4());
        this.partitionStateMachine().handleStateChanges(partitionsForDeletedTopic, NonExistentPartition$.MODULE$, this.partitionStateMachine().handleStateChanges$default$3(), this.partitionStateMachine().handleStateChanges$default$4());
        this.topicsToBeDeleted().$minus$eq((Object)topic);
        this.partitionsToBeDeleted().retain((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$2;

            public final boolean apply(TopicAndPartition x$2) {
                String string = x$2.topic();
                String string2 = this.topic$2;
                return string != null ? !string.equals(string2) : string2 != null;
            }
            {
                this.topic$2 = topic$2;
            }
        });
        ZkUtils zkUtils = this.controllerContext().zkUtils();
        zkUtils.zkClient().deleteRecursive(ZkUtils$.MODULE$.getTopicPath(topic));
        zkUtils.zkClient().deleteRecursive(ZkUtils$.MODULE$.getEntityConfigPath(ConfigType$.MODULE$.Topic(), topic));
        zkUtils.zkClient().delete(ZkUtils$.MODULE$.getDeleteTopicPath(topic));
        this.controllerContext().removeTopic(topic);
    }

    public void kafka$controller$TopicDeletionManager$$onTopicDeletion(Set<String> topics) {
        this.info((Function0<String>)new Serializable(this, topics){
            public static final long serialVersionUID = 0L;
            private final Set topics$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Topic deletion callback for %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topics$2.mkString(",")}));
            }
            {
                this.topics$2 = topics$2;
            }
        });
        Set partitions = (Set)topics.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final Set<TopicAndPartition> apply(String topic) {
                return this.$outer.controllerContext().partitionsForTopic(topic);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom());
        this.kafka$controller$TopicDeletionManager$$controller.sendUpdateMetadataRequest((Seq<Object>)this.controllerContext().liveOrShuttingDownBrokerIds().toSeq(), (Set<TopicAndPartition>)partitions);
        Map partitionReplicaAssignmentByTopic = this.controllerContext().partitionReplicaAssignment().groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<TopicAndPartition, Seq<Object>> p) {
                return ((TopicAndPartition)p._1()).topic();
            }
        });
        topics.foreach((Function1)new Serializable(this, partitionReplicaAssignmentByTopic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;
            private final Map partitionReplicaAssignmentByTopic$1;

            public final void apply(String topic) {
                this.$outer.kafka$controller$TopicDeletionManager$$onPartitionDeletion((Set<TopicAndPartition>)((MapLike)this.partitionReplicaAssignmentByTopic$1.apply((Object)topic)).keySet());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionReplicaAssignmentByTopic$1 = partitionReplicaAssignmentByTopic$1;
            }
        });
    }

    private void startReplicaDeletion(Set<PartitionAndReplica> replicasForTopicsToBeDeleted) {
        replicasForTopicsToBeDeleted.groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(PartitionAndReplica x$3) {
                return x$3.topic();
            }
        }).keys().foreach((Function1)new Serializable(this, replicasForTopicsToBeDeleted){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;
            private final Set replicasForTopicsToBeDeleted$1;

            public final void apply(String topic) {
                Set aliveReplicasForTopic = (Set)this.$outer.controllerContext().allLiveReplicas().filter((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final String topic$3;

                    public final boolean apply(PartitionAndReplica p) {
                        String string = p.topic();
                        String string2 = this.topic$3;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.topic$3 = topic$3;
                    }
                });
                Set deadReplicasForTopic = (Set)this.replicasForTopicsToBeDeleted$1.$minus$minus((GenTraversableOnce)aliveReplicasForTopic);
                Set<PartitionAndReplica> successfullyDeletedReplicas = this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
                Set replicasForDeletionRetry = (Set)aliveReplicasForTopic.$minus$minus(successfullyDeletedReplicas);
                this.$outer.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)deadReplicasForTopic, ReplicaDeletionIneligible$.MODULE$, this.$outer.replicaStateMachine().handleStateChanges$default$3());
                this.$outer.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)replicasForDeletionRetry, OfflineReplica$.MODULE$, this.$outer.replicaStateMachine().handleStateChanges$default$3());
                this.$outer.debug((Function0<String>)new Serializable(this, replicasForDeletionRetry){
                    public static final long serialVersionUID = 0L;
                    private final Set replicasForDeletionRetry$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Deletion started for replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicasForDeletionRetry$1.mkString(",")}));
                    }
                    {
                        this.replicasForDeletionRetry$1 = replicasForDeletionRetry$1;
                    }
                });
                this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)replicasForDeletionRetry, ReplicaDeletionStarted$.MODULE$, new Callbacks.CallbackBuilder().stopReplicaCallback((Function2<AbstractResponse, Object, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$startReplicaDeletion$2 $outer;

                    public final void apply(AbstractResponse stopReplicaResponseObj, int replicaId) {
                        this.$outer.kafka$controller$TopicDeletionManager$$anonfun$$$outer().kafka$controller$TopicDeletionManager$$deleteTopicStopReplicaCallback(stopReplicaResponseObj, replicaId);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).build());
                if (deadReplicasForTopic.nonEmpty()) {
                    this.$outer.debug((Function0<String>)new Serializable(this, deadReplicasForTopic, topic){
                        public static final long serialVersionUID = 0L;
                        private final Set deadReplicasForTopic$1;
                        private final String topic$3;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Dead Replicas (%s) found for topic %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.deadReplicasForTopic$1.mkString(","), this.topic$3}));
                        }
                        {
                            this.deadReplicasForTopic$1 = deadReplicasForTopic$1;
                            this.topic$3 = topic$3;
                        }
                    });
                    this.$outer.markTopicIneligibleForDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                }
            }

            public /* synthetic */ TopicDeletionManager kafka$controller$TopicDeletionManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replicasForTopicsToBeDeleted$1 = replicasForTopicsToBeDeleted$1;
            }
        });
    }

    public void kafka$controller$TopicDeletionManager$$onPartitionDeletion(Set<TopicAndPartition> partitionsToBeDeleted) {
        this.info((Function0<String>)new Serializable(this, partitionsToBeDeleted){
            public static final long serialVersionUID = 0L;
            private final Set partitionsToBeDeleted$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Partition deletion callback for %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionsToBeDeleted$1.mkString(",")}));
            }
            {
                this.partitionsToBeDeleted$1 = partitionsToBeDeleted$1;
            }
        });
        Set<PartitionAndReplica> replicasPerPartition = this.controllerContext().replicasForPartition(partitionsToBeDeleted);
        this.startReplicaDeletion(replicasPerPartition);
    }

    public void kafka$controller$TopicDeletionManager$$deleteTopicStopReplicaCallback(AbstractResponse stopReplicaResponseObj, int replicaId) {
        StopReplicaResponse stopReplicaResponse = (StopReplicaResponse)stopReplicaResponseObj;
        this.debug((Function0<String>)new Serializable(this, stopReplicaResponse){
            public static final long serialVersionUID = 0L;
            private final StopReplicaResponse stopReplicaResponse$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Delete topic callback invoked for %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.stopReplicaResponse$1}));
            }
            {
                this.stopReplicaResponse$1 = stopReplicaResponse$1;
            }
        });
        scala.collection.mutable.Map responseMap = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(stopReplicaResponse.responses()).asScala();
        Set partitionsInError = stopReplicaResponse.errorCode() != Errors.NONE.code() ? responseMap.keySet() : ((MapLike)responseMap.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicPartition, Short> x0$1) {
                Tuple2<TopicPartition, Short> tuple2 = x0$1;
                if (tuple2 != null) {
                    Short error = (Short)tuple2._2();
                    boolean bl = !BoxesRunTime.equalsNumObject((Number)error, (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code()));
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })).keySet();
        Set replicasInError = (Set)partitionsInError.map((Function1)new Serializable(this, replicaId){
            public static final long serialVersionUID = 0L;
            private final int replicaId$1;

            public final PartitionAndReplica apply(TopicPartition p) {
                return new PartitionAndReplica(p.topic(), p.partition(), this.replicaId$1);
            }
            {
                this.replicaId$1 = replicaId$1;
            }
        }, Set$.MODULE$.canBuildFrom());
        CoreUtils$.MODULE$.inLock(this.controllerContext().controllerLock(), new Serializable(this, replicaId, responseMap, partitionsInError, replicasInError){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;
            public final int replicaId$1;
            private final scala.collection.mutable.Map responseMap$1;
            private final Set partitionsInError$1;
            private final Set replicasInError$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.failReplicaDeletion((Set<PartitionAndReplica>)this.replicasInError$1);
                if (this.replicasInError$1.size() != this.responseMap$1.size()) {
                    Set deletedReplicas = (Set)this.responseMap$1.keySet().$minus$minus((GenTraversableOnce)this.partitionsInError$1);
                    this.$outer.kafka$controller$TopicDeletionManager$$completeReplicaDeletion((Set<PartitionAndReplica>)((Set)deletedReplicas.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$kafka$controller$TopicDeletionManager$$deleteTopicStopReplicaCallback$1 $outer;

                        public final PartitionAndReplica apply(TopicPartition p) {
                            return new PartitionAndReplica(p.topic(), p.partition(), this.$outer.replicaId$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Set$.MODULE$.canBuildFrom())));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replicaId$1 = replicaId$1;
                this.responseMap$1 = responseMap$1;
                this.partitionsInError$1 = partitionsInError$1;
                this.replicasInError$1 = replicasInError$1;
            }
        });
    }

    public TopicDeletionManager(KafkaController controller, Set<String> initialTopicsToBeDeleted, Set<String> initialTopicsIneligibleForDeletion) {
        scala.collection.mutable.Set set;
        this.kafka$controller$TopicDeletionManager$$controller = controller;
        Logging$class.$init$(this);
        this.logIdent_$eq(new StringBuilder().append((Object)"[Topic Deletion Manager ").append((Object)BoxesRunTime.boxToInteger((int)controller.config().brokerId())).append((Object)"], ").toString());
        this.controllerContext = controller.controllerContext();
        this.partitionStateMachine = controller.partitionStateMachine();
        this.replicaStateMachine = controller.replicaStateMachine();
        this.deleteLock = new ReentrantLock();
        this.deleteTopicsCond = this.deleteLock().newCondition();
        this.deleteTopicStateChanged = new AtomicBoolean(false);
        this.deleteTopicsThread = null;
        this.isDeleteTopicEnabled = controller.config().deleteTopicEnable();
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) {
            set = scala.collection.mutable.Set$.MODULE$.empty().$plus$plus(initialTopicsToBeDeleted);
        } else {
            ZkUtils zkUtils = this.controllerContext().zkUtils();
            initialTopicsToBeDeleted.foreach((Function1)new Serializable(this, zkUtils){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicDeletionManager $outer;
                private final ZkUtils zkUtils$1;

                public final boolean apply(String topic) {
                    String deleteTopicPath = ZkUtils$.MODULE$.getDeleteTopicPath(topic);
                    this.$outer.info((Function0<String>)new Serializable(this, deleteTopicPath){
                        public static final long serialVersionUID = 0L;
                        private final String deleteTopicPath$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Removing ").append((Object)this.deleteTopicPath$1).append((Object)" since delete topic is disabled").toString();
                        }
                        {
                            this.deleteTopicPath$1 = deleteTopicPath$1;
                        }
                    });
                    return this.zkUtils$1.zkClient().delete(deleteTopicPath);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.zkUtils$1 = zkUtils$1;
                }
            });
            set = scala.collection.mutable.Set$.MODULE$.empty();
        }
        this.topicsToBeDeleted = set;
        this.topicsIneligibleForDeletion = scala.collection.mutable.Set$.MODULE$.empty().$plus$plus((GenTraversableOnce)initialTopicsIneligibleForDeletion.$amp(this.topicsToBeDeleted()));
        this.partitionsToBeDeleted = (scala.collection.mutable.Set)this.topicsToBeDeleted().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final Set<TopicAndPartition> apply(String topic) {
                return this.$outer.controllerContext().partitionsForTopic(topic);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, scala.collection.mutable.Set$.MODULE$.canBuildFrom());
    }

    public class DeleteTopicsThread
    extends ShutdownableThread {
        private final ZkUtils zkUtils;

        public ZkUtils zkUtils() {
            return this.zkUtils;
        }

        @Override
        public void doWork() {
            this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$awaitTopicDeletionNotification();
            if (this.isRunning().get()) {
                CoreUtils$.MODULE$.inLock(this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().controllerContext().controllerLock(), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DeleteTopicsThread $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        Set topicsQueuedForDeletion = Set$.MODULE$.empty().$plus$plus(this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().topicsToBeDeleted());
                        if (topicsQueuedForDeletion.nonEmpty()) {
                            this.$outer.info((Function0<String>)new Serializable(this, topicsQueuedForDeletion){
                                public static final long serialVersionUID = 0L;
                                private final Set topicsQueuedForDeletion$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Handling deletion for topics ").append((Object)this.topicsQueuedForDeletion$1.mkString(",")).toString();
                                }
                                {
                                    this.topicsQueuedForDeletion$1 = topicsQueuedForDeletion$1;
                                }
                            });
                        }
                        topicsQueuedForDeletion.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ DeleteTopicsThread$$anonfun$doWork$1 $outer;

                            public final void apply(String topic) {
                                if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().areAllReplicasForTopicDeleted(topic)) {
                                    this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$completeDeleteTopic(topic);
                                    this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)new Serializable(this, topic){
                                        public static final long serialVersionUID = 0L;
                                        private final String topic$4;

                                        public final String apply() {
                                            return new StringOps(Predef$.MODULE$.augmentString("Deletion of topic %s successfully completed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4}));
                                        }
                                        {
                                            this.topic$4 = topic$4;
                                        }
                                    });
                                } else if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic)) {
                                    Set<PartitionAndReplica> replicasInDeletionStartedState = this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionStarted$.MODULE$);
                                    Set replicaIds = (Set)replicasInDeletionStartedState.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply(PartitionAndReplica x$4) {
                                            return x$4.replica();
                                        }
                                    }, Set$.MODULE$.canBuildFrom());
                                    Set partitions = (Set)replicasInDeletionStartedState.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final TopicAndPartition apply(PartitionAndReplica r) {
                                            return new TopicAndPartition(r.topic(), r.partition());
                                        }
                                    }, Set$.MODULE$.canBuildFrom());
                                    this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)new Serializable(this, replicaIds, partitions, topic){
                                        public static final long serialVersionUID = 0L;
                                        private final Set replicaIds$1;
                                        private final Set partitions$1;
                                        private final String topic$4;

                                        public final String apply() {
                                            return new StringOps(Predef$.MODULE$.augmentString("Deletion for replicas %s for partition %s of topic %s in progress")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicaIds$1.mkString(","), this.partitions$1.mkString(","), this.topic$4}));
                                        }
                                        {
                                            this.replicaIds$1 = replicaIds$1;
                                            this.partitions$1 = partitions$1;
                                            this.topic$4 = topic$4;
                                        }
                                    });
                                } else if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAnyReplicaInState(topic, ReplicaDeletionIneligible$.MODULE$)) {
                                    this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$markTopicForDeletionRetry(topic);
                                }
                                if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(topic)) {
                                    this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)new Serializable(this, topic){
                                        public static final long serialVersionUID = 0L;
                                        private final String topic$4;

                                        public final String apply() {
                                            return new StringOps(Predef$.MODULE$.augmentString("Deletion of topic %s (re)started")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4}));
                                        }
                                        {
                                            this.topic$4 = topic$4;
                                        }
                                    });
                                    this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$onTopicDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                                } else if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().isTopicIneligibleForDeletion(topic)) {
                                    this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)new Serializable(this, topic){
                                        public static final long serialVersionUID = 0L;
                                        private final String topic$4;

                                        public final String apply() {
                                            return new StringOps(Predef$.MODULE$.augmentString("Not retrying deletion of topic %s at this time since it is marked ineligible for deletion")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4}));
                                        }
                                        {
                                            this.topic$4 = topic$4;
                                        }
                                    });
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ DeleteTopicsThread kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return;
            }
        }

        public /* synthetic */ TopicDeletionManager kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer() {
            return TopicDeletionManager.this;
        }

        public DeleteTopicsThread() {
            if (TopicDeletionManager.this == null) {
                throw null;
            }
            super(new StringBuilder().append((Object)"delete-topics-thread-").append((Object)BoxesRunTime.boxToInteger((int)TopicDeletionManager.this.kafka$controller$TopicDeletionManager$$controller.config().brokerId())).toString(), false);
            this.zkUtils = TopicDeletionManager.this.controllerContext().zkUtils();
        }
    }
}

