/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import kafka.log.Log;
import kafka.log.LogCleanerManager$;
import kafka.log.LogSegment;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.TopicPartition;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class LogCleanerManager$
implements Logging {
    public static final LogCleanerManager$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new LogCleanerManager$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogCleanerManager$ logCleanerManager$ = this;
        synchronized (logCleanerManager$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public boolean isCompactAndDelete(Log log) {
        return log.config().compact() && log.config().delete();
    }

    public Tuple2<Object, Object> cleanableOffsets(Log log, TopicPartition topicPartition, Map<TopicPartition, Object> lastClean, long now) {
        long l;
        long logStartOffset;
        Option lastCleanOffset = lastClean.get((Object)topicPartition);
        long offset = BoxesRunTime.unboxToLong((Object)lastCleanOffset.getOrElse((Function0)new Serializable(logStartOffset = ((LogSegment)log.logSegments().head()).baseOffset()){
            public static final long serialVersionUID = 0L;
            private final long logStartOffset$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.logStartOffset$1;
            }
            {
                this.logStartOffset$1 = logStartOffset$1;
            }
        }));
        if (offset < logStartOffset) {
            if (!this.isCompactAndDelete(log)) {
                this.warn((Function0<String>)new Serializable(logStartOffset, offset){
                    public static final long serialVersionUID = 0L;
                    private final long logStartOffset$1;
                    private final long offset$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resetting first dirty offset to log start offset ", " since the checkpointed offset ", " is invalid."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.logStartOffset$1), BoxesRunTime.boxToLong((long)this.offset$2)}));
                    }
                    {
                        this.logStartOffset$1 = logStartOffset$1;
                        this.offset$2 = offset$2;
                    }
                });
            }
            l = logStartOffset;
        } else {
            l = offset;
        }
        long firstDirtyOffset = l;
        Iterable<LogSegment> dirtyNonActiveSegments = log.logSegments(firstDirtyOffset, log.activeSegment().baseOffset());
        long compactionLagMs = package$.MODULE$.max(Predef$.MODULE$.Long2long(log.config().compactionLagMs()), 0L);
        long firstUncleanableDirtyOffset = BoxesRunTime.unboxToLong((Object)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)log.activeSegment().baseOffset())), compactionLagMs > 0L ? dirtyNonActiveSegments.find((Function1)new Serializable(log, now, compactionLagMs){
            public static final long serialVersionUID = 0L;
            public final Log log$1;
            public final long now$2;
            public final long compactionLagMs$1;

            /*
             * WARNING - void declaration
             */
            public final boolean apply(LogSegment s) {
                void var2_2;
                boolean isUncleanable = s.largestTimestamp() > this.now$2 - this.compactionLagMs$1;
                LogCleanerManager$.MODULE$.debug((Function0<String>)new Serializable(this, isUncleanable, s){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.10 $outer;
                    private final boolean isUncleanable$1;
                    private final LogSegment s$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking if log segment may be cleaned: log='", "' segment.baseOffset=", " segment.largestTimestamp=", "; now - compactionLag=", "; is uncleanable=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.log$1.name(), BoxesRunTime.boxToLong((long)this.s$1.baseOffset()), BoxesRunTime.boxToLong((long)this.s$1.largestTimestamp()), BoxesRunTime.boxToLong((long)(this.$outer.now$2 - this.$outer.compactionLagMs$1)), BoxesRunTime.boxToBoolean((boolean)this.isUncleanable$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.isUncleanable$1 = isUncleanable$1;
                        this.s$1 = s$1;
                    }
                });
                return (boolean)var2_2;
            }
            {
                this.log$1 = log$1;
                this.now$2 = now$2;
                this.compactionLagMs$1 = compactionLagMs$1;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$3) {
                return x$3.baseOffset();
            }
        }) : None$.MODULE$})).flatten((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(Option<Object> xo) {
                return Option$.MODULE$.option2Iterable(xo);
            }
        })).min((Ordering)Ordering.Long$.MODULE$));
        this.debug((Function0<String>)new Serializable(log, topicPartition, now, lastCleanOffset, firstDirtyOffset, firstUncleanableDirtyOffset){
            public static final long serialVersionUID = 0L;
            private final Log log$1;
            private final TopicPartition topicPartition$8;
            private final long now$2;
            private final Option lastCleanOffset$1;
            private final long firstDirtyOffset$1;
            private final long firstUncleanableDirtyOffset$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finding range of cleanable offsets for log=", " topicPartition=", ". Last clean offset=", " now=", " => firstDirtyOffset=", " firstUncleanableOffset=", " activeSegment.baseOffset=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log$1.name(), this.topicPartition$8, this.lastCleanOffset$1, BoxesRunTime.boxToLong((long)this.now$2), BoxesRunTime.boxToLong((long)this.firstDirtyOffset$1), BoxesRunTime.boxToLong((long)this.firstUncleanableDirtyOffset$1), BoxesRunTime.boxToLong((long)this.log$1.activeSegment().baseOffset())}));
            }
            {
                this.log$1 = log$1;
                this.topicPartition$8 = topicPartition$8;
                this.now$2 = now$2;
                this.lastCleanOffset$1 = lastCleanOffset$1;
                this.firstDirtyOffset$1 = firstDirtyOffset$1;
                this.firstUncleanableDirtyOffset$1 = firstUncleanableDirtyOffset$1;
            }
        });
        return new Tuple2.mcJJ.sp(firstDirtyOffset, firstUncleanableDirtyOffset);
    }

    private LogCleanerManager$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

