/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.blame;

import java.io.File;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.blame.AbstractBlameCommand;
import org.apache.maven.scm.command.blame.BlameScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.blame.GitBlameConsumer;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class GitBlameCommand
extends AbstractBlameCommand
implements GitCommand {
    protected ScmResult executeCommand(ScmProviderRepository repository, ScmFileSet workingDirectory, CommandParameters parameters) throws ScmException {
        CommandLineUtils.StringStreamConsumer stderr;
        GitBlameConsumer consumer;
        String filename = parameters.getString(CommandParameter.FILE);
        Commandline cl = GitBlameCommand.createCommandLine(workingDirectory.getBasedir(), filename, parameters.getBoolean(CommandParameter.IGNORE_WHITESPACE, false));
        int exitCode = GitCommandLineUtils.execute(cl, (StreamConsumer)(consumer = new GitBlameConsumer()), stderr = new CommandLineUtils.StringStreamConsumer());
        if (exitCode != 0) {
            return new BlameScmResult(cl.toString(), "The git blame command failed.", stderr.getOutput(), false);
        }
        return new BlameScmResult(cl.toString(), consumer.getLines());
    }

    public BlameScmResult executeBlameCommand(ScmProviderRepository repo, ScmFileSet workingDirectory, String filename) throws ScmException {
        CommandParameters commandParameters = new CommandParameters();
        commandParameters.setString(CommandParameter.FILE, filename);
        commandParameters.setString(CommandParameter.IGNORE_WHITESPACE, Boolean.FALSE.toString());
        return (BlameScmResult)this.execute(repo, workingDirectory, commandParameters);
    }

    protected static Commandline createCommandLine(File workingDirectory, String filename, boolean ignoreWhitespace) {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, "blame");
        cl.createArg().setValue("--porcelain");
        cl.createArg().setValue(filename);
        if (ignoreWhitespace) {
            cl.createArg().setValue("-w");
        }
        return cl;
    }
}

