/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.distsql.handler.query;

import com.google.gson.Gson;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryDataSourceRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryHeartBeatConfiguration;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.ShowDatabaseDiscoveryRulesStatement;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.rule.identifier.type.ExportableRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class DatabaseDiscoveryRuleQueryResultSet
implements DistSQLResultSet {
    private static final String GROUP_NAME = "group_name";
    private static final String DATA_SOURCE_NAMES = "data_source_names";
    private static final String PRIMARY_DATA_SOURCE_NAME = "primary_data_source_name";
    private static final String NAME = "name";
    private static final String DISCOVER_TYPE = "discovery_type";
    private static final String HEARTBEAT = "discovery_heartbeat";
    private Iterator<DatabaseDiscoveryDataSourceRuleConfiguration> data;
    private Map<String, ShardingSphereAlgorithmConfiguration> discoveryTypes;
    private Map<String, DatabaseDiscoveryHeartBeatConfiguration> discoveryHeartbeats;
    private Map<String, String> primaryDataSources;

    public void init(ShardingSphereMetaData metaData, SQLStatement sqlStatement) {
        Optional<DatabaseDiscoveryRuleConfiguration> ruleConfig = metaData.getRuleMetaData().getConfigurations().stream().filter(each -> each instanceof DatabaseDiscoveryRuleConfiguration).map(each -> (DatabaseDiscoveryRuleConfiguration)each).findAny();
        this.data = ruleConfig.map(optional -> optional.getDataSources().iterator()).orElseGet(Collections::emptyIterator);
        this.discoveryTypes = ruleConfig.map(DatabaseDiscoveryRuleConfiguration::getDiscoveryTypes).orElseGet(Collections::emptyMap);
        this.discoveryHeartbeats = ruleConfig.map(DatabaseDiscoveryRuleConfiguration::getDiscoveryHeartbeats).orElseGet(Collections::emptyMap);
        Optional<ExportableRule> exportableRule = metaData.getRuleMetaData().getRules().stream().filter(each -> each instanceof ExportableRule).filter(each -> ((ExportableRule)each).containExportableKey(Collections.singleton("primary_data_source"))).map(each -> (ExportableRule)each).findAny();
        this.primaryDataSources = (Map)exportableRule.map(optional -> optional.export("primary_data_source").orElseGet(Collections::emptyMap)).orElseGet(Collections::emptyMap);
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList(GROUP_NAME, DATA_SOURCE_NAMES, PRIMARY_DATA_SOURCE_NAME, DISCOVER_TYPE, HEARTBEAT);
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        DatabaseDiscoveryDataSourceRuleConfiguration dataSourceRuleConfig = this.data.next();
        LinkedHashMap<String, String> typeMap = new LinkedHashMap<String, String>();
        typeMap.put(NAME, dataSourceRuleConfig.getDiscoveryTypeName());
        typeMap.putAll(this.convertToMap(this.discoveryTypes.get(dataSourceRuleConfig.getDiscoveryTypeName())));
        LinkedHashMap<String, String> heartbeatMap = new LinkedHashMap<String, String>();
        heartbeatMap.put(NAME, dataSourceRuleConfig.getDiscoveryHeartbeatName());
        heartbeatMap.putAll(this.convertToMap(this.discoveryHeartbeats.get(dataSourceRuleConfig.getDiscoveryHeartbeatName())));
        String groupName = dataSourceRuleConfig.getGroupName();
        String primaryDataSourceName = null == this.primaryDataSources.get(groupName) ? "" : this.primaryDataSources.get(groupName);
        return Arrays.asList(groupName, String.join((CharSequence)",", dataSourceRuleConfig.getDataSourceNames()), primaryDataSourceName, typeMap, heartbeatMap);
    }

    private Map<String, String> convertToMap(Object obj) {
        if (obj == null) {
            return Collections.emptyMap();
        }
        return (Map)new Gson().fromJson(new Gson().toJson(obj), LinkedHashMap.class);
    }

    public String getType() {
        return ShowDatabaseDiscoveryRulesStatement.class.getName();
    }
}

