/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.distsql.handler.update;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.distsql.handler.converter.DatabaseDiscoveryRuleStatementConverter;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.segment.DatabaseDiscoveryTypeSegment;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.AlterDatabaseDiscoveryTypeStatement;
import org.apache.shardingsphere.dbdiscovery.spi.DatabaseDiscoveryType;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.distsql.exception.rule.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionAlterUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.typed.TypedSPIRegistry;

public final class AlterDatabaseDiscoveryTypeStatementUpdater
implements RuleDefinitionAlterUpdater<AlterDatabaseDiscoveryTypeStatement, DatabaseDiscoveryRuleConfiguration> {
    private static final String RULE_TYPE = "database discovery";

    public void checkSQLStatement(ShardingSphereMetaData shardingSphereMetaData, AlterDatabaseDiscoveryTypeStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        String schemaName = shardingSphereMetaData.getName();
        this.checkCurrentRuleConfiguration(schemaName, currentRuleConfig);
        this.checkDuplicateDiscoveryType(schemaName, sqlStatement);
        this.checkNotExistDiscoveryType(schemaName, sqlStatement, currentRuleConfig);
        this.checkInvalidDiscoverType(sqlStatement);
    }

    private void checkNotExistDiscoveryType(String schemaName, AlterDatabaseDiscoveryTypeStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        Set existTypes = currentRuleConfig.getDiscoveryTypes().keySet();
        Collection notExistTypes = sqlStatement.getTypes().stream().map(DatabaseDiscoveryTypeSegment::getDiscoveryTypeName).filter(each -> !existTypes.contains(each)).collect(Collectors.toSet());
        DistSQLException.predictionThrow((boolean)notExistTypes.isEmpty(), (DistSQLException)new RequiredRuleMissedException(RULE_TYPE, schemaName));
    }

    private void checkCurrentRuleConfiguration(String schemaName, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        DistSQLException.predictionThrow((null != currentRuleConfig ? 1 : 0) != 0, (DistSQLException)new RequiredRuleMissedException(RULE_TYPE, schemaName));
    }

    private void checkDuplicateDiscoveryType(String schemaName, AlterDatabaseDiscoveryTypeStatement sqlStatement) throws DistSQLException {
        Collection<String> duplicateTypeNames = this.getToBeAlteredDuplicateTypeNames(sqlStatement);
        DistSQLException.predictionThrow((boolean)duplicateTypeNames.isEmpty(), (DistSQLException)new DuplicateRuleException(RULE_TYPE, schemaName, duplicateTypeNames));
    }

    private Collection<String> getToBeAlteredDuplicateTypeNames(AlterDatabaseDiscoveryTypeStatement sqlStatement) {
        return sqlStatement.getTypes().stream().collect(Collectors.toMap(DatabaseDiscoveryTypeSegment::getDiscoveryTypeName, e -> 1, Integer::sum)).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private void checkInvalidDiscoverType(AlterDatabaseDiscoveryTypeStatement sqlStatement) throws DistSQLException {
        Collection invalidType = sqlStatement.getTypes().stream().map(each -> each.getAlgorithmSegment().getName()).distinct().filter(each -> !TypedSPIRegistry.findRegisteredService(DatabaseDiscoveryType.class, (String)each, (Properties)new Properties()).isPresent()).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)invalidType.isEmpty(), (DistSQLException)new InvalidAlgorithmConfigurationException(RULE_TYPE, invalidType));
    }

    public RuleConfiguration buildToBeAlteredRuleConfiguration(AlterDatabaseDiscoveryTypeStatement sqlStatement) {
        return DatabaseDiscoveryRuleStatementConverter.convertDiscoveryType(sqlStatement.getTypes());
    }

    public void updateCurrentRuleConfiguration(DatabaseDiscoveryRuleConfiguration currentRuleConfig, DatabaseDiscoveryRuleConfiguration toBeAlteredRuleConfig) {
        if (null != currentRuleConfig) {
            currentRuleConfig.getDiscoveryTypes().putAll(toBeAlteredRuleConfig.getDiscoveryTypes());
        }
    }

    public Class<DatabaseDiscoveryRuleConfiguration> getRuleConfigurationClass() {
        return DatabaseDiscoveryRuleConfiguration.class;
    }

    public String getType() {
        return AlterDatabaseDiscoveryTypeStatement.class.getName();
    }

    static {
        ShardingSphereServiceLoader.register(DatabaseDiscoveryType.class);
    }
}

