/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.parser.core.common;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.distsql.parser.autogen.CommonDistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.CommonDistSQLStatementParser;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.distsql.parser.segment.CacheOptionSegment;
import org.apache.shardingsphere.distsql.parser.segment.DataSourceSegment;
import org.apache.shardingsphere.distsql.parser.segment.TrafficRuleSegment;
import org.apache.shardingsphere.distsql.parser.segment.TransactionProviderSegment;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.ExportSchemaConfigurationStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.RefreshTableMetadataStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.alter.AlterSQLParserRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.alter.AlterTransactionRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.drop.DropTrafficRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.hint.ClearHintStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.set.SetInstanceStatusStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.set.SetVariableStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.show.ShowAllVariablesStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.show.ShowAuthorityRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.show.ShowInstanceModeStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.show.ShowInstanceStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.show.ShowSQLParserRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.show.ShowTableMetadataStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.show.ShowTrafficRulesStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.show.ShowTransactionRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.show.ShowVariableStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.alter.AlterResourceStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.create.AddResourceStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.create.AlterDefaultSingleTableRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.create.AlterTrafficRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.create.CreateDefaultSingleTableRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.create.CreateTrafficRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.drop.DropDefaultSingleTableRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.drop.DropResourceStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.CountSchemaRulesStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowResourcesStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowRulesUsedResourceStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowSingleTableRulesStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowSingleTableStatement;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.SchemaSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class CommonDistSQLStatementVisitor
extends CommonDistSQLStatementBaseVisitor<ASTNode>
implements SQLVisitor {
    @Override
    public ASTNode visitAddResource(CommonDistSQLStatementParser.AddResourceContext ctx) {
        return new AddResourceStatement((Collection)ctx.dataSource().stream().map(each -> (DataSourceSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitAlterResource(CommonDistSQLStatementParser.AlterResourceContext ctx) {
        return new AlterResourceStatement((Collection)ctx.dataSource().stream().map(each -> (DataSourceSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitShowTableMetadata(CommonDistSQLStatementParser.ShowTableMetadataContext ctx) {
        Collection tableNames = ctx.tableName().stream().map(each -> this.getIdentifierValue((ParseTree)each)).collect(Collectors.toSet());
        return new ShowTableMetadataStatement(tableNames, null == ctx.schemaName() ? null : (SchemaSegment)this.visit((ParseTree)ctx.schemaName()));
    }

    @Override
    public ASTNode visitDataSource(CommonDistSQLStatementParser.DataSourceContext ctx) {
        String url = null;
        String hostname = null;
        String port = null;
        String dbName = null;
        if (null != ctx.urlSource()) {
            url = new IdentifierValue(ctx.urlSource().url().getText()).getValue();
        }
        if (null != ctx.simpleSource()) {
            hostname = ctx.simpleSource().hostname().getText();
            port = ctx.simpleSource().port().getText();
            dbName = ctx.simpleSource().dbName().getText();
        }
        String password = null == ctx.password() ? "" : this.getPassword(ctx.password());
        Properties properties = this.getProperties(ctx.propertiesDefinition());
        return new DataSourceSegment(this.getIdentifierValue((ParseTree)ctx.dataSourceName()), url, hostname, port, dbName, ctx.user().getText(), password, properties);
    }

    private String getPassword(List<CommonDistSQLStatementParser.PasswordContext> passwordContexts) {
        return passwordContexts.stream().map(each -> new IdentifierValue(each.getText()).getValue()).collect(Collectors.joining(""));
    }

    @Override
    public ASTNode visitShowInstance(CommonDistSQLStatementParser.ShowInstanceContext ctx) {
        return new ShowInstanceStatement();
    }

    @Override
    public ASTNode visitShowInstanceMode(CommonDistSQLStatementParser.ShowInstanceModeContext ctx) {
        return new ShowInstanceModeStatement();
    }

    @Override
    public ASTNode visitCountSchemaRules(CommonDistSQLStatementParser.CountSchemaRulesContext ctx) {
        return new CountSchemaRulesStatement(null == ctx.schemaName() ? null : (SchemaSegment)this.visit((ParseTree)ctx.schemaName()));
    }

    @Override
    public ASTNode visitEnableInstance(CommonDistSQLStatementParser.EnableInstanceContext ctx) {
        return this.buildSetInstanceStatusStatement(ctx.ENABLE().getText().toUpperCase(), ctx.instanceDefination(), ctx.instanceId());
    }

    @Override
    public ASTNode visitDisableInstance(CommonDistSQLStatementParser.DisableInstanceContext ctx) {
        return this.buildSetInstanceStatusStatement(ctx.DISABLE().getText().toUpperCase(), ctx.instanceDefination(), ctx.instanceId());
    }

    private SetInstanceStatusStatement buildSetInstanceStatusStatement(String status, CommonDistSQLStatementParser.InstanceDefinationContext instanceDefinationContext, CommonDistSQLStatementParser.InstanceIdContext instanceIdContext) {
        String port;
        String ip;
        if (null != instanceDefinationContext) {
            ip = this.getIdentifierValue((ParseTree)instanceDefinationContext.ip());
            port = this.getIdentifierValue((ParseTree)instanceDefinationContext.port());
        } else {
            ip = this.getIdentifierValue((ParseTree)instanceIdContext.ip());
            port = this.getIdentifierValue((ParseTree)instanceIdContext.port());
        }
        return new SetInstanceStatusStatement(status, ip, port);
    }

    @Override
    public ASTNode visitCreateDefaultSingleTableRule(CommonDistSQLStatementParser.CreateDefaultSingleTableRuleContext ctx) {
        return new CreateDefaultSingleTableRuleStatement(this.getIdentifierValue((ParseTree)ctx.dataSourceName()));
    }

    @Override
    public ASTNode visitAlterDefaultSingleTableRule(CommonDistSQLStatementParser.AlterDefaultSingleTableRuleContext ctx) {
        return new AlterDefaultSingleTableRuleStatement(this.getIdentifierValue((ParseTree)ctx.dataSourceName()));
    }

    @Override
    public ASTNode visitDropDefaultSingleTableRule(CommonDistSQLStatementParser.DropDefaultSingleTableRuleContext ctx) {
        return new DropDefaultSingleTableRuleStatement();
    }

    private Properties getProperties(CommonDistSQLStatementParser.PropertiesDefinitionContext ctx) {
        Properties result = new Properties();
        if (null == ctx || null == ctx.properties()) {
            return result;
        }
        List<CommonDistSQLStatementParser.PropertyContext> properties = ctx.properties().property();
        for (CommonDistSQLStatementParser.PropertyContext each : properties) {
            result.setProperty(new IdentifierValue(each.key.getText()).getValue(), new IdentifierValue(each.value.getText()).getValue());
        }
        return result;
    }

    @Override
    public ASTNode visitDropResource(CommonDistSQLStatementParser.DropResourceContext ctx) {
        boolean ignoreSingleTables = null != ctx.ignoreSingleTables();
        return new DropResourceStatement((Collection)ctx.IDENTIFIER().stream().map(ParseTree::getText).map(each -> new IdentifierValue(each).getValue()).collect(Collectors.toList()), ignoreSingleTables);
    }

    @Override
    public ASTNode visitShowResources(CommonDistSQLStatementParser.ShowResourcesContext ctx) {
        return new ShowResourcesStatement(null == ctx.schemaName() ? null : (SchemaSegment)this.visit((ParseTree)ctx.schemaName()));
    }

    @Override
    public ASTNode visitSchemaName(CommonDistSQLStatementParser.SchemaNameContext ctx) {
        return new SchemaSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }

    @Override
    public ASTNode visitSetVariable(CommonDistSQLStatementParser.SetVariableContext ctx) {
        return new SetVariableStatement(this.getIdentifierValue((ParseTree)ctx.variableName()), this.getIdentifierValue((ParseTree)ctx.variableValue()));
    }

    @Override
    public ASTNode visitShowSingleTableRules(CommonDistSQLStatementParser.ShowSingleTableRulesContext ctx) {
        return new ShowSingleTableRulesStatement(null == ctx.schemaName() ? null : (SchemaSegment)this.visit((ParseTree)ctx.schemaName()));
    }

    @Override
    public ASTNode visitShowSingleTable(CommonDistSQLStatementParser.ShowSingleTableContext ctx) {
        return new ShowSingleTableStatement(null == ctx.table() ? null : this.getIdentifierValue((ParseTree)ctx.table().tableName()), null == ctx.schemaName() ? null : (SchemaSegment)this.visit((ParseTree)ctx.schemaName()));
    }

    @Override
    public ASTNode visitShowVariable(CommonDistSQLStatementParser.ShowVariableContext ctx) {
        return new ShowVariableStatement(this.getIdentifierValue((ParseTree)ctx.variableName()).toUpperCase());
    }

    @Override
    public ASTNode visitShowAllVariables(CommonDistSQLStatementParser.ShowAllVariablesContext ctx) {
        return new ShowAllVariablesStatement();
    }

    private String getIdentifierValue(ParseTree context) {
        if (null == context) {
            return null;
        }
        return new IdentifierValue(context.getText()).getValue();
    }

    @Override
    public ASTNode visitClearHint(CommonDistSQLStatementParser.ClearHintContext ctx) {
        return new ClearHintStatement();
    }

    @Override
    public ASTNode visitRefreshTableMetadata(CommonDistSQLStatementParser.RefreshTableMetadataContext ctx) {
        RefreshTableMetadataStatement result = new RefreshTableMetadataStatement();
        result.setTableName(null == ctx.refreshScope() ? Optional.empty() : Optional.ofNullable(this.getIdentifierValue((ParseTree)ctx.refreshScope().tableName())));
        result.setResourceName(null == ctx.refreshScope() ? Optional.empty() : Optional.ofNullable(this.getIdentifierValue((ParseTree)ctx.refreshScope().resourceName())));
        return result;
    }

    @Override
    public ASTNode visitShowAuthorityRule(CommonDistSQLStatementParser.ShowAuthorityRuleContext ctx) {
        return new ShowAuthorityRuleStatement();
    }

    @Override
    public ASTNode visitShowTransactionRule(CommonDistSQLStatementParser.ShowTransactionRuleContext ctx) {
        return new ShowTransactionRuleStatement();
    }

    @Override
    public ASTNode visitAlterTransactionRule(CommonDistSQLStatementParser.AlterTransactionRuleContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.transactionRuleDefinition());
    }

    @Override
    public ASTNode visitDropTrafficRule(CommonDistSQLStatementParser.DropTrafficRuleContext ctx) {
        DropTrafficRuleStatement result = new DropTrafficRuleStatement();
        if (null != ctx.ruleName()) {
            result.setRuleNames((Collection)ctx.ruleName().stream().map(each -> this.getIdentifierValue((ParseTree)each)).collect(Collectors.toSet()));
        }
        result.setContainsIfExistClause(null != ctx.ifExists());
        return result;
    }

    @Override
    public ASTNode visitTransactionRuleDefinition(CommonDistSQLStatementParser.TransactionRuleDefinitionContext ctx) {
        String defaultType = this.getIdentifierValue((ParseTree)ctx.defaultType());
        TransactionProviderSegment provider = (TransactionProviderSegment)this.visit((ParseTree)ctx.providerDefinition());
        return new AlterTransactionRuleStatement(defaultType, provider);
    }

    @Override
    public ASTNode visitProviderDefinition(CommonDistSQLStatementParser.ProviderDefinitionContext ctx) {
        String providerType = this.getIdentifierValue((ParseTree)ctx.providerName());
        Properties props = this.getProperties(ctx.propertiesDefinition());
        return new TransactionProviderSegment(providerType, props);
    }

    @Override
    public ASTNode visitShowSQLParserRule(CommonDistSQLStatementParser.ShowSQLParserRuleContext ctx) {
        return new ShowSQLParserRuleStatement();
    }

    @Override
    public ASTNode visitAlterSQLParserRule(CommonDistSQLStatementParser.AlterSQLParserRuleContext ctx) {
        return (ASTNode)super.visit((ParseTree)ctx.sqlParserRuleDefinition());
    }

    @Override
    public ASTNode visitSqlParserRuleDefinition(CommonDistSQLStatementParser.SqlParserRuleDefinitionContext ctx) {
        AlterSQLParserRuleStatement result = new AlterSQLParserRuleStatement();
        result.setSqlCommentParseEnable(null == ctx.sqlCommentParseEnable() ? null : Boolean.valueOf(Boolean.parseBoolean(this.getIdentifierValue((ParseTree)ctx.sqlCommentParseEnable()))));
        result.setParseTreeCache(null == ctx.parseTreeCache() ? null : this.visitCacheOption(ctx.parseTreeCache().cacheOption()));
        result.setSqlStatementCache(null == ctx.sqlStatementCache() ? null : this.visitCacheOption(ctx.sqlStatementCache().cacheOption()));
        return result;
    }

    @Override
    public CacheOptionSegment visitCacheOption(CommonDistSQLStatementParser.CacheOptionContext ctx) {
        return new CacheOptionSegment(null == ctx.initialCapacity() ? null : Integer.valueOf(Integer.parseInt(this.getIdentifierValue((ParseTree)ctx.initialCapacity()))), null == ctx.maximumSize() ? null : Long.valueOf(Long.parseLong(this.getIdentifierValue((ParseTree)ctx.maximumSize()))), null == ctx.concurrencyLevel() ? null : Integer.valueOf(Integer.parseInt(this.getIdentifierValue((ParseTree)ctx.concurrencyLevel()))));
    }

    @Override
    public ASTNode visitCreateTrafficRule(CommonDistSQLStatementParser.CreateTrafficRuleContext ctx) {
        return new CreateTrafficRuleStatement((Collection)ctx.trafficRuleDefinition().stream().map(each -> (TrafficRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toCollection(LinkedList::new)));
    }

    @Override
    public ASTNode visitAlterTrafficRule(CommonDistSQLStatementParser.AlterTrafficRuleContext ctx) {
        return new AlterTrafficRuleStatement((Collection)ctx.trafficRuleDefinition().stream().map(each -> (TrafficRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toCollection(LinkedList::new)));
    }

    @Override
    public ASTNode visitShowTrafficRules(CommonDistSQLStatementParser.ShowTrafficRulesContext ctx) {
        ShowTrafficRulesStatement result = new ShowTrafficRulesStatement();
        if (null != ctx.ruleName()) {
            result.setRuleName(this.getIdentifierValue((ParseTree)ctx.ruleName()));
        }
        return result;
    }

    @Override
    public ASTNode visitTrafficRuleDefinition(CommonDistSQLStatementParser.TrafficRuleDefinitionContext ctx) {
        return new TrafficRuleSegment(this.getIdentifierValue((ParseTree)ctx.ruleName()), this.buildLabels(ctx.labelDefinition()), (AlgorithmSegment)this.visit((ParseTree)ctx.trafficAlgorithmDefinition().algorithmDefinition()), (AlgorithmSegment)this.visit((ParseTree)ctx.loadBanlanceDefinition().algorithmDefinition()));
    }

    @Override
    public ASTNode visitAlgorithmDefinition(CommonDistSQLStatementParser.AlgorithmDefinitionContext ctx) {
        return new AlgorithmSegment(this.getIdentifierValue((ParseTree)ctx.typeName()), this.buildProperties(ctx.algorithmProperties()));
    }

    private Properties buildProperties(CommonDistSQLStatementParser.AlgorithmPropertiesContext algorithmProperties) {
        Properties result = new Properties();
        if (null == algorithmProperties) {
            return result;
        }
        for (CommonDistSQLStatementParser.AlgorithmPropertyContext each : algorithmProperties.algorithmProperty()) {
            result.setProperty(new IdentifierValue(each.key.getText()).getValue(), new IdentifierValue(each.value.getText()).getValue());
        }
        return result;
    }

    private Collection<String> buildLabels(CommonDistSQLStatementParser.LabelDefinitionContext labelDefinition) {
        return labelDefinition.label().stream().map(this::getIdentifierValue).collect(Collectors.toCollection(LinkedList::new));
    }

    @Override
    public ASTNode visitExportSchemaConfiguration(CommonDistSQLStatementParser.ExportSchemaConfigurationContext ctx) {
        return new ExportSchemaConfigurationStatement(Objects.nonNull((Object)ctx.schemaName()) ? (SchemaSegment)this.visit((ParseTree)ctx.schemaName()) : null, Optional.ofNullable(this.getIdentifierValue((ParseTree)ctx.filePath())));
    }

    @Override
    public ASTNode visitShowRulesUsedResource(CommonDistSQLStatementParser.ShowRulesUsedResourceContext ctx) {
        return new ShowRulesUsedResourceStatement(null == ctx.resourceName() ? Optional.empty() : Optional.of(this.getIdentifierValue((ParseTree)ctx.resourceName())), null == ctx.schemaName() ? null : (SchemaSegment)this.visit((ParseTree)ctx.schemaName()));
    }
}

