/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.extractor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.insert.values.InsertSelectContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.IndexAvailable;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.binder.context.type.WhereAvailable;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtils;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;

public final class SQLStatementContextExtractor {
    public static Collection<String> getTableNames(ShardingSphereDatabase database, SQLStatementContext sqlStatementContext) {
        List<String> tableNames;
        Collection<String> collection = tableNames = sqlStatementContext instanceof TableAvailable ? ((TableAvailable)((Object)sqlStatementContext)).getTablesContext().getTableNames() : Collections.emptyList();
        if (!tableNames.isEmpty()) {
            return tableNames;
        }
        return sqlStatementContext instanceof IndexAvailable ? SQLStatementContextExtractor.getTableNames(database, sqlStatementContext.getDatabaseType(), ((IndexAvailable)((Object)sqlStatementContext)).getIndexes()) : Collections.emptyList();
    }

    private static Collection<String> getTableNames(ShardingSphereDatabase database, DatabaseType databaseType, Collection<IndexSegment> indexes) {
        LinkedList<String> result = new LinkedList<String>();
        for (QualifiedTable each : IndexMetaDataUtils.getTableNames((ShardingSphereDatabase)database, (DatabaseType)databaseType, indexes)) {
            result.add(each.getTableName());
        }
        return result;
    }

    public static Collection<SelectStatementContext> getAllSubqueryContexts(SQLStatementContext sqlStatementContext) {
        LinkedList<SelectStatementContext> result = new LinkedList<SelectStatementContext>();
        if (sqlStatementContext instanceof SelectStatementContext) {
            result.addAll(((SelectStatementContext)sqlStatementContext).getSubqueryContexts().values());
            ((SelectStatementContext)sqlStatementContext).getSubqueryContexts().values().forEach(each -> result.addAll(SQLStatementContextExtractor.getAllSubqueryContexts(each)));
        }
        if (sqlStatementContext instanceof InsertStatementContext && null != ((InsertStatementContext)sqlStatementContext).getInsertSelectContext()) {
            InsertSelectContext insertSelectContext = ((InsertStatementContext)sqlStatementContext).getInsertSelectContext();
            result.add(insertSelectContext.getSelectStatementContext());
            result.addAll(insertSelectContext.getSelectStatementContext().getSubqueryContexts().values());
            insertSelectContext.getSelectStatementContext().getSubqueryContexts().values().forEach(each -> result.addAll(SQLStatementContextExtractor.getAllSubqueryContexts(each)));
        }
        return result;
    }

    public static Collection<WhereSegment> getAllWhereSegments(SQLStatementContext sqlStatementContext) {
        if (!(sqlStatementContext instanceof WhereAvailable)) {
            return Collections.emptySet();
        }
        Collection<SelectStatementContext> allSubqueryContexts = SQLStatementContextExtractor.getAllSubqueryContexts(sqlStatementContext);
        return SQLStatementContextExtractor.getWhereSegments((WhereAvailable)((Object)sqlStatementContext), allSubqueryContexts);
    }

    public static Collection<WhereSegment> getWhereSegments(WhereAvailable whereAvailable, Collection<SelectStatementContext> allSubqueryContexts) {
        LinkedHashMap uniqueWhereSegments = new LinkedHashMap();
        whereAvailable.getWhereSegments().forEach(each -> uniqueWhereSegments.put(each.getStartIndex() + each.getStopIndex(), each));
        allSubqueryContexts.forEach(each -> each.getWhereSegments().forEach(where -> uniqueWhereSegments.put(where.getStartIndex() + where.getStopIndex(), where)));
        return new ArrayList<WhereSegment>(uniqueWhereSegments.values());
    }

    public static Collection<ColumnSegment> getColumnSegments(WhereAvailable whereAvailable, Collection<SelectStatementContext> allSubqueryContexts) {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>(whereAvailable.getColumnSegments());
        allSubqueryContexts.forEach(each -> result.addAll(each.getColumnSegments()));
        return result;
    }

    public static Collection<BinaryOperationExpression> getJoinConditions(WhereAvailable whereAvailable, Collection<SelectStatementContext> allSubqueryContexts) {
        LinkedList<BinaryOperationExpression> result = new LinkedList<BinaryOperationExpression>(whereAvailable.getJoinConditions());
        allSubqueryContexts.forEach(each -> result.addAll(each.getJoinConditions()));
        return result;
    }

    @Generated
    private SQLStatementContextExtractor() {
    }
}

