/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.config.schema.impl;

import com.zaxxer.hikari.HikariDataSource;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.schema.SchemaConfiguration;
import org.apache.shardingsphere.infra.datasource.config.DataSourceConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolCreator;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.datasource.props.DataSourcePropertiesCreator;

public final class DataSourceGeneratedSchemaConfiguration
implements SchemaConfiguration {
    private final Map<String, DataSource> dataSources;
    private final Collection<RuleConfiguration> ruleConfigurations;

    public DataSourceGeneratedSchemaConfiguration(Map<String, DataSourceConfiguration> dataSources, Collection<RuleConfiguration> ruleConfigurations) {
        this.dataSources = DataSourcePoolCreator.create(this.createDataSourcePropertiesMap(dataSources));
        this.ruleConfigurations = ruleConfigurations;
    }

    private Map<String, DataSourceProperties> createDataSourcePropertiesMap(Map<String, DataSourceConfiguration> dataSources) {
        return dataSources.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DataSourcePropertiesCreator.create(HikariDataSource.class.getName(), (DataSourceConfiguration)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    @Override
    @Generated
    public Map<String, DataSource> getDataSources() {
        return this.dataSources;
    }

    @Override
    @Generated
    public Collection<RuleConfiguration> getRuleConfigurations() {
        return this.ruleConfigurations;
    }
}

