/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.pool.destroyer;

import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.DataSourcePoolDestroyer;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.required.RequiredSPIRegistry;
import org.apache.shardingsphere.spi.typed.TypedSPIRegistry;

public final class DataSourcePoolDestroyerFactory {
    public static void destroy(DataSource dataSource) throws SQLException {
        DataSourcePoolDestroyerFactory.newInstance(dataSource.getClass().getCanonicalName()).destroy(dataSource);
    }

    private static DataSourcePoolDestroyer newInstance(String dataSourceClassName) {
        return (DataSourcePoolDestroyer)TypedSPIRegistry.findRegisteredService(DataSourcePoolDestroyer.class, (String)dataSourceClassName, (Properties)new Properties()).orElse(RequiredSPIRegistry.getRegisteredService(DataSourcePoolDestroyer.class));
    }

    static {
        ShardingSphereServiceLoader.register(DataSourcePoolDestroyer.class);
    }
}

