/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.statistics.builder.dialect;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereDatabaseData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereRowData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereSchemaData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereTableData;
import org.apache.shardingsphere.infra.metadata.statistics.builder.ShardingSphereStatisticsBuilder;

public final class PostgreSQLShardingSphereStatisticsBuilder
implements ShardingSphereStatisticsBuilder {
    private static final String SHARDINGSPHERE = "shardingsphere";
    private static final String CLUSTER_INFORMATION = "cluster_information";
    private static final String SHARDING_TABLE_STATISTICS = "sharding_table_statistics";
    private static final Map<String, Collection<String>> INIT_DATA_SCHEMA_TABLES = new LinkedHashMap<String, Collection<String>>();

    @Override
    public ShardingSphereDatabaseData build(ShardingSphereDatabase database) {
        ShardingSphereDatabaseData result = new ShardingSphereDatabaseData();
        if (null != database.getSchema(SHARDINGSPHERE)) {
            ShardingSphereSchemaData schemaData = new ShardingSphereSchemaData();
            this.initClusterInformationTable(schemaData);
            this.initShardingTableStatisticsTable(schemaData);
            result.putSchema(SHARDINGSPHERE, schemaData);
        }
        for (Map.Entry<String, Collection<String>> entry : INIT_DATA_SCHEMA_TABLES.entrySet()) {
            ShardingSphereSchemaData schemaData = new ShardingSphereSchemaData();
            if (null == database.getSchema(entry.getKey())) continue;
            this.initTables(database.getSchema(entry.getKey()), entry.getValue(), schemaData);
            result.putSchema(entry.getKey(), schemaData);
        }
        return result;
    }

    private void initClusterInformationTable(ShardingSphereSchemaData schemaData) {
        ShardingSphereTableData tableData = new ShardingSphereTableData(CLUSTER_INFORMATION);
        tableData.getRows().add(new ShardingSphereRowData(Collections.singletonList("5.5.2")));
        schemaData.putTable(CLUSTER_INFORMATION, tableData);
    }

    private void initShardingTableStatisticsTable(ShardingSphereSchemaData schemaData) {
        schemaData.putTable(SHARDING_TABLE_STATISTICS, new ShardingSphereTableData(SHARDING_TABLE_STATISTICS));
    }

    private void initTables(ShardingSphereSchema schema, Collection<String> tables, ShardingSphereSchemaData schemaData) {
        for (ShardingSphereTable each : schema.getAllTables()) {
            if (!tables.contains(each.getName().toLowerCase())) continue;
            schemaData.putTable(each.getName().toLowerCase(), new ShardingSphereTableData(each.getName()));
        }
    }

    public String getDatabaseType() {
        return "PostgreSQL";
    }

    static {
        INIT_DATA_SCHEMA_TABLES.put("pg_catalog", Arrays.asList("pg_class", "pg_namespace"));
    }
}

