/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.yaml.data.swapper;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereRowData;
import org.apache.shardingsphere.infra.util.yaml.swapper.YamlConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.data.pojo.YamlShardingSphereRowData;

public final class YamlShardingSphereRowDataSwapper
implements YamlConfigurationSwapper<YamlShardingSphereRowData, ShardingSphereRowData> {
    private final List<ShardingSphereColumn> columns;

    public YamlShardingSphereRowData swapToYamlConfiguration(ShardingSphereRowData data) {
        YamlShardingSphereRowData result = new YamlShardingSphereRowData();
        List<Object> rowData = null == data.getRows() ? Collections.emptyList() : data.getRows();
        LinkedList<Object> yamlRowData = new LinkedList<Object>();
        int count = 0;
        for (Object e : rowData) {
            yamlRowData.add(this.convertDataType(e, this.columns.get(count++).getDataType()));
        }
        result.setRows(yamlRowData);
        result.setUniqueKey(data.getUniqueKey());
        return result;
    }

    private Object convertDataType(Object data, int dataType) {
        if (3 == dataType || -5 == dataType) {
            return null == data ? null : data.toString();
        }
        return data;
    }

    public ShardingSphereRowData swapToObject(YamlShardingSphereRowData yamlConfig) {
        List<Object> yamlRow = null == yamlConfig.getRows() ? Collections.emptyList() : yamlConfig.getRows();
        LinkedList<Object> rowData = new LinkedList<Object>();
        int count = 0;
        for (Object e : yamlRow) {
            ShardingSphereColumn column = this.columns.get(count++);
            rowData.add(this.convertByDataType(e, column.getDataType()));
        }
        return new ShardingSphereRowData(yamlConfig.getUniqueKey(), rowData);
    }

    private Object convertByDataType(Object data, int dataType) {
        if (null == data) {
            return null;
        }
        if (3 == dataType) {
            return new BigDecimal(data.toString());
        }
        if (-5 == dataType) {
            return Long.valueOf(data.toString());
        }
        if (7 == dataType || 6 == dataType) {
            return Float.valueOf(Float.parseFloat(data.toString()));
        }
        return data;
    }

    @Generated
    public YamlShardingSphereRowDataSwapper(List<ShardingSphereColumn> columns) {
        this.columns = columns;
    }
}

