/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.generic;

import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.IndexAvailable;
import org.apache.shardingsphere.infra.binder.context.type.RemoveAvailable;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic.RemoveToken;
import org.apache.shardingsphere.sql.parser.statement.core.segment.SQLSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;

public final class RemoveTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext> {
    @Override
    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        if (sqlStatementContext instanceof RemoveAvailable && !((RemoveAvailable)sqlStatementContext).getRemoveSegments().isEmpty()) {
            return true;
        }
        if (sqlStatementContext instanceof TableAvailable && !((TableAvailable)sqlStatementContext).getTablesContext().getSimpleTables().isEmpty()) {
            return true;
        }
        return sqlStatementContext instanceof IndexAvailable && !((IndexAvailable)sqlStatementContext).getIndexes().isEmpty();
    }

    @Override
    public Collection<SQLToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        if (sqlStatementContext instanceof RemoveAvailable && !((RemoveAvailable)sqlStatementContext).getRemoveSegments().isEmpty()) {
            result.addAll(this.generateRemoveAvailableSQLTokens(((RemoveAvailable)sqlStatementContext).getRemoveSegments()));
        }
        if (sqlStatementContext instanceof TableAvailable && !((TableAvailable)sqlStatementContext).getTablesContext().getSimpleTables().isEmpty()) {
            result.addAll(this.generateTableAvailableSQLTokens((TableAvailable)sqlStatementContext, sqlStatementContext.getDatabaseType()));
        }
        if (sqlStatementContext instanceof IndexAvailable && !((IndexAvailable)sqlStatementContext).getIndexes().isEmpty()) {
            result.addAll(this.generateIndexAvailableSQLTokens((IndexAvailable)sqlStatementContext));
        }
        return result;
    }

    private Collection<RemoveToken> generateRemoveAvailableSQLTokens(Collection<SQLSegment> removeSegments) {
        return removeSegments.stream().map(each -> new RemoveToken(each.getStartIndex(), each.getStopIndex())).collect(Collectors.toList());
    }

    private Collection<RemoveToken> generateTableAvailableSQLTokens(TableAvailable tableAvailable, DatabaseType databaseType) {
        LinkedList<RemoveToken> result = new LinkedList<RemoveToken>();
        for (SimpleTableSegment each : tableAvailable.getTablesContext().getSimpleTables()) {
            if (!each.getOwner().isPresent()) continue;
            DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
            OwnerSegment ownerSegment = (OwnerSegment)each.getOwner().get();
            if (dialectDatabaseMetaData.getDefaultSchema().isPresent()) {
                ownerSegment.getOwner().ifPresent(optional -> result.add(new RemoveToken(optional.getStartIndex(), ownerSegment.getStartIndex() - 1)));
                continue;
            }
            result.add(new RemoveToken(ownerSegment.getStartIndex(), each.getTableName().getStartIndex() - 1));
        }
        return result;
    }

    private Collection<RemoveToken> generateIndexAvailableSQLTokens(IndexAvailable indexAvailable) {
        LinkedList<RemoveToken> result = new LinkedList<RemoveToken>();
        for (IndexSegment each : indexAvailable.getIndexes()) {
            if (!each.getOwner().isPresent()) continue;
            OwnerSegment owner = (OwnerSegment)each.getOwner().get();
            int startIndex = owner.getOwner().isPresent() ? ((OwnerSegment)owner.getOwner().get()).getStartIndex() : owner.getStartIndex();
            int stopIndex = owner.getOwner().isPresent() ? owner.getStartIndex() - 1 : each.getStartIndex() - 1;
            result.add(new RemoveToken(startIndex, stopIndex));
        }
        return result;
    }
}

