/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.route.context;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteStageContext;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class RouteContext {
    private final Collection<Collection<DataNode>> originalDataNodes = new LinkedList<Collection<DataNode>>();
    private final Collection<RouteUnit> routeUnits = new LinkedHashSet<RouteUnit>();
    private final Map<Class<? extends ShardingSphereRule>, RouteStageContext> routeStageContexts = new LinkedHashMap<Class<? extends ShardingSphereRule>, RouteStageContext>();
    private boolean isFederated;

    public boolean isSingleRouting() {
        return 1 == this.routeUnits.size();
    }

    public Collection<String> getActualDataSourceNames() {
        return this.routeUnits.stream().map(each -> each.getDataSourceMapper().getActualName()).collect(Collectors.toCollection(() -> new HashSet(this.routeUnits.size(), 1.0f)));
    }

    public List<Set<String>> getActualTableNameGroups(String actualDataSourceName, Set<String> logicTableNames) {
        return logicTableNames.stream().map(each -> this.getActualTableNames(actualDataSourceName, (String)each)).filter(actualTableNames -> !actualTableNames.isEmpty()).collect(Collectors.toList());
    }

    private Set<String> getActualTableNames(String actualDataSourceName, String logicTableName) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (RouteUnit each : this.routeUnits) {
            if (!actualDataSourceName.equalsIgnoreCase(each.getDataSourceMapper().getActualName())) continue;
            result.addAll(each.getActualTableNames(logicTableName));
        }
        return result;
    }

    public Map<String, Set<String>> getDataSourceLogicTablesMap(Collection<String> actualDataSourceNames) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(actualDataSourceNames.size(), 1.0f);
        for (String each : actualDataSourceNames) {
            Set<String> logicTableNames = this.getLogicTableNames(each);
            if (logicTableNames.isEmpty()) continue;
            result.put(each, logicTableNames);
        }
        return result;
    }

    private Set<String> getLogicTableNames(String actualDataSourceName) {
        HashSet<String> result = new HashSet<String>();
        for (RouteUnit each : this.routeUnits) {
            if (!actualDataSourceName.equalsIgnoreCase(each.getDataSourceMapper().getActualName())) continue;
            result.addAll(each.getLogicTableNames());
        }
        return result;
    }

    public Optional<RouteMapper> findTableMapper(String logicDataSourceName, String actualTableName) {
        for (RouteUnit each : this.routeUnits) {
            Optional<RouteMapper> result = each.findTableMapper(logicDataSourceName, actualTableName);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    public void putRouteUnit(RouteMapper dataSourceMapper, Collection<RouteMapper> tableMappers) {
        Collection<RouteUnit> targets = this.getTargetRouteUnits(dataSourceMapper);
        if (targets.isEmpty()) {
            RouteUnit unit = new RouteUnit(dataSourceMapper, new LinkedHashSet<RouteMapper>());
            unit.getTableMappers().addAll(tableMappers);
            this.routeUnits.add(unit);
        } else {
            LinkedList<RouteUnit> toBeAdded = new LinkedList<RouteUnit>();
            LinkedList<RouteUnit> toBeRemoved = new LinkedList<RouteUnit>();
            for (RouteUnit each : targets) {
                RouteUnit unit = new RouteUnit(dataSourceMapper, new LinkedHashSet<RouteMapper>());
                unit.getTableMappers().addAll(each.getTableMappers());
                unit.getTableMappers().addAll(tableMappers);
                toBeAdded.add(unit);
                toBeRemoved.add(each);
            }
            boolean success = this.routeUnits.addAll(toBeAdded);
            if (success) {
                this.routeUnits.removeAll(toBeRemoved);
            }
        }
    }

    private Collection<RouteUnit> getTargetRouteUnits(RouteMapper dataSourceMapper) {
        LinkedList<RouteUnit> result = new LinkedList<RouteUnit>();
        for (RouteUnit each : this.routeUnits) {
            if (!each.getDataSourceMapper().equals(dataSourceMapper)) continue;
            result.add(each);
        }
        return result;
    }

    public boolean containsTableSharding() {
        for (RouteUnit each : this.routeUnits) {
            for (RouteMapper tableMapper : each.getTableMappers()) {
                if (tableMapper.getActualName().equals(tableMapper.getLogicName())) continue;
                return true;
            }
        }
        return false;
    }

    @Generated
    public Collection<Collection<DataNode>> getOriginalDataNodes() {
        return this.originalDataNodes;
    }

    @Generated
    public Collection<RouteUnit> getRouteUnits() {
        return this.routeUnits;
    }

    @Generated
    public Map<Class<? extends ShardingSphereRule>, RouteStageContext> getRouteStageContexts() {
        return this.routeStageContexts;
    }

    @Generated
    public boolean isFederated() {
        return this.isFederated;
    }

    @Generated
    public void setFederated(boolean isFederated) {
        this.isFederated = isFederated;
    }
}

