/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sqlserver.visitor.statement.type;

import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.TCLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.SQLServerStatementParser;
import org.apache.shardingsphere.sql.parser.sqlserver.visitor.statement.SQLServerStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TransactionIsolationLevel;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.tcl.SQLServerBeginDistributedTransactionStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.tcl.SQLServerBeginTransactionStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.tcl.SQLServerCommitStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.tcl.SQLServerRollbackStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.tcl.SQLServerSavepointStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.tcl.SQLServerSetAutoCommitStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.tcl.SQLServerSetTransactionStatement;

public final class SQLServerTCLStatementVisitor
extends SQLServerStatementVisitor
implements TCLStatementVisitor {
    @Override
    public ASTNode visitSetTransaction(SQLServerStatementParser.SetTransactionContext ctx) {
        SQLServerSetTransactionStatement result = new SQLServerSetTransactionStatement();
        result.setIsolationLevel(this.getTransactionIsolationLevel(ctx.isolationLevel()));
        return result;
    }

    private TransactionIsolationLevel getTransactionIsolationLevel(SQLServerStatementParser.IsolationLevelContext ctx) {
        TransactionIsolationLevel result = null != ctx.UNCOMMITTED() ? TransactionIsolationLevel.READ_UNCOMMITTED : (null != ctx.COMMITTED() ? TransactionIsolationLevel.READ_COMMITTED : (null != ctx.REPEATABLE() ? TransactionIsolationLevel.REPEATABLE_READ : (null != ctx.SNAPSHOT() ? TransactionIsolationLevel.SNAPSHOT : TransactionIsolationLevel.SERIALIZABLE)));
        return result;
    }

    @Override
    public ASTNode visitSetImplicitTransactions(SQLServerStatementParser.SetImplicitTransactionsContext ctx) {
        SQLServerSetAutoCommitStatement result = new SQLServerSetAutoCommitStatement();
        result.setAutoCommit("ON".equalsIgnoreCase(ctx.implicitTransactionsValue().getText()));
        return result;
    }

    @Override
    public ASTNode visitBeginTransaction(SQLServerStatementParser.BeginTransactionContext ctx) {
        return new SQLServerBeginTransactionStatement();
    }

    @Override
    public ASTNode visitBeginDistributedTransaction(SQLServerStatementParser.BeginDistributedTransactionContext ctx) {
        return new SQLServerBeginDistributedTransactionStatement();
    }

    @Override
    public ASTNode visitCommit(SQLServerStatementParser.CommitContext ctx) {
        return new SQLServerCommitStatement();
    }

    @Override
    public ASTNode visitCommitWork(SQLServerStatementParser.CommitWorkContext ctx) {
        return new SQLServerCommitStatement();
    }

    @Override
    public ASTNode visitRollback(SQLServerStatementParser.RollbackContext ctx) {
        return new SQLServerRollbackStatement();
    }

    @Override
    public ASTNode visitRollbackWork(SQLServerStatementParser.RollbackWorkContext ctx) {
        return new SQLServerRollbackStatement();
    }

    @Override
    public ASTNode visitSavepoint(SQLServerStatementParser.SavepointContext ctx) {
        return new SQLServerSavepointStatement();
    }
}

