/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.handler.enums.ShardingStrategyType;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowDefaultShardingStrategyStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class DefaultShardingStrategyQueryResultSet
implements DistSQLResultSet {
    private Iterator<Map.Entry<String, LinkedList<Object>>> data = Collections.emptyIterator();

    public void init(ShardingSphereMetaData metaData, SQLStatement sqlStatement) {
        Optional shardingRuleConfiguration = metaData.getRuleMetaData().findRuleConfiguration(ShardingRuleConfiguration.class).stream().findAny();
        shardingRuleConfiguration.ifPresent(op -> {
            this.data = this.buildData((ShardingRuleConfiguration)op).entrySet().iterator();
        });
    }

    private Map<String, LinkedList<Object>> buildData(ShardingRuleConfiguration ruleConfiguration) {
        LinkedHashMap<String, LinkedList<Object>> result = new LinkedHashMap<String, LinkedList<Object>>(2);
        result.put("TABLE", this.buildDataItem(ruleConfiguration, ruleConfiguration.getDefaultTableShardingStrategy()));
        result.put("DATABASE", this.buildDataItem(ruleConfiguration, ruleConfiguration.getDefaultDatabaseShardingStrategy()));
        return result;
    }

    private LinkedList<Object> buildDataItem(ShardingRuleConfiguration ruleConfiguration, ShardingStrategyConfiguration strategyConfiguration) {
        if (null == strategyConfiguration) {
            return new LinkedList<Object>(Arrays.asList("NONE", "", "", "", ""));
        }
        ShardingStrategyType strategyType = ShardingStrategyType.getValueOf(strategyConfiguration);
        if (strategyType == ShardingStrategyType.NONE) {
            return new LinkedList<Object>(Arrays.asList("NONE", "", "", "", ""));
        }
        LinkedList<Object> result = new LinkedList<Object>(Collections.singleton(strategyType.name()));
        result.addAll(strategyType.getConfigurationContents(strategyConfiguration));
        ShardingSphereAlgorithmConfiguration algorithmConfiguration = (ShardingSphereAlgorithmConfiguration)ruleConfiguration.getShardingAlgorithms().get(strategyConfiguration.getShardingAlgorithmName());
        result.add(algorithmConfiguration.getType());
        result.add((String)((Object)algorithmConfiguration.getProps()));
        return result;
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("name", "type", "sharding_column", "sharding_algorithm_name", "sharding_algorithm_type", "sharding_algorithm_props");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        Map.Entry<String, LinkedList<Object>> entry = this.data.next();
        entry.getValue().addFirst(entry.getKey());
        return entry.getValue();
    }

    public String getType() {
        return ShowDefaultShardingStrategyStatement.class.getName();
    }
}

