/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingBindingTableRulesStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ShardingBindingTableRuleQueryResultSet
implements DistSQLResultSet {
    private Iterator<String> data;

    public void init(ShardingSphereMetaData metaData, SQLStatement sqlStatement) {
        Optional<ShardingRuleConfiguration> shardingRuleConfig = metaData.getRuleMetaData().getConfigurations().stream().filter(each -> each instanceof ShardingRuleConfiguration).map(each -> (ShardingRuleConfiguration)each).findFirst();
        this.data = shardingRuleConfig.map(shardingRuleConfiguration -> shardingRuleConfiguration.getBindingTableGroups().iterator()).orElse(Collections.emptyIterator());
    }

    public Collection<String> getColumnNames() {
        return Collections.singleton("sharding_binding_tables");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return Collections.singleton(this.data.next());
    }

    public String getType() {
        return ShowShardingBindingTableRulesStatement.class.getName();
    }
}

