/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.swing.AjdeWidgetStyles;

public class AJButtonMenuCombo
extends JPanel {
    private static final long serialVersionUID = -4866207530403336160L;
    private JButton mainButton;
    private JButton popupButton;
    private JPopupMenu menu;
    private boolean isPressed = false;

    public AJButtonMenuCombo(String name, String toolTipText, Icon icon, JPopupMenu menu, boolean depressable) {
        this.menu = menu;
        this.mainButton = new JButton();
        this.mainButton.setIcon(icon);
        this.mainButton.setBorder(AjdeWidgetStyles.DEFAULT_BORDER);
        this.mainButton.setToolTipText(toolTipText);
        this.mainButton.setPreferredSize(new Dimension(22, 20));
        this.mainButton.setMinimumSize(new Dimension(22, 20));
        this.mainButton.setMaximumSize(new Dimension(22, 20));
        this.popupButton = new JButton();
        this.popupButton.setIcon(Ajde.getDefault().getIconRegistry().getPopupIcon());
        this.popupButton.setBorder(BorderFactory.createEmptyBorder());
        this.popupButton.setToolTipText(toolTipText);
        this.popupButton.setPreferredSize(new Dimension(13, 20));
        this.popupButton.setMinimumSize(new Dimension(13, 20));
        this.popupButton.setMaximumSize(new Dimension(13, 20));
        PopupListener popupListener = new PopupListener(this.mainButton);
        if (depressable) {
            this.mainButton.addActionListener(new ButtonActionListener());
        } else {
            this.mainButton.addMouseListener(popupListener);
        }
        this.popupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AJButtonMenuCombo.this.popupButton.setBorder(null);
            }
        });
        BorderUpdateListener borderUpdateListner = new BorderUpdateListener();
        this.mainButton.addMouseListener(borderUpdateListner);
        this.popupButton.addMouseListener(borderUpdateListner);
        this.popupButton.addMouseListener(popupListener);
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainButton, "Center");
        this.add((Component)this.popupButton, "East");
        this.setMinimumSize(new Dimension(35, 20));
        this.setMaximumSize(new Dimension(35, 20));
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.mainButton.setEnabled(enabled);
        this.popupButton.setEnabled(enabled);
    }

    public void setMenu(JPopupMenu menu) {
        this.menu = menu;
        this.repaint();
    }

    class PopupListener
    extends MouseAdapter {
        private JButton button;

        public PopupListener(JButton button) {
            this.button = button;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            AJButtonMenuCombo.this.menu.show(e.getComponent(), this.button.getX(), this.button.getY() + AJButtonMenuCombo.this.popupButton.getHeight());
        }
    }

    class BorderUpdateListener
    extends MouseAdapter {
        BorderUpdateListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            AJButtonMenuCombo.this.popupButton.setBorder(AjdeWidgetStyles.RAISED_BEVEL_BORDER);
            AJButtonMenuCombo.this.mainButton.setBorder(AjdeWidgetStyles.RAISED_BEVEL_BORDER);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            AJButtonMenuCombo.this.popupButton.setBorder(AjdeWidgetStyles.DEFAULT_BORDER);
            if (AJButtonMenuCombo.this.isPressed) {
                AJButtonMenuCombo.this.mainButton.setBorder(AjdeWidgetStyles.LOWERED_BEVEL_BORDER);
            } else {
                AJButtonMenuCombo.this.mainButton.setBorder(AjdeWidgetStyles.DEFAULT_BORDER);
            }
        }
    }

    class ButtonActionListener
    implements ActionListener {
        ButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AJButtonMenuCombo.this.isPressed) {
                AJButtonMenuCombo.this.mainButton.setBorder(AjdeWidgetStyles.DEFAULT_BORDER);
                AJButtonMenuCombo.this.isPressed = false;
            } else {
                AJButtonMenuCombo.this.mainButton.setBorder(AjdeWidgetStyles.LOWERED_BEVEL_BORDER);
                AJButtonMenuCombo.this.isPressed = true;
            }
        }
    }
}

