/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd.field;

import org.aspectj.org.eclipse.jdt.internal.core.nd.Nd;
import org.aspectj.org.eclipse.jdt.internal.core.nd.NdNode;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.BTree;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.Database;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.EmptyString;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.IString;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldSearchIndex;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.IDestructableField;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.IField;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.StructDef;

public class FieldSearchKey<T>
implements IField,
IDestructableField {
    private int offset;
    FieldSearchIndex<?> searchIndex;

    private FieldSearchKey(FieldSearchIndex<?> searchIndex) {
        if (searchIndex != null) {
            if (searchIndex.searchKey != null && searchIndex.searchKey != this) {
                throw new IllegalArgumentException("Attempted to construct a FieldSearchKey referring to a search index that is already in use by a different key");
            }
            searchIndex.searchKey = this;
        }
        this.searchIndex = searchIndex;
    }

    public static <T, B extends NdNode> FieldSearchKey<T> create(StructDef<B> builder, FieldSearchIndex<B> searchIndex) {
        FieldSearchKey<T> result = new FieldSearchKey<T>(searchIndex);
        builder.add(result);
        builder.addDestructableField(result);
        return result;
    }

    public void put(Nd nd, long address, String newString) {
        this.put(nd, address, newString.toCharArray());
    }

    public void put(Nd nd, long address, char[] newString) {
        this.cleanup(nd, address);
        Database db = nd.getDB();
        BTree btree = this.searchIndex.get(nd, Database.DATA_AREA_OFFSET);
        db.putRecPtr(address + (long)this.offset, db.newString(newString).getRecord());
        btree.insert(address);
    }

    public IString get(Nd nd, long address) {
        Database db = nd.getDB();
        long namerec = db.getRecPtr(address + (long)this.offset);
        if (namerec == 0L) {
            return EmptyString.create();
        }
        return db.getString(namerec);
    }

    @Override
    public void destruct(Nd nd, long address) {
        this.cleanup(nd, address);
    }

    private void cleanup(Nd nd, long address) {
        boolean isInIndex = this.isInIndex(nd, address);
        if (isInIndex) {
            this.searchIndex.get(nd, Database.DATA_AREA_OFFSET).delete(address);
            this.get(nd, address).delete();
            nd.getDB().putRecPtr(address + (long)this.offset, 0L);
        }
    }

    public void removeFromIndex(Nd nd, long address) {
        this.cleanup(nd, address);
    }

    public boolean isInIndex(Nd nd, long address) {
        long fieldAddress = address + (long)this.offset;
        Database db = nd.getDB();
        long namerec = db.getRecPtr(fieldAddress);
        boolean isInIndex = namerec != 0L;
        return isInIndex;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int getRecordSize() {
        return 4;
    }
}

