/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.resolver.cluster;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.monitoring.collector.cluster.DiscoveryNodeMonitoringDoc;
import org.elasticsearch.xpack.monitoring.resolver.MonitoringIndexNameResolver;

public class DiscoveryNodeResolver
extends MonitoringIndexNameResolver.Data<DiscoveryNodeMonitoringDoc> {
    public static final String TYPE = "node";

    @Override
    public String type(DiscoveryNodeMonitoringDoc document) {
        return TYPE;
    }

    @Override
    public String id(DiscoveryNodeMonitoringDoc document) {
        return document.getNode().getId();
    }

    @Override
    protected void buildXContent(DiscoveryNodeMonitoringDoc document, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(TYPE);
        DiscoveryNode node = document.getNode();
        if (node != null) {
            builder.field("name", node.getName());
            builder.field("transport_address", node.getAddress().toString());
            builder.startObject("attributes");
            for (Map.Entry entry : node.getAttributes().entrySet()) {
                builder.field((String)entry.getKey(), (String)entry.getValue());
            }
            builder.endObject();
            builder.field("id", node.getId());
        }
        builder.endObject();
    }

    static final class Fields {
        static final String NODE = "node";
        static final String NAME = "name";
        static final String TRANSPORT_ADDRESS = "transport_address";
        static final String ATTRIBUTES = "attributes";
        static final String ID = "id";

        Fields() {
        }
    }
}

