/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.notification.pagerduty;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.common.http.HttpMethod;
import org.elasticsearch.xpack.common.http.HttpProxy;
import org.elasticsearch.xpack.common.http.HttpRequest;
import org.elasticsearch.xpack.common.http.Scheme;
import org.elasticsearch.xpack.common.text.TextTemplate;
import org.elasticsearch.xpack.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.notification.pagerduty.IncidentEventContext;
import org.elasticsearch.xpack.notification.pagerduty.IncidentEventDefaults;
import org.elasticsearch.xpack.watcher.watch.Payload;

public class IncidentEvent
implements ToXContentObject {
    static final String HOST = "events.pagerduty.com";
    static final String PATH = "/generic/2010-04-15/create_event.json";
    final String description;
    @Nullable
    final HttpProxy proxy;
    @Nullable
    final String incidentKey;
    @Nullable
    final String client;
    @Nullable
    final String clientUrl;
    @Nullable
    final String account;
    final String eventType;
    final boolean attachPayload;
    @Nullable
    final IncidentEventContext[] contexts;

    public IncidentEvent(String description, @Nullable String eventType, @Nullable String incidentKey, @Nullable String client, @Nullable String clientUrl, @Nullable String account, boolean attachPayload, @Nullable IncidentEventContext[] contexts, @Nullable HttpProxy proxy) {
        this.description = description;
        if (description == null) {
            throw new IllegalStateException("could not create pagerduty event. missing required [" + Fields.DESCRIPTION.getPreferredName() + "] setting");
        }
        this.incidentKey = incidentKey;
        this.client = client;
        this.clientUrl = clientUrl;
        this.account = account;
        this.proxy = proxy;
        this.attachPayload = attachPayload;
        this.contexts = contexts;
        this.eventType = Strings.hasLength((String)eventType) ? eventType : "trigger";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentEvent template = (IncidentEvent)o;
        return Objects.equals(this.description, template.description) && Objects.equals(this.incidentKey, template.incidentKey) && Objects.equals(this.client, template.client) && Objects.equals(this.clientUrl, template.clientUrl) && Objects.equals(this.attachPayload, template.attachPayload) && Objects.equals(this.eventType, template.eventType) && Objects.equals(this.account, template.account) && Objects.equals(this.proxy, template.proxy) && Arrays.equals(this.contexts, template.contexts);
    }

    public int hashCode() {
        int result = Objects.hash(this.description, this.incidentKey, this.client, this.clientUrl, this.account, this.attachPayload, this.eventType, this.proxy);
        result = 31 * result + Arrays.hashCode(this.contexts);
        return result;
    }

    public HttpRequest createRequest(final String serviceKey, final Payload payload) throws IOException {
        return HttpRequest.builder(HOST, -1).method(HttpMethod.POST).scheme(Scheme.HTTPS).path(PATH).proxy(this.proxy).jsonBody(new ToXContent(){

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.field(Fields.SERVICE_KEY.getPreferredName(), serviceKey);
                builder.field(Fields.EVENT_TYPE.getPreferredName(), IncidentEvent.this.eventType);
                builder.field(Fields.DESCRIPTION.getPreferredName(), IncidentEvent.this.description);
                if (IncidentEvent.this.incidentKey != null) {
                    builder.field(Fields.INCIDENT_KEY.getPreferredName(), IncidentEvent.this.incidentKey);
                }
                if (IncidentEvent.this.client != null) {
                    builder.field(Fields.CLIENT.getPreferredName(), IncidentEvent.this.client);
                }
                if (IncidentEvent.this.clientUrl != null) {
                    builder.field(Fields.CLIENT_URL.getPreferredName(), IncidentEvent.this.clientUrl);
                }
                if (IncidentEvent.this.attachPayload) {
                    builder.startObject(Fields.DETAILS.getPreferredName());
                    builder.field(Fields.PAYLOAD.getPreferredName());
                    payload.toXContent(builder, params);
                    builder.endObject();
                }
                if (IncidentEvent.this.contexts != null && IncidentEvent.this.contexts.length > 0) {
                    builder.startArray(Fields.CONTEXT.getPreferredName());
                    for (IncidentEventContext context : IncidentEvent.this.contexts) {
                        context.toXContent(builder, params);
                    }
                    builder.endArray();
                }
                return builder;
            }
        }).build();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Fields.DESCRIPTION.getPreferredName(), this.description);
        if (this.incidentKey != null) {
            builder.field(Fields.INCIDENT_KEY.getPreferredName(), this.incidentKey);
        }
        if (this.client != null) {
            builder.field(Fields.CLIENT.getPreferredName(), this.client);
        }
        if (this.clientUrl != null) {
            builder.field(Fields.CLIENT_URL.getPreferredName(), this.clientUrl);
        }
        if (this.account != null) {
            builder.field(Fields.ACCOUNT.getPreferredName(), this.account);
        }
        if (this.proxy != null) {
            this.proxy.toXContent(builder, params);
        }
        builder.field(Fields.ATTACH_PAYLOAD.getPreferredName(), this.attachPayload);
        if (this.contexts != null) {
            builder.startArray(Fields.CONTEXT.getPreferredName());
            for (IncidentEventContext context : this.contexts) {
                context.toXContent(builder, params);
            }
            builder.endArray();
        }
        return builder.endObject();
    }

    public static Template.Builder templateBuilder(String description) {
        return IncidentEvent.templateBuilder(new TextTemplate(description));
    }

    public static Template.Builder templateBuilder(TextTemplate description) {
        return new Template.Builder(description);
    }

    static interface Fields {
        public static final ParseField TYPE = new ParseField("type", new String[0]);
        public static final ParseField EVENT_TYPE = new ParseField("event_type", new String[0]);
        public static final ParseField ACCOUNT = new ParseField("account", new String[0]);
        public static final ParseField PROXY = new ParseField("proxy", new String[0]);
        public static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
        public static final ParseField INCIDENT_KEY = new ParseField("incident_key", new String[0]);
        public static final ParseField CLIENT = new ParseField("client", new String[0]);
        public static final ParseField CLIENT_URL = new ParseField("client_url", new String[0]);
        public static final ParseField ATTACH_PAYLOAD = new ParseField("attach_payload", new String[0]);
        public static final ParseField CONTEXT = new ParseField("context", new String[0]);
        public static final ParseField SERVICE_KEY = new ParseField("service_key", new String[0]);
        public static final ParseField PAYLOAD = new ParseField("payload", new String[0]);
        public static final ParseField DETAILS = new ParseField("details", new String[0]);
    }

    public static class Template
    implements ToXContent {
        final TextTemplate description;
        final TextTemplate incidentKey;
        final TextTemplate client;
        final TextTemplate clientUrl;
        final TextTemplate eventType;
        public final String account;
        final Boolean attachPayload;
        final IncidentEventContext.Template[] contexts;
        final HttpProxy proxy;

        public Template(TextTemplate description, TextTemplate eventType, TextTemplate incidentKey, TextTemplate client, TextTemplate clientUrl, String account, Boolean attachPayload, IncidentEventContext.Template[] contexts, HttpProxy proxy) {
            this.description = description;
            this.eventType = eventType;
            this.incidentKey = incidentKey;
            this.client = client;
            this.clientUrl = clientUrl;
            this.account = account;
            this.attachPayload = attachPayload;
            this.contexts = contexts;
            this.proxy = proxy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Template template = (Template)o;
            return Objects.equals(this.description, template.description) && Objects.equals(this.incidentKey, template.incidentKey) && Objects.equals(this.client, template.client) && Objects.equals(this.clientUrl, template.clientUrl) && Objects.equals(this.eventType, template.eventType) && Objects.equals(this.attachPayload, template.attachPayload) && Objects.equals(this.account, template.account) && Objects.equals(this.proxy, template.proxy) && Arrays.equals(this.contexts, template.contexts);
        }

        public int hashCode() {
            int result = Objects.hash(this.description, this.eventType, this.incidentKey, this.client, this.clientUrl, this.attachPayload, this.account, this.proxy);
            result = 31 * result + Arrays.hashCode(this.contexts);
            return result;
        }

        public IncidentEvent render(String watchId, String actionId, TextTemplateEngine engine, Map<String, Object> model, IncidentEventDefaults defaults) {
            String description;
            String string = description = this.description != null ? engine.render(this.description, model) : defaults.description;
            String incidentKey = this.incidentKey != null ? engine.render(this.incidentKey, model) : (defaults.incidentKey != null ? defaults.incidentKey : watchId);
            String client = this.client != null ? engine.render(this.client, model) : defaults.client;
            String clientUrl = this.clientUrl != null ? engine.render(this.clientUrl, model) : defaults.clientUrl;
            String eventType = this.eventType != null ? engine.render(this.eventType, model) : defaults.eventType;
            boolean attachPayload = this.attachPayload != null ? this.attachPayload : defaults.attachPayload;
            IncidentEventContext[] contexts = null;
            if (this.contexts != null) {
                contexts = new IncidentEventContext[this.contexts.length];
                for (int i = 0; i < this.contexts.length; ++i) {
                    contexts[i] = this.contexts[i].render(engine, model, defaults);
                }
            }
            return new IncidentEvent(description, eventType, incidentKey, client, clientUrl, this.account, attachPayload, contexts, this.proxy);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Fields.DESCRIPTION.getPreferredName(), (ToXContent)this.description, params);
            if (this.incidentKey != null) {
                builder.field(Fields.INCIDENT_KEY.getPreferredName(), (ToXContent)this.incidentKey, params);
            }
            if (this.client != null) {
                builder.field(Fields.CLIENT.getPreferredName(), (ToXContent)this.client, params);
            }
            if (this.clientUrl != null) {
                builder.field(Fields.CLIENT_URL.getPreferredName(), (ToXContent)this.clientUrl, params);
            }
            if (this.eventType != null) {
                builder.field(Fields.EVENT_TYPE.getPreferredName(), (ToXContent)this.eventType, params);
            }
            if (this.attachPayload != null) {
                builder.field(Fields.ATTACH_PAYLOAD.getPreferredName(), this.attachPayload);
            }
            if (this.account != null) {
                builder.field(Fields.ACCOUNT.getPreferredName(), this.account);
            }
            if (this.proxy != null) {
                this.proxy.toXContent(builder, params);
            }
            if (this.contexts != null) {
                builder.startArray(Fields.CONTEXT.getPreferredName());
                for (IncidentEventContext.Template context : this.contexts) {
                    context.toXContent(builder, params);
                }
                builder.endArray();
            }
            return builder.endObject();
        }

        public static Template parse(String watchId, String actionId, XContentParser parser) throws IOException {
            XContentParser.Token token;
            TextTemplate incidentKey = null;
            TextTemplate description = null;
            TextTemplate client = null;
            TextTemplate clientUrl = null;
            TextTemplate eventType = null;
            String account = null;
            HttpProxy proxy = null;
            Boolean attachPayload = null;
            IncidentEventContext.Template[] contexts = null;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (Fields.INCIDENT_KEY.match(currentFieldName)) {
                    try {
                        incidentKey = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException e) {
                        throw new ElasticsearchParseException("could not parse pager duty event template. failed to parse field [{}]", new Object[]{Fields.INCIDENT_KEY.getPreferredName()});
                    }
                }
                if (Fields.DESCRIPTION.match(currentFieldName)) {
                    try {
                        description = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException e) {
                        throw new ElasticsearchParseException("could not parse pager duty event template. failed to parse field [{}]", new Object[]{Fields.DESCRIPTION.getPreferredName()});
                    }
                }
                if (Fields.CLIENT.match(currentFieldName)) {
                    try {
                        client = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException e) {
                        throw new ElasticsearchParseException("could not parse pager duty event template. failed to parse field [{}]", new Object[]{Fields.CLIENT.getPreferredName()});
                    }
                }
                if (Fields.CLIENT_URL.match(currentFieldName)) {
                    try {
                        clientUrl = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException e) {
                        throw new ElasticsearchParseException("could not parse pager duty event template. failed to parse field [{}]", new Object[]{Fields.CLIENT_URL.getPreferredName()});
                    }
                }
                if (Fields.ACCOUNT.match(currentFieldName)) {
                    try {
                        account = parser.text();
                        continue;
                    }
                    catch (ElasticsearchParseException e) {
                        throw new ElasticsearchParseException("could not parse pager duty event template. failed to parse field [{}]", new Object[]{Fields.CLIENT_URL.getPreferredName()});
                    }
                }
                if (Fields.PROXY.match(currentFieldName)) {
                    proxy = HttpProxy.parse(parser);
                    continue;
                }
                if (Fields.EVENT_TYPE.match(currentFieldName)) {
                    try {
                        eventType = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException e) {
                        throw new ElasticsearchParseException("could not parse pager duty event template. failed to parse field [{}]", new Object[]{Fields.EVENT_TYPE.getPreferredName()});
                    }
                }
                if (Fields.ATTACH_PAYLOAD.match(currentFieldName)) {
                    if (token == XContentParser.Token.VALUE_BOOLEAN) {
                        attachPayload = parser.booleanValue();
                        continue;
                    }
                    throw new ElasticsearchParseException("could not parse pager duty event template. failed to parse field [{}], expected a boolean value but found [{}] instead", new Object[]{Fields.ATTACH_PAYLOAD.getPreferredName(), token});
                }
                if (Fields.CONTEXT.match(currentFieldName)) {
                    if (token != XContentParser.Token.START_ARRAY) continue;
                    ArrayList<IncidentEventContext.Template> list = new ArrayList<IncidentEventContext.Template>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        try {
                            list.add(IncidentEventContext.Template.parse(parser));
                        }
                        catch (ElasticsearchParseException e) {
                            throw new ElasticsearchParseException("could not parse pager duty event template. failed to parse field [{}]", new Object[]{Fields.CONTEXT.getPreferredName()});
                        }
                    }
                    contexts = list.toArray(new IncidentEventContext.Template[list.size()]);
                    continue;
                }
                throw new ElasticsearchParseException("could not parse pager duty event template. unexpected field [{}]", new Object[]{currentFieldName});
            }
            return new Template(description, eventType, incidentKey, client, clientUrl, account, attachPayload, contexts, proxy);
        }

        public static class Builder {
            final TextTemplate description;
            TextTemplate incidentKey;
            TextTemplate client;
            TextTemplate clientUrl;
            TextTemplate eventType;
            String account;
            HttpProxy proxy;
            Boolean attachPayload;
            List<IncidentEventContext.Template> contexts = new ArrayList<IncidentEventContext.Template>();

            public Builder(TextTemplate description) {
                this.description = description;
            }

            public Builder setIncidentKey(TextTemplate incidentKey) {
                this.incidentKey = incidentKey;
                return this;
            }

            public Builder setClient(TextTemplate client) {
                this.client = client;
                return this;
            }

            public Builder setClientUrl(TextTemplate clientUrl) {
                this.clientUrl = clientUrl;
                return this;
            }

            public Builder setEventType(TextTemplate eventType) {
                this.eventType = eventType;
                return this;
            }

            public Builder setAccount(String account) {
                this.account = account;
                return this;
            }

            public Builder setAttachPayload(Boolean attachPayload) {
                this.attachPayload = attachPayload;
                return this;
            }

            public Builder setProxy(HttpProxy proxy) {
                this.proxy = proxy;
                return this;
            }

            public Builder addContext(IncidentEventContext.Template context) {
                this.contexts.add(context);
                return this;
            }

            public Template build() {
                IncidentEventContext.Template[] contexts = this.contexts.isEmpty() ? null : this.contexts.toArray(new IncidentEventContext.Template[this.contexts.size()]);
                return new Template(this.description, this.eventType, this.incidentKey, this.client, this.clientUrl, this.account, this.attachPayload, contexts, this.proxy);
            }
        }
    }
}

