/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.role;

import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.security.action.role.DeleteRoleRequest;
import org.elasticsearch.xpack.security.action.role.DeleteRoleResponse;
import org.elasticsearch.xpack.security.authz.store.NativeRolesStore;
import org.elasticsearch.xpack.security.authz.store.ReservedRolesStore;

public class TransportDeleteRoleAction
extends HandledTransportAction<DeleteRoleRequest, DeleteRoleResponse> {
    private final NativeRolesStore rolesStore;

    @Inject
    public TransportDeleteRoleAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NativeRolesStore rolesStore, TransportService transportService) {
        super(settings, "cluster:admin/xpack/security/role/delete", threadPool, transportService, actionFilters, indexNameExpressionResolver, DeleteRoleRequest::new);
        this.rolesStore = rolesStore;
    }

    protected void doExecute(DeleteRoleRequest request, final ActionListener<DeleteRoleResponse> listener) {
        if (ReservedRolesStore.isReserved(request.name())) {
            listener.onFailure((Exception)new IllegalArgumentException("role [" + request.name() + "] is reserved and cannot be deleted"));
            return;
        }
        try {
            this.rolesStore.deleteRole(request, new ActionListener<Boolean>(){

                public void onResponse(Boolean found) {
                    listener.onResponse((Object)new DeleteRoleResponse(found));
                }

                public void onFailure(Exception t) {
                    listener.onFailure(t);
                }
            });
        }
        catch (Exception e) {
            this.logger.error(() -> new ParameterizedMessage("failed to delete role [{}]", (Object)request.name()), (Throwable)e);
            listener.onFailure(e);
        }
    }
}

