/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.audit.index;

import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class IndexNameResolver {
    private IndexNameResolver() {
    }

    public static String resolve(DateTime timestamp, Rollover rollover) {
        return rollover.formatter().print((ReadableInstant)timestamp);
    }

    public static String resolve(String indexNamePrefix, DateTime timestamp, Rollover rollover) {
        return indexNamePrefix + IndexNameResolver.resolve(timestamp, rollover);
    }

    public static enum Rollover {
        HOURLY("-yyyy.MM.dd.HH"),
        DAILY("-yyyy.MM.dd"),
        WEEKLY("-yyyy.w"),
        MONTHLY("-yyyy.MM");

        private final DateTimeFormatter formatter;

        private Rollover(String format) {
            this.formatter = DateTimeFormat.forPattern((String)format);
        }

        DateTimeFormatter formatter() {
            return this.formatter;
        }
    }
}

