/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.esnative;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;
import org.elasticsearch.xpack.security.authc.support.CachingUsernamePasswordRealm;
import org.elasticsearch.xpack.security.authc.support.Hasher;
import org.elasticsearch.xpack.security.authc.support.SecuredString;
import org.elasticsearch.xpack.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.security.support.Exceptions;
import org.elasticsearch.xpack.security.user.AnonymousUser;
import org.elasticsearch.xpack.security.user.ElasticUser;
import org.elasticsearch.xpack.security.user.KibanaUser;
import org.elasticsearch.xpack.security.user.LogstashSystemUser;
import org.elasticsearch.xpack.security.user.User;

public class ReservedRealm
extends CachingUsernamePasswordRealm {
    public static final String TYPE = "reserved";
    static final char[] DEFAULT_PASSWORD_HASH = Hasher.BCRYPT.hash(new SecuredString("changeme".toCharArray()));
    private static final NativeUsersStore.ReservedUserInfo DEFAULT_USER_INFO = new NativeUsersStore.ReservedUserInfo(DEFAULT_PASSWORD_HASH, true);
    private static final NativeUsersStore.ReservedUserInfo DISABLED_USER_INFO = new NativeUsersStore.ReservedUserInfo(DEFAULT_PASSWORD_HASH, false);
    private final NativeUsersStore nativeUsersStore;
    private final AnonymousUser anonymousUser;
    private final boolean anonymousEnabled;
    private final boolean enabled;

    public ReservedRealm(Environment env, Settings settings, NativeUsersStore nativeUsersStore, AnonymousUser anonymousUser) {
        super(TYPE, new RealmConfig(TYPE, Settings.EMPTY, settings, env));
        this.nativeUsersStore = nativeUsersStore;
        this.enabled = (Boolean)XPackSettings.RESERVED_REALM_ENABLED_SETTING.get(settings);
        this.anonymousUser = anonymousUser;
        this.anonymousEnabled = AnonymousUser.isAnonymousEnabled(settings);
    }

    @Override
    protected void doAuthenticate(UsernamePasswordToken token, ActionListener<User> listener) {
        if (!this.enabled) {
            listener.onResponse(null);
        } else if (!ReservedRealm.isReserved(token.principal(), this.config.globalSettings())) {
            listener.onResponse(null);
        } else {
            this.getUserInfo(token.principal(), (ActionListener<NativeUsersStore.ReservedUserInfo>)ActionListener.wrap(userInfo -> {
                Runnable action;
                if (userInfo != null) {
                    try {
                        if (Hasher.BCRYPT.verify(token.credentials(), userInfo.passwordHash)) {
                            User user = this.getUser(token.principal(), (NativeUsersStore.ReservedUserInfo)userInfo);
                            action = () -> listener.onResponse((Object)user);
                        }
                        action = () -> listener.onFailure((Exception)((Object)Exceptions.authenticationError("failed to authenticate user [{}]", token.principal())));
                    }
                    finally {
                        if (userInfo.passwordHash != DEFAULT_PASSWORD_HASH) {
                            Arrays.fill(userInfo.passwordHash, '\u0000');
                        }
                    }
                } else {
                    action = () -> listener.onFailure((Exception)((Object)Exceptions.authenticationError("failed to authenticate user [{}]", token.principal())));
                }
                action.run();
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }

    @Override
    protected void doLookupUser(String username, ActionListener<User> listener) {
        if (!this.enabled) {
            if (this.anonymousEnabled && AnonymousUser.isAnonymousUsername(username, this.config.globalSettings())) {
                listener.onResponse((Object)this.anonymousUser);
            }
            listener.onResponse(null);
        } else if (!ReservedRealm.isReserved(username, this.config.globalSettings())) {
            listener.onResponse(null);
        } else if (AnonymousUser.isAnonymousUsername(username, this.config.globalSettings())) {
            listener.onResponse((Object)(this.anonymousEnabled ? this.anonymousUser : null));
        } else {
            this.getUserInfo(username, (ActionListener<NativeUsersStore.ReservedUserInfo>)ActionListener.wrap(userInfo -> {
                if (userInfo != null) {
                    listener.onResponse((Object)this.getUser(username, (NativeUsersStore.ReservedUserInfo)userInfo));
                } else {
                    listener.onFailure((Exception)((Object)Exceptions.authenticationError("failed to lookup user [{}]", username)));
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }

    @Override
    public boolean userLookupSupported() {
        return true;
    }

    public static boolean isReserved(String username, Settings settings) {
        assert (username != null);
        switch (username) {
            case "elastic": 
            case "kibana": 
            case "logstash_system": {
                return (Boolean)XPackSettings.RESERVED_REALM_ENABLED_SETTING.get(settings);
            }
        }
        return AnonymousUser.isAnonymousUsername(username, settings);
    }

    private User getUser(String username, NativeUsersStore.ReservedUserInfo userInfo) {
        assert (username != null);
        switch (username) {
            case "elastic": {
                return new ElasticUser(userInfo.enabled);
            }
            case "kibana": {
                return new KibanaUser(userInfo.enabled);
            }
            case "logstash_system": {
                return new LogstashSystemUser(userInfo.enabled);
            }
        }
        if (this.anonymousEnabled && this.anonymousUser.principal().equals(username)) {
            return this.anonymousUser;
        }
        return null;
    }

    public void users(ActionListener<Collection<User>> listener) {
        if (!this.nativeUsersStore.started() || !this.enabled) {
            listener.onResponse(this.anonymousEnabled ? Collections.singletonList(this.anonymousUser) : Collections.emptyList());
        } else {
            this.nativeUsersStore.getAllReservedUserInfo((ActionListener<Map<String, NativeUsersStore.ReservedUserInfo>>)ActionListener.wrap(reservedUserInfos -> {
                ArrayList<User> users = new ArrayList<User>(4);
                NativeUsersStore.ReservedUserInfo userInfo = (NativeUsersStore.ReservedUserInfo)reservedUserInfos.get("elastic");
                users.add(new ElasticUser(userInfo == null || userInfo.enabled));
                userInfo = (NativeUsersStore.ReservedUserInfo)reservedUserInfos.get("kibana");
                users.add(new KibanaUser(userInfo == null || userInfo.enabled));
                userInfo = (NativeUsersStore.ReservedUserInfo)reservedUserInfos.get("logstash_system");
                users.add(new LogstashSystemUser(userInfo == null || userInfo.enabled));
                if (this.anonymousEnabled) {
                    users.add(this.anonymousUser);
                }
                listener.onResponse(users);
            }, e -> {
                this.logger.error("failed to retrieve reserved users", (Throwable)e);
                listener.onResponse(this.anonymousEnabled ? Collections.singletonList(this.anonymousUser) : Collections.emptyList());
            }));
        }
    }

    private void getUserInfo(String username, ActionListener<NativeUsersStore.ReservedUserInfo> listener) {
        if (!this.nativeUsersStore.started()) {
            listener.onResponse(null);
        } else if (!this.userIsDefinedForCurrentSecurityMapping(username)) {
            this.logger.debug("Marking user [{}] as disabled because the security mapping is not at the required version", (Object)username);
            listener.onResponse((Object)DISABLED_USER_INFO);
        } else if (!this.nativeUsersStore.securityIndexExists()) {
            listener.onResponse((Object)DEFAULT_USER_INFO);
        } else {
            this.nativeUsersStore.getReservedUserInfo(username, (ActionListener<NativeUsersStore.ReservedUserInfo>)ActionListener.wrap(userInfo -> {
                if (userInfo == null) {
                    listener.onResponse((Object)DEFAULT_USER_INFO);
                } else {
                    listener.onResponse(userInfo);
                }
            }, e -> {
                this.logger.error(() -> new ParameterizedMessage("failed to retrieve password hash for reserved user [{}]", (Object)username), (Throwable)e);
                listener.onResponse(null);
            }));
        }
    }

    private boolean userIsDefinedForCurrentSecurityMapping(String username) {
        Version requiredVersion = this.getDefinedVersion(username);
        return this.nativeUsersStore.checkMappingVersion(arg_0 -> ((Version)requiredVersion).onOrBefore(arg_0));
    }

    private Version getDefinedVersion(String username) {
        switch (username) {
            case "logstash_system": {
                return LogstashSystemUser.DEFINED_SINCE;
            }
        }
        return Version.V_5_0_0;
    }
}

