/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.file;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.env.Environment;
import org.elasticsearch.watcher.FileChangesListener;
import org.elasticsearch.watcher.FileWatcher;
import org.elasticsearch.watcher.ResourceWatcher;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.XPackPlugin;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.support.NoOpLogger;
import org.elasticsearch.xpack.security.support.SecurityFiles;
import org.elasticsearch.xpack.security.support.Validation;

public class FileUserRolesStore {
    private static final Pattern USERS_DELIM = Pattern.compile("\\s*,\\s*");
    private final Logger logger;
    private final Path file;
    private final CopyOnWriteArrayList<Runnable> listeners;
    private volatile Map<String, String[]> userRoles;

    FileUserRolesStore(RealmConfig config, ResourceWatcherService watcherService) {
        this(config, watcherService, () -> {});
    }

    FileUserRolesStore(RealmConfig config, ResourceWatcherService watcherService, Runnable listener) {
        this.logger = config.logger(FileUserRolesStore.class);
        this.file = FileUserRolesStore.resolveFile(config.env());
        this.userRoles = FileUserRolesStore.parseFileLenient(this.file, this.logger);
        this.listeners = new CopyOnWriteArrayList<Runnable>(Collections.singletonList(listener));
        FileWatcher watcher = new FileWatcher(this.file.getParent());
        watcher.addListener((Object)new FileListener());
        try {
            watcherService.add((ResourceWatcher)watcher, ResourceWatcherService.Frequency.HIGH);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to start watching the user roles file [" + this.file.toAbsolutePath() + "]", (Throwable)e, new Object[0]);
        }
    }

    public void addListener(Runnable listener) {
        this.listeners.add(listener);
    }

    int entriesCount() {
        return this.userRoles.size();
    }

    public String[] roles(String username) {
        if (this.userRoles == null) {
            return Strings.EMPTY_ARRAY;
        }
        String[] roles = this.userRoles.get(username);
        return roles == null ? Strings.EMPTY_ARRAY : this.userRoles.get(username);
    }

    public static Path resolveFile(Environment env) {
        return XPackPlugin.resolveConfigFile(env, "users_roles");
    }

    static Map<String, String[]> parseFileLenient(Path path, Logger logger) {
        try {
            return FileUserRolesStore.parseFile(path, logger);
        }
        catch (Exception e) {
            logger.error(() -> new ParameterizedMessage("failed to parse users_roles file [{}]. skipping/removing all entries...", (Object)path.toAbsolutePath()), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static Map<String, String[]> parseFile(Path path, @Nullable Logger logger) {
        List<String> lines;
        if (logger == null) {
            logger = NoOpLogger.INSTANCE;
        }
        logger.trace("reading users_roles file [{}]...", (Object)path.toAbsolutePath());
        if (!Files.exists(path, new LinkOption[0])) {
            return Collections.emptyMap();
        }
        try {
            lines = Files.readAllLines(path, StandardCharsets.UTF_8);
        }
        catch (IOException ioe) {
            throw new ElasticsearchException("could not read users file [" + path.toAbsolutePath() + "]", (Throwable)ioe, new Object[0]);
        }
        HashMap<String, ArrayList<String>> userToRoles = new HashMap<String, ArrayList<String>>();
        int lineNr = 0;
        for (String line : lines) {
            ++lineNr;
            if (line.startsWith("#")) continue;
            int i = line.indexOf(":");
            if (i <= 0 || i == line.length() - 1) {
                logger.error("invalid entry in users_roles file [{}], line [{}]. skipping...", (Object)path.toAbsolutePath(), (Object)lineNr);
                continue;
            }
            String role = line.substring(0, i).trim();
            Validation.Error validationError = Validation.Roles.validateRoleName(role, true);
            if (validationError != null) {
                logger.error("invalid role entry in users_roles file [{}], line [{}] - {}. skipping...", (Object)path.toAbsolutePath(), (Object)lineNr, (Object)validationError);
                continue;
            }
            String usersStr = line.substring(i + 1).trim();
            if (Strings.isEmpty((CharSequence)usersStr)) {
                logger.error("invalid entry for role [{}] in users_roles file [{}], line [{}]. no users found. skipping...", (Object)role, (Object)path.toAbsolutePath(), (Object)lineNr);
                continue;
            }
            String[] roleUsers = USERS_DELIM.split(usersStr);
            if (roleUsers.length == 0) {
                logger.error("invalid entry for role [{}] in users_roles file [{}], line [{}]. no users found. skipping...", (Object)role, (Object)path.toAbsolutePath(), (Object)lineNr);
                continue;
            }
            for (String user : roleUsers) {
                ArrayList<String> roles = (ArrayList<String>)userToRoles.get(user);
                if (roles == null) {
                    roles = new ArrayList<String>();
                    userToRoles.put(user, roles);
                }
                roles.add(role);
            }
        }
        HashMap usersRoles = new HashMap();
        for (Map.Entry entry : userToRoles.entrySet()) {
            usersRoles.put(entry.getKey(), ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]));
        }
        logger.debug("parsed [{}] user to role mappings from file [{}]", (Object)usersRoles.size(), (Object)path.toAbsolutePath());
        return Collections.unmodifiableMap(usersRoles);
    }

    public static void writeFile(Map<String, String[]> userToRoles, Path path) {
        HashMap<Object, ArrayList<String>> roleToUsers = new HashMap<Object, ArrayList<String>>();
        for (Map.Entry<String, String[]> entry : userToRoles.entrySet()) {
            for (String role : entry.getValue()) {
                ArrayList<String> users = (ArrayList<String>)roleToUsers.get(role);
                if (users == null) {
                    users = new ArrayList<String>();
                    roleToUsers.put(role, users);
                }
                users.add(entry.getKey());
            }
        }
        try (PrintWriter writer = new PrintWriter(SecurityFiles.openAtomicMoveWriter(path));){
            for (Map.Entry entry : roleToUsers.entrySet()) {
                writer.printf(Locale.ROOT, "%s:%s%s", entry.getKey(), Strings.collectionToCommaDelimitedString((Iterable)((Iterable)entry.getValue())), System.lineSeparator());
            }
        }
        catch (IOException ioe) {
            throw new ElasticsearchException("could not write file [" + path.toAbsolutePath() + "], please check file permissions", (Throwable)ioe, new Object[0]);
        }
    }

    void notifyRefresh() {
        this.listeners.forEach(Runnable::run);
    }

    private class FileListener
    implements FileChangesListener {
        private FileListener() {
        }

        public void onFileCreated(Path file) {
            this.onFileChanged(file);
        }

        public void onFileDeleted(Path file) {
            this.onFileChanged(file);
        }

        public void onFileChanged(Path file) {
            if (file.equals(FileUserRolesStore.this.file)) {
                FileUserRolesStore.this.logger.info("users roles file [{}] changed. updating users roles...", (Object)file.toAbsolutePath());
                FileUserRolesStore.this.userRoles = FileUserRolesStore.parseFileLenient(file, FileUserRolesStore.this.logger);
                FileUserRolesStore.this.notifyRefresh();
            }
        }
    }
}

