/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.SecurityContext;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.authz.AuthorizationUtils;
import org.elasticsearch.xpack.security.transport.ServerTransportFilter;
import org.elasticsearch.xpack.security.transport.netty3.SecurityNetty3Transport;
import org.elasticsearch.xpack.security.user.SystemUser;
import org.elasticsearch.xpack.security.user.User;
import org.elasticsearch.xpack.ssl.SSLService;

public class SecurityServerTransportInterceptor
extends AbstractComponent
implements TransportInterceptor {
    private static final String SETTING_NAME = "xpack.security.type";
    private final AuthenticationService authcService;
    private final AuthorizationService authzService;
    private final SSLService sslService;
    private final Map<String, ServerTransportFilter> profileFilters;
    private final XPackLicenseState licenseState;
    private final ThreadPool threadPool;
    private final Settings settings;
    private final SecurityContext securityContext;
    private final boolean reservedRealmEnabled;

    public SecurityServerTransportInterceptor(Settings settings, ThreadPool threadPool, AuthenticationService authcService, AuthorizationService authzService, XPackLicenseState licenseState, SSLService sslService, SecurityContext securityContext, DestructiveOperations destructiveOperations) {
        super(settings);
        this.settings = settings;
        this.threadPool = threadPool;
        this.authcService = authcService;
        this.authzService = authzService;
        this.licenseState = licenseState;
        this.sslService = sslService;
        this.securityContext = securityContext;
        this.profileFilters = this.initializeProfileFilters(destructiveOperations);
        this.reservedRealmEnabled = (Boolean)XPackSettings.RESERVED_REALM_ENABLED_SETTING.get(settings);
    }

    public TransportInterceptor.AsyncSender interceptSender(final TransportInterceptor.AsyncSender sender) {
        return new TransportInterceptor.AsyncSender(){

            public <T extends TransportResponse> void sendRequest(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
                if (SecurityServerTransportInterceptor.this.licenseState.isAuthAllowed()) {
                    if (AuthorizationUtils.shouldReplaceUserWithSystem(SecurityServerTransportInterceptor.this.threadPool.getThreadContext(), action)) {
                        SecurityServerTransportInterceptor.this.securityContext.executeAsUser(SystemUser.INSTANCE, original -> SecurityServerTransportInterceptor.this.sendWithUser(connection, action, request, options, (TransportResponseHandler)new TransportService.ContextRestoreResponseHandler(SecurityServerTransportInterceptor.this.threadPool.getThreadContext().wrapRestorable(original), handler), sender));
                    } else if (SecurityServerTransportInterceptor.this.reservedRealmEnabled && connection.getVersion().before(Version.V_5_2_0_UNRELEASED) && "kibana".equals(SecurityServerTransportInterceptor.this.securityContext.getUser().principal())) {
                        User kibanaUser = SecurityServerTransportInterceptor.this.securityContext.getUser();
                        User bwcKibanaUser = new User(kibanaUser.principal(), new String[]{"kibana"}, kibanaUser.fullName(), kibanaUser.email(), kibanaUser.metadata(), kibanaUser.enabled());
                        SecurityServerTransportInterceptor.this.securityContext.executeAsUser(bwcKibanaUser, original -> SecurityServerTransportInterceptor.this.sendWithUser(connection, action, request, options, (TransportResponseHandler)new TransportService.ContextRestoreResponseHandler(SecurityServerTransportInterceptor.this.threadPool.getThreadContext().wrapRestorable(original), handler), sender));
                    } else {
                        SecurityServerTransportInterceptor.this.sendWithUser(connection, action, request, options, handler, sender);
                    }
                } else {
                    sender.sendRequest(connection, action, request, options, handler);
                }
            }
        };
    }

    private <T extends TransportResponse> void sendWithUser(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler, TransportInterceptor.AsyncSender sender) {
        if (this.securityContext.getAuthentication() == null) {
            throw new IllegalStateException("there should always be a user when sending a message");
        }
        try {
            sender.sendRequest(connection, action, request, options, handler);
        }
        catch (Exception e) {
            handler.handleException(new TransportException("failed sending request", (Throwable)e));
        }
    }

    public <T extends TransportRequest> TransportRequestHandler<T> interceptHandler(String action, String executor, boolean forceExecution, TransportRequestHandler<T> actualHandler) {
        return new ProfileSecuredRequestHandler<T>(this.logger, action, forceExecution, executor, actualHandler, this.profileFilters, this.licenseState, this.threadPool);
    }

    protected Map<String, ServerTransportFilter> initializeProfileFilters(DestructiveOperations destructiveOperations) {
        Map profileSettingsMap = this.settings.getGroups("transport.profiles.", true);
        HashMap profileFilters = new HashMap(profileSettingsMap.size() + 1);
        Settings transportSSLSettings = this.settings.getByPrefix(Security.setting("transport.ssl."));
        block6: for (Map.Entry entry : profileSettingsMap.entrySet()) {
            String type;
            Settings profileSettings = (Settings)entry.getValue();
            boolean profileSsl = (Boolean)SecurityNetty3Transport.PROFILE_SSL_SETTING.get(profileSettings);
            Settings profileSslSettings = SecurityNetty3Transport.profileSslSettings(profileSettings);
            boolean clientAuth = this.sslService.isSSLClientAuthEnabled(profileSslSettings, transportSSLSettings);
            boolean extractClientCert = profileSsl && clientAuth;
            switch (type = ((Settings)entry.getValue()).get(SETTING_NAME, "node")) {
                case "client": {
                    profileFilters.put(entry.getKey(), new ServerTransportFilter.ClientProfile(this.authcService, this.authzService, this.threadPool.getThreadContext(), extractClientCert, destructiveOperations, this.reservedRealmEnabled, this.securityContext));
                    continue block6;
                }
            }
            profileFilters.put(entry.getKey(), new ServerTransportFilter.NodeProfile(this.authcService, this.authzService, this.threadPool.getThreadContext(), extractClientCert, destructiveOperations, this.reservedRealmEnabled, this.securityContext));
        }
        if (!profileFilters.containsKey("default")) {
            boolean profileSsl = (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(this.settings);
            boolean clientAuth = this.sslService.isSSLClientAuthEnabled(transportSSLSettings);
            boolean extractClientCert = profileSsl && clientAuth;
            profileFilters.put("default", new ServerTransportFilter.NodeProfile(this.authcService, this.authzService, this.threadPool.getThreadContext(), extractClientCert, destructiveOperations, this.reservedRealmEnabled, this.securityContext));
        }
        return Collections.unmodifiableMap(profileFilters);
    }

    ServerTransportFilter transportFilter(String profile) {
        return this.profileFilters.get(profile);
    }

    public static class ProfileSecuredRequestHandler<T extends TransportRequest>
    implements TransportRequestHandler<T> {
        private final String action;
        private final TransportRequestHandler<T> handler;
        private final Map<String, ServerTransportFilter> profileFilters;
        private final XPackLicenseState licenseState;
        private final ThreadContext threadContext;
        private final String executorName;
        private final ThreadPool threadPool;
        private final boolean forceExecution;
        private final Logger logger;

        ProfileSecuredRequestHandler(Logger logger, String action, boolean forceExecution, String executorName, TransportRequestHandler<T> handler, Map<String, ServerTransportFilter> profileFilters, XPackLicenseState licenseState, ThreadPool threadPool) {
            this.logger = logger;
            this.action = action;
            this.executorName = executorName;
            this.handler = handler;
            this.profileFilters = profileFilters;
            this.licenseState = licenseState;
            this.threadContext = threadPool.getThreadContext();
            this.threadPool = threadPool;
            this.forceExecution = forceExecution;
        }

        AbstractRunnable getReceiveRunnable(T request, final TransportChannel channel, Task task) {
            return new AbstractRunnable((TransportRequest)request, task){
                final /* synthetic */ TransportRequest val$request;
                final /* synthetic */ Task val$task;
                {
                    this.val$request = transportRequest;
                    this.val$task = task;
                }

                public boolean isForceExecution() {
                    return forceExecution;
                }

                public void onFailure(Exception e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        e1.addSuppressed(e);
                        logger.warn("failed to send exception response for action [" + action + "]", (Throwable)e1);
                    }
                }

                protected void doRun() throws Exception {
                    handler.messageReceived(this.val$request, channel, this.val$task);
                }
            };
        }

        public String toString() {
            return "ProfileSecuredRequestHandler{action='" + this.action + '\'' + ", executorName='" + this.executorName + '\'' + ", forceExecution=" + this.forceExecution + '}';
        }

        public void messageReceived(T request, TransportChannel channel, Task task) throws Exception {
            AbstractRunnable receiveMessage = this.getReceiveRunnable(request, channel, task);
            try (ThreadContext.StoredContext ctx = this.threadContext.newStoredContext(true);){
                if (this.licenseState.isAuthAllowed()) {
                    String profile = channel.getProfileName();
                    ServerTransportFilter filter = this.profileFilters.get(profile);
                    if (filter == null) {
                        if (".direct".equals(profile)) {
                            filter = this.profileFilters.get("default");
                        } else {
                            String msg = "transport profile [" + profile + "] is not associated with a transport filter";
                            throw new IllegalStateException(msg);
                        }
                    }
                    assert (filter != null);
                    Thread executingThread = Thread.currentThread();
                    CheckedConsumer consumer = x -> {
                        ExecutorService executor = executingThread == Thread.currentThread() ? this.threadPool.executor("same") : this.threadPool.executor(this.executorName);
                        try {
                            executor.execute((Runnable)receiveMessage);
                        }
                        catch (Exception e) {
                            receiveMessage.onFailure(e);
                        }
                    };
                    ActionListener filterListener = ActionListener.wrap((CheckedConsumer)consumer, arg_0 -> ((AbstractRunnable)receiveMessage).onFailure(arg_0));
                    filter.inbound(this.action, (TransportRequest)request, channel, (ActionListener<Void>)filterListener);
                } else {
                    receiveMessage.run();
                }
            }
        }

        public void messageReceived(T request, TransportChannel channel) throws Exception {
            throw new UnsupportedOperationException("task parameter is required for this operation");
        }
    }
}

