/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.user;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.security.support.MetadataUtils;
import org.elasticsearch.xpack.security.user.SystemUser;
import org.elasticsearch.xpack.security.user.XPackUser;

public class User
implements ToXContentObject {
    private final String username;
    private final String[] roles;
    private final User runAs;
    private final Map<String, Object> metadata;
    private final boolean enabled;
    @Nullable
    private final String fullName;
    @Nullable
    private final String email;

    public User(String username, String ... roles) {
        this(username, roles, null, null, null, true);
    }

    public User(String username, String[] roles, User runAs) {
        this(username, roles, null, null, null, true, runAs);
    }

    public User(User user, User runAs) {
        this(user.principal(), user.roles(), user.fullName(), user.email(), user.metadata(), user.enabled(), runAs);
    }

    public User(String username, String[] roles, String fullName, String email, Map<String, Object> metadata, boolean enabled) {
        this.username = username;
        this.roles = roles == null ? Strings.EMPTY_ARRAY : roles;
        this.metadata = metadata != null ? Collections.unmodifiableMap(metadata) : Collections.emptyMap();
        this.fullName = fullName;
        this.email = email;
        this.enabled = enabled;
        this.runAs = null;
    }

    public User(String username, String[] roles, String fullName, String email, Map<String, Object> metadata, boolean enabled, User runAs) {
        this.username = username;
        this.roles = roles == null ? Strings.EMPTY_ARRAY : roles;
        this.metadata = metadata != null ? Collections.unmodifiableMap(metadata) : Collections.emptyMap();
        this.fullName = fullName;
        this.email = email;
        this.enabled = enabled;
        assert (runAs == null || runAs.runAs() == null) : "the run_as user should not be a user that can run as";
        if (runAs == SystemUser.INSTANCE) {
            throw new ElasticsearchSecurityException("invalid run_as user", new Object[0]);
        }
        this.runAs = runAs;
    }

    public String principal() {
        return this.username;
    }

    public String[] roles() {
        return this.roles;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    public String fullName() {
        return this.fullName;
    }

    public String email() {
        return this.email;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public User runAs() {
        return this.runAs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("User[username=").append(this.username);
        sb.append(",roles=[").append(Strings.arrayToCommaDelimitedString((Object[])this.roles)).append("]");
        sb.append(",fullName=").append(this.fullName);
        sb.append(",email=").append(this.email);
        sb.append(",metadata=");
        MetadataUtils.writeValue(sb, this.metadata);
        if (this.runAs != null) {
            sb.append(",runAs=[").append(this.runAs.toString()).append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User user = (User)o;
        if (!this.username.equals(user.username)) {
            return false;
        }
        if (!Arrays.equals(this.roles, user.roles)) {
            return false;
        }
        if (this.runAs != null ? !this.runAs.equals(user.runAs) : user.runAs != null) {
            return false;
        }
        if (!this.metadata.equals(user.metadata)) {
            return false;
        }
        if (this.fullName != null ? !this.fullName.equals(user.fullName) : user.fullName != null) {
            return false;
        }
        return !(this.email == null ? user.email != null : !this.email.equals(user.email));
    }

    public int hashCode() {
        int result = this.username.hashCode();
        result = 31 * result + Arrays.hashCode(this.roles);
        result = 31 * result + (this.runAs != null ? this.runAs.hashCode() : 0);
        result = 31 * result + this.metadata.hashCode();
        result = 31 * result + (this.fullName != null ? this.fullName.hashCode() : 0);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        return result;
    }

    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Fields.USERNAME.getPreferredName(), this.principal());
        builder.array(Fields.ROLES.getPreferredName(), this.roles());
        builder.field(Fields.FULL_NAME.getPreferredName(), this.fullName());
        builder.field(Fields.EMAIL.getPreferredName(), this.email());
        builder.field(Fields.METADATA.getPreferredName(), this.metadata());
        builder.field(Fields.ENABLED.getPreferredName(), this.enabled());
        return builder.endObject();
    }

    public static User readFrom(StreamInput input) throws IOException {
        boolean isInternalUser = input.readBoolean();
        String username = input.readString();
        if (isInternalUser) {
            if (SystemUser.is(username)) {
                return SystemUser.INSTANCE;
            }
            if (XPackUser.is(username)) {
                return XPackUser.INSTANCE;
            }
            throw new IllegalStateException("user [" + username + "] is not an internal user");
        }
        String[] roles = input.readStringArray();
        Map metadata = input.readMap();
        String fullName = input.readOptionalString();
        String email = input.readOptionalString();
        boolean enabled = input.readBoolean();
        User runAs = input.readBoolean() ? User.readFrom(input) : null;
        return new User(username, roles, fullName, email, metadata, enabled, runAs);
    }

    public static void writeTo(User user, StreamOutput output) throws IOException {
        if (SystemUser.is(user)) {
            output.writeBoolean(true);
            output.writeString("_system");
        } else if (XPackUser.is(user)) {
            output.writeBoolean(true);
            output.writeString("_xpack");
        } else {
            output.writeBoolean(false);
            output.writeString(user.username);
            output.writeStringArray(user.roles);
            output.writeMap(user.metadata);
            output.writeOptionalString(user.fullName);
            output.writeOptionalString(user.email);
            output.writeBoolean(user.enabled);
            if (user.runAs == null) {
                output.writeBoolean(false);
            } else {
                output.writeBoolean(true);
                User.writeTo(user.runAs, output);
            }
        }
    }

    public static interface Fields {
        public static final ParseField USERNAME = new ParseField("username", new String[0]);
        public static final ParseField PASSWORD = new ParseField("password", new String[0]);
        public static final ParseField PASSWORD_HASH = new ParseField("password_hash", new String[0]);
        public static final ParseField ROLES = new ParseField("roles", new String[0]);
        public static final ParseField FULL_NAME = new ParseField("full_name", new String[0]);
        public static final ParseField EMAIL = new ParseField("email", new String[0]);
        public static final ParseField METADATA = new ParseField("metadata", new String[0]);
        public static final ParseField ENABLED = new ParseField("enabled", new String[0]);
    }
}

