/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ssl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.ssl.SSLClientAuth;
import org.elasticsearch.xpack.ssl.VerificationMode;

public class SSLConfigurationSettings {
    private final String prefix;
    public final Setting<List<String>> ciphers;
    public final Setting<List<String>> supportedProtocols;
    public final Setting<Optional<String>> keystorePath;
    public final Setting<Optional<String>> keystorePassword;
    public final Setting<String> keystoreAlgorithm;
    public final Setting<Optional<String>> keystoreKeyPassword;
    public final Setting<Optional<String>> truststorePath;
    public final Setting<Optional<String>> truststorePassword;
    public final Setting<String> truststoreAlgorithm;
    public final Setting<Optional<String>> keyPath;
    public final Setting<Optional<String>> keyPassword;
    public final Setting<Optional<String>> cert;
    public final Setting<List<String>> caPaths;
    public final Setting<Optional<SSLClientAuth>> clientAuth;
    public final Setting<Optional<VerificationMode>> verificationMode;

    private SSLConfigurationSettings(String prefix) {
        assert (prefix != null) : "Prefix cannot be null (but can be blank)";
        this.prefix = prefix;
        this.ciphers = this.list("cipher_suites", Collections.emptyList());
        this.supportedProtocols = this.list("supported_protocols", Collections.emptyList());
        this.keystorePath = this.optionalString("keystore.path");
        this.keystorePassword = this.optionalString("keystore.password");
        this.keystoreKeyPassword = this.optionalString("keystore.key_password", this.keystorePassword);
        this.truststorePath = this.optionalString("truststore.path");
        this.truststorePassword = this.optionalString("truststore.password");
        this.keystoreAlgorithm = this.systemProperty("keystore.algorithm", "ssl.KeyManagerFactory.algorithm", KeyManagerFactory.getDefaultAlgorithm());
        this.truststoreAlgorithm = this.systemProperty("truststore.algorithm", "ssl.TrustManagerFactory.algorithm", TrustManagerFactory.getDefaultAlgorithm());
        this.keyPath = this.optionalString("key");
        this.keyPassword = this.optionalString("key_passphrase");
        this.cert = this.optionalString("certificate");
        this.caPaths = this.list("certificate_authorities", Collections.emptyList());
        this.clientAuth = this.optional("client_authentication", SSLClientAuth::parse);
        this.verificationMode = this.optional("verification_mode", VerificationMode::parse);
    }

    public List<Setting<?>> getAllSettings() {
        return Arrays.asList(this.ciphers, this.supportedProtocols, this.keystorePath, this.keystorePassword, this.keystoreAlgorithm, this.keystoreKeyPassword, this.truststorePath, this.truststorePassword, this.truststoreAlgorithm, this.keyPath, this.keyPassword, this.cert, this.caPaths, this.clientAuth, this.verificationMode);
    }

    private Setting<Optional<String>> optionalString(String keyPart) {
        return this.optionalString(keyPart, (Settings s) -> null);
    }

    private Setting<Optional<String>> optionalString(String keyPart, Function<Settings, String> defaultValue) {
        return new Setting(this.prefix + keyPart, defaultValue, Optional::ofNullable, new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    }

    private Setting<Optional<String>> optionalString(String keyPart, Setting<Optional<String>> fallback) {
        return new Setting(this.prefix + keyPart, fallback, Optional::ofNullable, new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    }

    private <T> Setting<Optional<T>> optional(String keyPart, Function<String, T> parserIfNotNull) {
        Function<String, Optional> parser = s -> {
            if (s == null) {
                return Optional.empty();
            }
            return Optional.of(parserIfNotNull.apply((String)s));
        };
        return new Setting(this.prefix + keyPart, (String)null, parser, new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    }

    private Setting<String> systemProperty(String keyPart, String systemProperty, String defaultValue) {
        return this.string(keyPart, s -> System.getProperty(systemProperty, defaultValue));
    }

    private Setting<String> string(String keyPart, Function<Settings, String> defaultFunction) {
        return new Setting(this.prefix + keyPart, defaultFunction, Function.identity(), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    }

    private Setting<List<String>> list(String keyPart, List<String> defaultValue) {
        return Setting.listSetting((String)(this.prefix + keyPart), defaultValue, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    }

    public static SSLConfigurationSettings withoutPrefix() {
        return new SSLConfigurationSettings("");
    }

    public static SSLConfigurationSettings withPrefix(String prefix) {
        assert (prefix.endsWith("ssl.")) : "The ssl config prefix (" + prefix + ") should end in 'ssl.'";
        return new SSLConfigurationSettings(prefix);
    }
}

