/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.webhook;

import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xpack.common.http.HttpClient;
import org.elasticsearch.xpack.common.http.HttpRequest;
import org.elasticsearch.xpack.common.http.HttpResponse;
import org.elasticsearch.xpack.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.watcher.actions.Action;
import org.elasticsearch.xpack.watcher.actions.ExecutableAction;
import org.elasticsearch.xpack.watcher.actions.webhook.WebhookAction;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.watcher.input.http.ExecutableHttpInput;
import org.elasticsearch.xpack.watcher.support.Variables;
import org.elasticsearch.xpack.watcher.watch.Payload;

public class ExecutableWebhookAction
extends ExecutableAction<WebhookAction> {
    private final HttpClient httpClient;
    private final TextTemplateEngine templateEngine;

    public ExecutableWebhookAction(WebhookAction action, Logger logger, HttpClient httpClient, TextTemplateEngine templateEngine) {
        super(action, logger);
        this.httpClient = httpClient;
        this.templateEngine = templateEngine;
    }

    @Override
    public Action.Result execute(String actionId, WatchExecutionContext ctx, Payload payload) throws Exception {
        Map<String, Object> model = Variables.createCtxModel(ctx, payload);
        HttpRequest request = ((WebhookAction)this.action).requestTemplate.render(this.templateEngine, model);
        ExecutableHttpInput.checkUrlDepreciation(ctx.watch(), "webhook action", request, this.logger);
        if (ctx.simulateAction(actionId)) {
            return new WebhookAction.Result.Simulated(request);
        }
        HttpResponse response = this.httpClient.execute(request);
        int status = response.status();
        if (status >= 400) {
            this.logger.warn("received http status [{}] when connecting to watch action [{}/{}/{}]", (Object)status, (Object)ctx.watch().id(), (Object)this.type(), (Object)actionId);
            return new WebhookAction.Result.Failure(request, response);
        }
        return new WebhookAction.Result.Success(request, response);
    }
}

