/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.execution;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.execution.Wid;
import org.elasticsearch.xpack.watcher.trigger.TriggerEvent;
import org.elasticsearch.xpack.watcher.trigger.TriggerService;

public class TriggeredWatch
implements ToXContent {
    private final Wid id;
    private final TriggerEvent triggerEvent;

    public TriggeredWatch(Wid id, TriggerEvent triggerEvent) {
        this.id = id;
        this.triggerEvent = triggerEvent;
    }

    public Wid id() {
        return this.id;
    }

    public TriggerEvent triggerEvent() {
        return this.triggerEvent;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(Field.TRIGGER_EVENT.getPreferredName()).field(this.triggerEvent.type(), (ToXContent)this.triggerEvent, params).endObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriggeredWatch entry = (TriggeredWatch)o;
        return this.id.equals(entry.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id.toString();
    }

    public static interface Field {
        public static final ParseField TRIGGER_EVENT = new ParseField("trigger_event", new String[0]);
        public static final ParseField STATE = new ParseField("state", new String[0]);
    }

    public static class Parser
    extends AbstractComponent {
        private final TriggerService triggerService;

        @Inject
        public Parser(Settings settings, TriggerService triggerService) {
            super(settings);
            this.triggerService = triggerService;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public TriggeredWatch parse(String id, long version, BytesReference source) {
            try (XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (BytesReference)source);){
                TriggeredWatch triggeredWatch = this.parse(id, version, parser);
                return triggeredWatch;
            }
            catch (IOException e) {
                throw new ElasticsearchException("unable to parse watch record", (Throwable)e, new Object[0]);
            }
        }

        public TriggeredWatch parse(String id, long version, XContentParser parser) throws IOException {
            assert (id != null) : "watch record id is missing";
            Wid wid = new Wid(id);
            TriggerEvent triggerEvent = null;
            String currentFieldName = null;
            XContentParser.Token token = parser.nextToken();
            assert (token == XContentParser.Token.START_OBJECT);
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token != XContentParser.Token.START_OBJECT) continue;
                if (Field.TRIGGER_EVENT.match(currentFieldName)) {
                    triggerEvent = this.triggerService.parseTriggerEvent(wid.watchId(), id, parser);
                    continue;
                }
                parser.skipChildren();
            }
            TriggeredWatch record = new TriggeredWatch(wid, triggerEvent);
            assert (record.triggerEvent() != null) : "watch record [" + id + "] is missing trigger";
            return record;
        }
    }
}

