/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions.execute;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.support.master.MasterNodeOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.watcher.client.WatchSourceBuilder;
import org.elasticsearch.xpack.watcher.execution.ActionExecutionMode;
import org.elasticsearch.xpack.watcher.transport.actions.execute.ExecuteWatchAction;
import org.elasticsearch.xpack.watcher.transport.actions.execute.ExecuteWatchRequest;
import org.elasticsearch.xpack.watcher.transport.actions.execute.ExecuteWatchResponse;
import org.elasticsearch.xpack.watcher.trigger.TriggerEvent;

public class ExecuteWatchRequestBuilder
extends MasterNodeOperationRequestBuilder<ExecuteWatchRequest, ExecuteWatchResponse, ExecuteWatchRequestBuilder> {
    public ExecuteWatchRequestBuilder(ElasticsearchClient client) {
        super(client, (Action)ExecuteWatchAction.INSTANCE, (MasterNodeRequest)new ExecuteWatchRequest());
    }

    public ExecuteWatchRequestBuilder(ElasticsearchClient client, String watchName) {
        super(client, (Action)ExecuteWatchAction.INSTANCE, (MasterNodeRequest)new ExecuteWatchRequest(watchName));
    }

    public ExecuteWatchRequestBuilder setId(String id) {
        ((ExecuteWatchRequest)this.request()).setId(id);
        return this;
    }

    public ExecuteWatchRequestBuilder setIgnoreCondition(boolean ignoreCondition) {
        ((ExecuteWatchRequest)this.request).setIgnoreCondition(ignoreCondition);
        return this;
    }

    public ExecuteWatchRequestBuilder setRecordExecution(boolean recordExecution) {
        ((ExecuteWatchRequest)this.request).setRecordExecution(recordExecution);
        return this;
    }

    public ExecuteWatchRequestBuilder setAlternativeInput(Map<String, Object> alternativeInput) {
        ((ExecuteWatchRequest)this.request).setAlternativeInput(alternativeInput);
        return this;
    }

    public ExecuteWatchRequestBuilder setTriggerData(Map<String, Object> data) throws IOException {
        ((ExecuteWatchRequest)this.request).setTriggerData(data);
        return this;
    }

    public ExecuteWatchRequestBuilder setTriggerEvent(TriggerEvent triggerEvent) throws IOException {
        ((ExecuteWatchRequest)this.request).setTriggerEvent(triggerEvent);
        return this;
    }

    @Deprecated
    public ExecuteWatchRequestBuilder setWatchSource(BytesReference watchSource) {
        ((ExecuteWatchRequest)this.request).setWatchSource(watchSource);
        return this;
    }

    public ExecuteWatchRequestBuilder setWatchSource(BytesReference watchSource, XContentType xContentType) {
        ((ExecuteWatchRequest)this.request).setWatchSource(watchSource, xContentType);
        return this;
    }

    public ExecuteWatchRequestBuilder setWatchSource(WatchSourceBuilder watchSource) {
        ((ExecuteWatchRequest)this.request).setWatchSource(watchSource);
        return this;
    }

    public ExecuteWatchRequestBuilder setActionMode(String actionId, ActionExecutionMode actionMode) {
        ((ExecuteWatchRequest)this.request).setActionMode(actionId, actionMode);
        return this;
    }

    public ExecuteWatchRequestBuilder setDebug(boolean debug) {
        ((ExecuteWatchRequest)this.request).setDebug(debug);
        return this;
    }
}

