/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.watch;

import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.index.IndexNotFoundException;

public class WatchStoreUtils {
    public static IndexMetaData getConcreteIndex(String name, MetaData metaData) {
        AliasOrIndex aliasOrIndex = (AliasOrIndex)metaData.getAliasAndIndexLookup().get(name);
        if (aliasOrIndex == null) {
            throw new IndexNotFoundException(name);
        }
        if (aliasOrIndex.isAlias() && aliasOrIndex.getIndices().size() > 1) {
            throw new IllegalStateException("Alias [" + name + "] points to more than one index");
        }
        return (IndexMetaData)aliasOrIndex.getIndices().get(0);
    }
}

