/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.DataAssociation;
import org.flowable.bpmn.model.DataSpec;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.IOSpecification;
import org.flowable.bpmn.model.Import;
import org.flowable.bpmn.model.Interface;
import org.flowable.bpmn.model.ItemDefinition;
import org.flowable.bpmn.model.Message;
import org.flowable.bpmn.model.Operation;
import org.flowable.bpmn.model.SendTask;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.util.ReflectUtil;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.bpmn.data.AbstractDataAssociation;
import org.flowable.engine.impl.bpmn.data.Assignment;
import org.flowable.engine.impl.bpmn.data.ClassStructureDefinition;
import org.flowable.engine.impl.bpmn.data.ItemInstance;
import org.flowable.engine.impl.bpmn.data.ItemKind;
import org.flowable.engine.impl.bpmn.data.SimpleDataInputAssociation;
import org.flowable.engine.impl.bpmn.data.StructureDefinition;
import org.flowable.engine.impl.bpmn.data.TransformationDataOutputAssociation;
import org.flowable.engine.impl.bpmn.helper.ErrorPropagation;
import org.flowable.engine.impl.bpmn.parser.XMLImporter;
import org.flowable.engine.impl.bpmn.webservice.BpmnInterface;
import org.flowable.engine.impl.bpmn.webservice.MessageDefinition;
import org.flowable.engine.impl.bpmn.webservice.MessageImplicitDataInputAssociation;
import org.flowable.engine.impl.bpmn.webservice.MessageImplicitDataOutputAssociation;
import org.flowable.engine.impl.bpmn.webservice.MessageInstance;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.impl.webservice.WSOperation;
import org.flowable.engine.impl.webservice.WSService;

public class WebServiceActivityBehavior
extends AbstractBpmnActivityBehavior {
    private static final long serialVersionUID = 1L;
    public static final String CURRENT_MESSAGE = "org.flowable.engine.impl.bpmn.CURRENT_MESSAGE";
    protected Map<String, XMLImporter> xmlImporterMap = new HashMap<String, XMLImporter>();
    protected Map<String, WSOperation> wsOperationMap = new HashMap<String, WSOperation>();
    protected Map<String, StructureDefinition> structureDefinitionMap = new HashMap<String, StructureDefinition>();
    protected Map<String, WSService> wsServiceMap = new HashMap<String, WSService>();
    protected Map<String, org.flowable.engine.impl.bpmn.webservice.Operation> operationMap = new HashMap<String, org.flowable.engine.impl.bpmn.webservice.Operation>();
    protected Map<String, org.flowable.engine.impl.bpmn.data.ItemDefinition> itemDefinitionMap = new HashMap<String, org.flowable.engine.impl.bpmn.data.ItemDefinition>();
    protected Map<String, MessageDefinition> messageDefinitionMap = new HashMap<String, MessageDefinition>();

    public WebServiceActivityBehavior(BpmnModel bpmnModel) {
        this.itemDefinitionMap.put("http://www.w3.org/2001/XMLSchema:string", new org.flowable.engine.impl.bpmn.data.ItemDefinition("http://www.w3.org/2001/XMLSchema:string", new ClassStructureDefinition(String.class)));
        this.fillDefinitionMaps(bpmnModel);
    }

    @Override
    public void execute(DelegateExecution execution) {
        block12: {
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(execution.getProcessDefinitionId());
            FlowElement flowElement = execution.getCurrentFlowElement();
            IOSpecification ioSpecification = null;
            String operationRef = null;
            List dataInputAssociations = null;
            List dataOutputAssociations = null;
            if (flowElement instanceof SendTask) {
                SendTask sendTask = (SendTask)flowElement;
                ioSpecification = sendTask.getIoSpecification();
                operationRef = sendTask.getOperationRef();
                dataInputAssociations = sendTask.getDataInputAssociations();
                dataOutputAssociations = sendTask.getDataOutputAssociations();
            } else if (flowElement instanceof ServiceTask) {
                ServiceTask serviceTask = (ServiceTask)flowElement;
                ioSpecification = serviceTask.getIoSpecification();
                operationRef = serviceTask.getOperationRef();
                dataInputAssociations = serviceTask.getDataInputAssociations();
                dataOutputAssociations = serviceTask.getDataOutputAssociations();
            } else {
                throw new FlowableException("Unsupported flow element type " + flowElement + " in " + execution);
            }
            MessageInstance message = null;
            org.flowable.engine.impl.bpmn.webservice.Operation operation = this.operationMap.get(operationRef);
            try {
                String firstDataOutputName;
                if (ioSpecification != null) {
                    this.initializeIoSpecification(ioSpecification, execution, bpmnModel);
                    if (ioSpecification.getDataInputRefs().size() > 0) {
                        String firstDataInputName = (String)ioSpecification.getDataInputRefs().get(0);
                        ItemInstance inputItem = (ItemInstance)execution.getTransientVariable(firstDataInputName);
                        message = new MessageInstance(operation.getInMessage(), inputItem);
                    }
                } else {
                    message = operation.getInMessage().createInstance();
                }
                execution.setTransientVariable(CURRENT_MESSAGE, message);
                this.fillMessage(dataInputAssociations, execution);
                ProcessEngineConfigurationImpl processEngineConfig = CommandContextUtil.getProcessEngineConfiguration();
                MessageInstance receivedMessage = operation.sendMessage(message, processEngineConfig.getWsOverridenEndpointAddresses());
                execution.setTransientVariable(CURRENT_MESSAGE, receivedMessage);
                if (ioSpecification != null && ioSpecification.getDataOutputRefs().size() > 0 && (firstDataOutputName = (String)ioSpecification.getDataOutputRefs().get(0)) != null) {
                    ItemInstance outputItem = (ItemInstance)execution.getTransientVariable(firstDataOutputName);
                    outputItem.getStructureInstance().loadFrom(receivedMessage.getStructureInstance().toArray());
                }
                this.returnMessage(dataOutputAssociations, execution);
                execution.setTransientVariable(CURRENT_MESSAGE, null);
                this.leave(execution);
            }
            catch (Exception exc) {
                BpmnError error = null;
                for (Throwable cause = exc; cause != null; cause = cause.getCause()) {
                    if (!(cause instanceof BpmnError)) continue;
                    error = (BpmnError)((Object)cause);
                    break;
                }
                if (error != null) {
                    ErrorPropagation.propagateError(error, execution);
                }
                if (!(exc instanceof RuntimeException)) break block12;
                throw (RuntimeException)exc;
            }
        }
    }

    protected void initializeIoSpecification(IOSpecification activityIoSpecification, DelegateExecution execution, BpmnModel bpmnModel) {
        org.flowable.engine.impl.bpmn.data.ItemDefinition itemDefinition;
        for (DataSpec dataSpec : activityIoSpecification.getDataInputs()) {
            itemDefinition = this.itemDefinitionMap.get(dataSpec.getItemSubjectRef());
            execution.setTransientVariable(dataSpec.getId(), itemDefinition.createInstance());
        }
        for (DataSpec dataSpec : activityIoSpecification.getDataOutputs()) {
            itemDefinition = this.itemDefinitionMap.get(dataSpec.getItemSubjectRef());
            execution.setTransientVariable(dataSpec.getId(), itemDefinition.createInstance());
        }
    }

    protected void fillDefinitionMaps(BpmnModel bpmnModel) {
        for (Import theImport : bpmnModel.getImports()) {
            this.fillImporterInfo(theImport, bpmnModel.getSourceSystemId());
        }
        this.createItemDefinitions(bpmnModel);
        this.createMessages(bpmnModel);
        this.createOperations(bpmnModel);
    }

    protected void createItemDefinitions(BpmnModel bpmnModel) {
        for (ItemDefinition itemDefinitionElement : bpmnModel.getItemDefinitions().values()) {
            if (this.itemDefinitionMap.containsKey(itemDefinitionElement.getId())) continue;
            StructureDefinition structure = null;
            try {
                Class classStructure = ReflectUtil.loadClass((String)itemDefinitionElement.getStructureRef());
                structure = new ClassStructureDefinition(classStructure);
            }
            catch (FlowableException e) {
                structure = this.structureDefinitionMap.get(itemDefinitionElement.getStructureRef());
            }
            org.flowable.engine.impl.bpmn.data.ItemDefinition itemDefinition = new org.flowable.engine.impl.bpmn.data.ItemDefinition(itemDefinitionElement.getId(), structure);
            if (StringUtils.isNotEmpty((CharSequence)itemDefinitionElement.getItemKind())) {
                itemDefinition.setItemKind(ItemKind.valueOf(itemDefinitionElement.getItemKind()));
            }
            this.itemDefinitionMap.put(itemDefinition.getId(), itemDefinition);
        }
    }

    public void createMessages(BpmnModel bpmnModel) {
        for (Message messageElement : bpmnModel.getMessages()) {
            if (this.messageDefinitionMap.containsKey(messageElement.getId())) continue;
            MessageDefinition messageDefinition = new MessageDefinition(messageElement.getId());
            if (StringUtils.isNotEmpty((CharSequence)messageElement.getItemRef()) && this.itemDefinitionMap.containsKey(messageElement.getItemRef())) {
                org.flowable.engine.impl.bpmn.data.ItemDefinition itemDefinition = this.itemDefinitionMap.get(messageElement.getItemRef());
                messageDefinition.setItemDefinition(itemDefinition);
            }
            this.messageDefinitionMap.put(messageDefinition.getId(), messageDefinition);
        }
    }

    protected void createOperations(BpmnModel bpmnModel) {
        for (Interface interfaceObject : bpmnModel.getInterfaces()) {
            BpmnInterface bpmnInterface = new BpmnInterface(interfaceObject.getId(), interfaceObject.getName());
            bpmnInterface.setImplementation(this.wsServiceMap.get(interfaceObject.getImplementationRef()));
            for (Operation operationObject : interfaceObject.getOperations()) {
                if (this.operationMap.containsKey(operationObject.getId())) continue;
                MessageDefinition inMessage = this.messageDefinitionMap.get(operationObject.getInMessageRef());
                org.flowable.engine.impl.bpmn.webservice.Operation operation = new org.flowable.engine.impl.bpmn.webservice.Operation(operationObject.getId(), operationObject.getName(), bpmnInterface, inMessage);
                operation.setImplementation(this.wsOperationMap.get(operationObject.getImplementationRef()));
                if (StringUtils.isNotEmpty((CharSequence)operationObject.getOutMessageRef()) && this.messageDefinitionMap.containsKey(operationObject.getOutMessageRef())) {
                    MessageDefinition outMessage = this.messageDefinitionMap.get(operationObject.getOutMessageRef());
                    operation.setOutMessage(outMessage);
                }
                this.operationMap.put(operation.getId(), operation);
            }
        }
    }

    protected void fillImporterInfo(Import theImport, String sourceSystemId) {
        if (!this.xmlImporterMap.containsKey(theImport.getNamespace())) {
            if ("http://schemas.xmlsoap.org/wsdl/".equals(theImport.getImportType())) {
                try {
                    ProcessEngineConfigurationImpl processEngineConfig = CommandContextUtil.getProcessEngineConfiguration();
                    XMLImporter importerInstance = processEngineConfig.getWsdlImporterFactory().createXMLImporter(theImport);
                    this.xmlImporterMap.put(theImport.getNamespace(), importerInstance);
                    importerInstance.importFrom(theImport, sourceSystemId);
                    this.structureDefinitionMap.putAll(importerInstance.getStructures());
                    this.wsServiceMap.putAll(importerInstance.getServices());
                    this.wsOperationMap.putAll(importerInstance.getOperations());
                }
                catch (FlowableException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new FlowableException(String.format("Error importing '%s' as '%s'", theImport.getLocation(), theImport.getImportType()), (Throwable)e);
                }
            } else {
                throw new FlowableException(String.format("Unsupported import type '%s'", theImport.getImportType()));
            }
        }
    }

    protected void returnMessage(List<DataAssociation> dataOutputAssociations, DelegateExecution execution) {
        for (DataAssociation dataAssociationElement : dataOutputAssociations) {
            AbstractDataAssociation dataAssociation = this.createDataOutputAssociation(dataAssociationElement);
            dataAssociation.evaluate(execution);
        }
    }

    protected void fillMessage(List<DataAssociation> dataInputAssociations, DelegateExecution execution) {
        for (DataAssociation dataAssociationElement : dataInputAssociations) {
            AbstractDataAssociation dataAssociation = this.createDataInputAssociation(dataAssociationElement);
            dataAssociation.evaluate(execution);
        }
    }

    protected AbstractDataAssociation createDataInputAssociation(DataAssociation dataAssociationElement) {
        if (dataAssociationElement.getAssignments().isEmpty()) {
            return new MessageImplicitDataInputAssociation(dataAssociationElement.getSourceRef(), dataAssociationElement.getTargetRef());
        }
        SimpleDataInputAssociation dataAssociation = new SimpleDataInputAssociation(dataAssociationElement.getSourceRef(), dataAssociationElement.getTargetRef());
        ExpressionManager expressionManager = CommandContextUtil.getProcessEngineConfiguration().getExpressionManager();
        for (org.flowable.bpmn.model.Assignment assignmentElement : dataAssociationElement.getAssignments()) {
            if (!StringUtils.isNotEmpty((CharSequence)assignmentElement.getFrom()) || !StringUtils.isNotEmpty((CharSequence)assignmentElement.getTo())) continue;
            Expression from = expressionManager.createExpression(assignmentElement.getFrom());
            Expression to = expressionManager.createExpression(assignmentElement.getTo());
            Assignment assignment = new Assignment(from, to);
            dataAssociation.addAssignment(assignment);
        }
        return dataAssociation;
    }

    protected AbstractDataAssociation createDataOutputAssociation(DataAssociation dataAssociationElement) {
        if (StringUtils.isNotEmpty((CharSequence)dataAssociationElement.getSourceRef())) {
            return new MessageImplicitDataOutputAssociation(dataAssociationElement.getTargetRef(), dataAssociationElement.getSourceRef());
        }
        ExpressionManager expressionManager = CommandContextUtil.getProcessEngineConfiguration().getExpressionManager();
        Expression transformation = expressionManager.createExpression(dataAssociationElement.getTransformation());
        TransformationDataOutputAssociation dataOutputAssociation = new TransformationDataOutputAssociation(null, dataAssociationElement.getTargetRef(), transformation);
        return dataOutputAssociation;
    }
}

