/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.configurator;

import org.flowable.common.spring.CommonAutoDeploymentProperties;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.repository.DeploymentBuilder;
import org.flowable.spring.configurator.AbstractProcessAutoDeploymentStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class SingleResourceAutoDeploymentStrategy
extends AbstractProcessAutoDeploymentStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleResourceAutoDeploymentStrategy.class);
    public static final String DEPLOYMENT_MODE = "single-resource";

    public SingleResourceAutoDeploymentStrategy() {
    }

    public SingleResourceAutoDeploymentStrategy(CommonAutoDeploymentProperties deploymentProperties) {
        super(deploymentProperties);
    }

    protected String getDeploymentMode() {
        return DEPLOYMENT_MODE;
    }

    protected void deployResourcesInternal(String deploymentNameHint, Resource[] resources, ProcessEngine engine) {
        RepositoryService repositoryService = engine.getRepositoryService();
        for (Resource resource : resources) {
            String resourceName = this.determineResourceName(resource);
            DeploymentBuilder deploymentBuilder = repositoryService.createDeployment().enableDuplicateFiltering().name(resourceName);
            this.addResource(resource, resourceName, deploymentBuilder);
            try {
                deploymentBuilder.deploy();
            }
            catch (RuntimeException e) {
                if (this.isThrowExceptionOnDeploymentFailure()) {
                    throw e;
                }
                LOGGER.warn("Exception while autodeploying process definitions for resource {}. This exception can be ignored if the root cause indicates a unique constraint violation, which is typically caused by two (or more) servers booting up at the exact same time and deploying the same definitions. ", (Object)resource, (Object)e);
            }
        }
    }
}

