/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mapstruct.ap.internal.gem.BuilderGem;
import org.mapstruct.ap.internal.model.common.BuilderType;
import org.mapstruct.ap.internal.model.common.ImplementationType;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.util.AnnotationProcessingException;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Extractor;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.NativeTypes;
import org.mapstruct.ap.internal.util.RoundContext;
import org.mapstruct.ap.internal.util.Strings;
import org.mapstruct.ap.internal.util.accessor.Accessor;
import org.mapstruct.ap.spi.AstModifyingAnnotationProcessor;
import org.mapstruct.ap.spi.BuilderInfo;
import org.mapstruct.ap.spi.MoreThanOneBuilderCreationMethodException;
import org.mapstruct.ap.spi.TypeHierarchyErroneousException;

public class TypeFactory {
    private static final Extractor<BuilderInfo, String> BUILDER_INFO_CREATION_METHOD_EXTRACTOR = builderInfo -> {
        ExecutableElement builderCreationMethod = builderInfo.getBuilderCreationMethod();
        StringBuilder sb = new StringBuilder(builderCreationMethod.getSimpleName());
        sb.append('(');
        for (VariableElement variableElement : builderCreationMethod.getParameters()) {
            sb.append(variableElement);
        }
        sb.append(')');
        return sb.toString();
    };
    private final Elements elementUtils;
    private final Types typeUtils;
    private final FormattingMessager messager;
    private final RoundContext roundContext;
    private final TypeMirror iterableType;
    private final TypeMirror collectionType;
    private final TypeMirror mapType;
    private final TypeMirror streamType;
    private final Map<String, ImplementationType> implementationTypes = new HashMap<String, ImplementationType>();
    private final Map<String, String> toBeImportedTypes = new HashMap<String, String>();
    private final Map<String, String> notToBeImportedTypes;

    public TypeFactory(Elements elementUtils, Types typeUtils, FormattingMessager messager, RoundContext roundContext, Map<String, String> notToBeImportedTypes) {
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        this.messager = messager;
        this.roundContext = roundContext;
        this.notToBeImportedTypes = notToBeImportedTypes;
        this.iterableType = typeUtils.erasure(elementUtils.getTypeElement(Iterable.class.getCanonicalName()).asType());
        this.collectionType = typeUtils.erasure(elementUtils.getTypeElement(Collection.class.getCanonicalName()).asType());
        this.mapType = typeUtils.erasure(elementUtils.getTypeElement(Map.class.getCanonicalName()).asType());
        TypeElement streamTypeElement = elementUtils.getTypeElement("java.util.stream.Stream");
        this.streamType = streamTypeElement == null ? null : typeUtils.erasure(streamTypeElement.asType());
        this.implementationTypes.put(Iterable.class.getName(), ImplementationType.withInitialCapacity(this.getType(ArrayList.class)));
        this.implementationTypes.put(Collection.class.getName(), ImplementationType.withInitialCapacity(this.getType(ArrayList.class)));
        this.implementationTypes.put(List.class.getName(), ImplementationType.withInitialCapacity(this.getType(ArrayList.class)));
        this.implementationTypes.put(Set.class.getName(), ImplementationType.withLoadFactorAdjustment(this.getType(HashSet.class)));
        this.implementationTypes.put(SortedSet.class.getName(), ImplementationType.withDefaultConstructor(this.getType(TreeSet.class)));
        this.implementationTypes.put(NavigableSet.class.getName(), ImplementationType.withDefaultConstructor(this.getType(TreeSet.class)));
        this.implementationTypes.put(Map.class.getName(), ImplementationType.withLoadFactorAdjustment(this.getType(HashMap.class)));
        this.implementationTypes.put(SortedMap.class.getName(), ImplementationType.withDefaultConstructor(this.getType(TreeMap.class)));
        this.implementationTypes.put(NavigableMap.class.getName(), ImplementationType.withDefaultConstructor(this.getType(TreeMap.class)));
        this.implementationTypes.put(ConcurrentMap.class.getName(), ImplementationType.withLoadFactorAdjustment(this.getType(ConcurrentHashMap.class)));
        this.implementationTypes.put(ConcurrentNavigableMap.class.getName(), ImplementationType.withDefaultConstructor(this.getType(ConcurrentSkipListMap.class)));
    }

    public Type getTypeForLiteral(Class<?> type) {
        return type.isPrimitive() ? this.getType(this.getPrimitiveType(type), true) : this.getType(type.getCanonicalName(), true);
    }

    public Type getType(Class<?> type) {
        return type.isPrimitive() ? this.getType(this.getPrimitiveType(type)) : this.getType(type.getCanonicalName());
    }

    public Type getType(String canonicalName) {
        return this.getType(canonicalName, false);
    }

    private Type getType(String canonicalName, boolean isLiteral) {
        TypeElement typeElement = this.elementUtils.getTypeElement(canonicalName);
        if (typeElement == null) {
            throw new AnnotationProcessingException("Couldn't find type " + canonicalName + ". Are you missing a dependency on your classpath?");
        }
        return this.getType(typeElement, isLiteral);
    }

    public boolean isTypeAvailable(String canonicalName) {
        return null != this.elementUtils.getTypeElement(canonicalName);
    }

    public Type getWrappedType(Type type) {
        Type result = type;
        if (type.isPrimitive()) {
            PrimitiveType typeMirror = (PrimitiveType)type.getTypeMirror();
            result = this.getType(this.typeUtils.boxedClass(typeMirror));
        }
        return result;
    }

    public Type getType(TypeElement typeElement) {
        return this.getType(typeElement.asType(), false);
    }

    private Type getType(TypeElement typeElement, boolean isLiteral) {
        return this.getType(typeElement.asType(), isLiteral);
    }

    public Type getType(TypeMirror mirror) {
        return this.getType(mirror, false);
    }

    private Type getType(TypeMirror mirror, boolean isLiteral) {
        Type componentType;
        String qualifiedName;
        String packageName;
        TypeElement typeElement;
        String name;
        boolean isInterface;
        boolean isEnumType;
        if (!this.canBeProcessed(mirror)) {
            throw new TypeHierarchyErroneousException(mirror);
        }
        ImplementationType implementationType = this.getImplementationType(mirror);
        boolean isIterableType = this.typeUtils.isSubtype(mirror, this.iterableType);
        boolean isCollectionType = this.typeUtils.isSubtype(mirror, this.collectionType);
        boolean isMapType = this.typeUtils.isSubtype(mirror, this.mapType);
        boolean isStreamType = this.streamType != null && this.typeUtils.isSubtype(mirror, this.streamType);
        Boolean toBeImported = null;
        if (mirror.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)mirror;
            isEnumType = declaredType.asElement().getKind() == ElementKind.ENUM;
            isInterface = declaredType.asElement().getKind() == ElementKind.INTERFACE;
            name = declaredType.asElement().getSimpleName().toString();
            typeElement = (TypeElement)declaredType.asElement();
            if (typeElement != null) {
                packageName = this.elementUtils.getPackageOf(typeElement).getQualifiedName().toString();
                qualifiedName = typeElement.getQualifiedName().toString();
            } else {
                packageName = null;
                qualifiedName = name;
            }
            componentType = null;
        } else if (mirror.getKind() == TypeKind.ARRAY) {
            TypeMirror componentTypeMirror = this.getComponentType(mirror);
            StringBuilder builder = new StringBuilder("[]");
            while (componentTypeMirror.getKind() == TypeKind.ARRAY) {
                componentTypeMirror = this.getComponentType(componentTypeMirror);
                builder.append("[]");
            }
            if (componentTypeMirror.getKind() == TypeKind.DECLARED) {
                DeclaredType declaredType = (DeclaredType)componentTypeMirror;
                TypeElement componentTypeElement = (TypeElement)declaredType.asElement();
                String arraySuffix = builder.toString();
                name = componentTypeElement.getSimpleName().toString() + arraySuffix;
                packageName = this.elementUtils.getPackageOf(componentTypeElement).getQualifiedName().toString();
                qualifiedName = componentTypeElement.getQualifiedName().toString() + arraySuffix;
            } else if (componentTypeMirror.getKind().isPrimitive()) {
                name = NativeTypes.getName(componentTypeMirror.getKind()) + builder.toString();
                packageName = null;
                qualifiedName = name;
                toBeImported = false;
            } else {
                name = mirror.toString();
                packageName = null;
                qualifiedName = name;
                toBeImported = false;
            }
            isEnumType = false;
            isInterface = false;
            typeElement = null;
            componentType = this.getType(this.getComponentType(mirror));
        } else {
            isEnumType = false;
            isInterface = false;
            name = mirror.toString();
            packageName = null;
            qualifiedName = name;
            typeElement = null;
            componentType = null;
            toBeImported = false;
        }
        return new Type(this.typeUtils, this.elementUtils, this, this.roundContext.getAnnotationProcessorContext().getAccessorNaming(), mirror, typeElement, this.getTypeParameters(mirror, false), implementationType, componentType, packageName, name, qualifiedName, isInterface, isEnumType, isIterableType, isCollectionType, isMapType, isStreamType, this.toBeImportedTypes, this.notToBeImportedTypes, toBeImported, isLiteral);
    }

    public Type classTypeOf(Type type) {
        if (type.isVoid()) {
            return null;
        }
        TypeMirror typeToUse = type.isPrimitive() ? this.typeUtils.boxedClass((PrimitiveType)type.getTypeMirror()).asType() : type.getTypeMirror();
        return this.getType(this.typeUtils.getDeclaredType(this.elementUtils.getTypeElement("java.lang.Class"), typeToUse));
    }

    public ExecutableType getMethodType(DeclaredType includingType, ExecutableElement method) {
        TypeMirror asMemberOf = this.typeUtils.asMemberOf(includingType, method);
        return (ExecutableType)asMemberOf;
    }

    public TypeMirror getMethodType(DeclaredType includingType, Element method) {
        return this.typeUtils.asMemberOf(includingType, method);
    }

    public Parameter getSingleParameter(DeclaredType includingType, Accessor method) {
        if (method.getAccessorType().isFieldAssignment()) {
            return null;
        }
        ExecutableElement executable = (ExecutableElement)method.getElement();
        List<? extends VariableElement> parameters = executable.getParameters();
        if (parameters.size() != 1) {
            return null;
        }
        return Collections.first(this.getParameters(includingType, method));
    }

    public List<Parameter> getParameters(DeclaredType includingType, Accessor accessor) {
        ExecutableElement method = (ExecutableElement)accessor.getElement();
        return this.getParameters(includingType, method);
    }

    public List<Parameter> getParameters(DeclaredType includingType, ExecutableElement method) {
        ExecutableType methodType = this.getMethodType(includingType, method);
        if (method == null || methodType.getKind() != TypeKind.EXECUTABLE) {
            return new ArrayList<Parameter>();
        }
        return this.getParameters(methodType, method);
    }

    public List<Parameter> getParameters(ExecutableType methodType, ExecutableElement method) {
        List<? extends TypeMirror> parameterTypes = methodType.getParameterTypes();
        List<? extends VariableElement> parameters = method.getParameters();
        ArrayList<Parameter> result = new ArrayList<Parameter>(parameters.size());
        Iterator<? extends VariableElement> varIt = parameters.iterator();
        Iterator<? extends TypeMirror> typesIt = parameterTypes.iterator();
        while (varIt.hasNext()) {
            VariableElement parameter = varIt.next();
            TypeMirror parameterType = typesIt.next();
            Type type = this.getType(parameterType);
            boolean isVarArgs = !varIt.hasNext() && method.isVarArgs();
            result.add(Parameter.forElementAndType(parameter, type, isVarArgs));
        }
        return result;
    }

    public Type getReturnType(DeclaredType includingType, Accessor accessor) {
        TypeMirror accessorType = this.getMethodType(includingType, accessor.getElement());
        Type type = this.isExecutableType(accessorType) ? this.getType(((ExecutableType)accessorType).getReturnType()) : this.getType(accessorType);
        return type;
    }

    private boolean isExecutableType(TypeMirror accessorType) {
        return accessorType.getKind() == TypeKind.EXECUTABLE;
    }

    public Type getReturnType(ExecutableType method) {
        return this.getType(method.getReturnType());
    }

    public List<Type> getThrownTypes(ExecutableType method) {
        return this.extractTypes(method.getThrownTypes());
    }

    public List<Type> getThrownTypes(Accessor accessor) {
        if (accessor.getAccessorType().isFieldAssignment()) {
            return new ArrayList<Type>();
        }
        return this.extractTypes(((ExecutableElement)accessor.getElement()).getThrownTypes());
    }

    private List<Type> extractTypes(List<? extends TypeMirror> typeMirrors) {
        HashSet<Type> types = new HashSet<Type>(typeMirrors.size());
        for (TypeMirror typeMirror : typeMirrors) {
            types.add(this.getType(typeMirror));
        }
        return new ArrayList<Type>(types);
    }

    private List<Type> getTypeParameters(TypeMirror mirror, boolean isImplementationType) {
        if (mirror.getKind() != TypeKind.DECLARED) {
            return java.util.Collections.emptyList();
        }
        DeclaredType declaredType = (DeclaredType)mirror;
        ArrayList<Type> typeParameters = new ArrayList<Type>(declaredType.getTypeArguments().size());
        for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
            if (isImplementationType) {
                typeParameters.add(this.getType(typeMirror).getTypeBound());
                continue;
            }
            typeParameters.add(this.getType(typeMirror));
        }
        return typeParameters;
    }

    private TypeMirror getPrimitiveType(Class<?> primitiveType) {
        return primitiveType == Byte.TYPE ? this.typeUtils.getPrimitiveType(TypeKind.BYTE) : (primitiveType == Short.TYPE ? this.typeUtils.getPrimitiveType(TypeKind.SHORT) : (primitiveType == Integer.TYPE ? this.typeUtils.getPrimitiveType(TypeKind.INT) : (primitiveType == Long.TYPE ? this.typeUtils.getPrimitiveType(TypeKind.LONG) : (primitiveType == Float.TYPE ? this.typeUtils.getPrimitiveType(TypeKind.FLOAT) : (primitiveType == Double.TYPE ? this.typeUtils.getPrimitiveType(TypeKind.DOUBLE) : (primitiveType == Boolean.TYPE ? this.typeUtils.getPrimitiveType(TypeKind.BOOLEAN) : (primitiveType == Character.TYPE ? this.typeUtils.getPrimitiveType(TypeKind.CHAR) : this.typeUtils.getPrimitiveType(TypeKind.VOID))))))));
    }

    private ImplementationType getImplementationType(TypeMirror mirror) {
        if (mirror.getKind() != TypeKind.DECLARED) {
            return null;
        }
        DeclaredType declaredType = (DeclaredType)mirror;
        ImplementationType implementation = this.implementationTypes.get(((TypeElement)declaredType.asElement()).getQualifiedName().toString());
        if (implementation != null) {
            Type implementationType = implementation.getType();
            Type replacement = new Type(this.typeUtils, this.elementUtils, this, this.roundContext.getAnnotationProcessorContext().getAccessorNaming(), this.typeUtils.getDeclaredType(implementationType.getTypeElement(), declaredType.getTypeArguments().toArray(new TypeMirror[0])), implementationType.getTypeElement(), this.getTypeParameters(mirror, true), null, null, implementationType.getPackageName(), implementationType.getName(), implementationType.getFullyQualifiedName(), implementationType.isInterface(), implementationType.isEnumType(), implementationType.isIterableType(), implementationType.isCollectionType(), implementationType.isMapType(), implementationType.isStreamType(), this.toBeImportedTypes, this.notToBeImportedTypes, null, implementationType.isLiteral());
            return implementation.createNew(replacement);
        }
        return null;
    }

    private BuilderInfo findBuilder(TypeMirror type, BuilderGem builderGem, boolean report) {
        if (builderGem != null && builderGem.disableBuilder().get().booleanValue()) {
            return null;
        }
        try {
            return this.roundContext.getAnnotationProcessorContext().getBuilderProvider().findBuilderInfo(type);
        }
        catch (MoreThanOneBuilderCreationMethodException ex) {
            if (report) {
                this.messager.printMessage(this.typeUtils.asElement(type), Message.BUILDER_MORE_THAN_ONE_BUILDER_CREATION_METHOD, type, Strings.join(ex.getBuilderInfo(), ", ", BUILDER_INFO_CREATION_METHOD_EXTRACTOR));
            }
            return null;
        }
    }

    private TypeMirror getComponentType(TypeMirror mirror) {
        if (mirror.getKind() != TypeKind.ARRAY) {
            return null;
        }
        ArrayType arrayType = (ArrayType)mirror;
        return arrayType.getComponentType();
    }

    public Type createVoidType() {
        return this.getType(this.typeUtils.getNoType(TypeKind.VOID));
    }

    public TypeMirror getTypeBound(TypeMirror typeMirror) {
        TypeVariable typeVariableType;
        if (typeMirror.getKind() == TypeKind.WILDCARD) {
            WildcardType wildCardType = (WildcardType)typeMirror;
            if (wildCardType.getExtendsBound() != null) {
                return wildCardType.getExtendsBound();
            }
            if (wildCardType.getSuperBound() != null) {
                return wildCardType.getSuperBound();
            }
            String wildCardName = wildCardType.toString();
            if ("?".equals(wildCardName)) {
                return this.elementUtils.getTypeElement(Object.class.getCanonicalName()).asType();
            }
        } else if (typeMirror.getKind() == TypeKind.TYPEVAR && (typeVariableType = (TypeVariable)typeMirror).getUpperBound() != null) {
            return typeVariableType.getUpperBound();
        }
        return typeMirror;
    }

    private boolean canBeProcessed(TypeMirror type) {
        if (type.getKind() == TypeKind.ERROR) {
            return false;
        }
        if (type.getKind() != TypeKind.DECLARED) {
            return true;
        }
        if (this.roundContext.isReadyForProcessing(type)) {
            return true;
        }
        List<AstModifyingAnnotationProcessor> astModifyingAnnotationProcessors = this.roundContext.getAnnotationProcessorContext().getAstModifyingAnnotationProcessors();
        for (AstModifyingAnnotationProcessor processor : astModifyingAnnotationProcessors) {
            if (processor.isTypeComplete(type)) continue;
            return false;
        }
        this.roundContext.addTypeReadyForProcessing(type);
        return true;
    }

    public BuilderType builderTypeFor(Type type, BuilderGem builder) {
        if (type != null) {
            BuilderInfo builderInfo = this.findBuilder(type.getTypeMirror(), builder, true);
            return BuilderType.create(builderInfo, type, this, this.typeUtils);
        }
        return null;
    }

    public Type effectiveResultTypeFor(Type type, BuilderGem builder) {
        if (type != null) {
            BuilderInfo builderInfo = this.findBuilder(type.getTypeMirror(), builder, false);
            BuilderType builderType = BuilderType.create(builderInfo, type, this, this.typeUtils);
            return builderType != null ? builderType.getBuilder() : type;
        }
        return type;
    }
}

