/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.util;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.mapstruct.ap.internal.util.workarounds.SpecificCompilerWorkarounds;
import org.mapstruct.ap.spi.TypeHierarchyErroneousException;

public class Fields {
    private Fields() {
    }

    public static boolean isFieldAccessor(VariableElement method) {
        return Fields.isPublic(method) && Fields.isNotStatic(method);
    }

    static boolean isPublic(VariableElement method) {
        return method.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    private static boolean isNotStatic(VariableElement method) {
        return !method.getModifiers().contains((Object)Modifier.STATIC);
    }

    public static List<VariableElement> getAllEnclosedFields(Elements elementUtils, TypeElement element) {
        ArrayList<VariableElement> enclosedElements = new ArrayList<VariableElement>();
        element = SpecificCompilerWorkarounds.replaceTypeElementIfNecessary(elementUtils, element);
        Fields.addEnclosedElementsInHierarchy(elementUtils, enclosedElements, element, element);
        return enclosedElements;
    }

    private static void addEnclosedElementsInHierarchy(Elements elementUtils, List<VariableElement> alreadyAdded, TypeElement element, TypeElement parentType) {
        if (element != parentType) {
            element = SpecificCompilerWorkarounds.replaceTypeElementIfNecessary(elementUtils, element);
        }
        if (element.asType().getKind() == TypeKind.ERROR) {
            throw new TypeHierarchyErroneousException(element);
        }
        Fields.addFields(alreadyAdded, ElementFilter.fieldsIn(element.getEnclosedElements()));
        if (Fields.hasNonObjectSuperclass(element)) {
            Fields.addEnclosedElementsInHierarchy(elementUtils, alreadyAdded, Fields.asTypeElement(element.getSuperclass()), parentType);
        }
    }

    private static void addFields(List<VariableElement> alreadyCollected, List<VariableElement> variablesToAdd) {
        ArrayList<VariableElement> safeToAdd = new ArrayList<VariableElement>(variablesToAdd.size());
        safeToAdd.addAll(variablesToAdd);
        alreadyCollected.addAll(0, safeToAdd);
    }

    private static TypeElement asTypeElement(TypeMirror mirror) {
        return (TypeElement)((DeclaredType)mirror).asElement();
    }

    private static boolean hasNonObjectSuperclass(TypeElement element) {
        if (element.getSuperclass().getKind() == TypeKind.ERROR) {
            throw new TypeHierarchyErroneousException(element);
        }
        return element.getSuperclass().getKind() == TypeKind.DECLARED && !Fields.asTypeElement(element.getSuperclass()).getQualifiedName().toString().equals("java.lang.Object");
    }
}

