/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.redisson.api.StreamInfo;
import org.redisson.api.StreamMessageId;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.StreamIdConvertor;
import org.redisson.client.protocol.decoder.ListMultiDecoder2;
import org.redisson.client.protocol.decoder.MapEntriesDecoder;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.client.protocol.decoder.ObjectDecoder;
import org.redisson.client.protocol.decoder.ObjectListReplayDecoder;
import org.redisson.client.protocol.decoder.ObjectMapDecoder;
import org.redisson.client.protocol.decoder.StreamIdDecoder;
import org.redisson.client.protocol.decoder.StreamObjectMapReplayDecoder;
import org.redisson.spring.data.connection.RedissonConnection;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.RedisStreamCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.stream.ByteRecord;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.PendingMessage;
import org.springframework.data.redis.connection.stream.PendingMessages;
import org.springframework.data.redis.connection.stream.PendingMessagesSummary;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamInfo;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.util.Assert;

public class RedissonStreamCommands
implements RedisStreamCommands {
    private final RedissonConnection connection;
    private static final RedisStrictCommand<RecordId> XCLAIM_JUSTID = new RedisStrictCommand("XCLAIM", obj -> RecordId.of((String)obj.toString()));
    private static final RedisCommand<StreamInfo<Object, Object>> XINFO_STREAM = new RedisCommand("XINFO", "STREAM", (MultiDecoder)new ListMultiDecoder2(new MultiDecoder[]{new XInfoStreamReplayDecoder(), new ObjectDecoder(StringCodec.INSTANCE.getValueDecoder()), new ObjectMapDecoder(false)}));
    RedisCommand<StreamInfo.XInfoGroups> XINFO_GROUPS = new RedisCommand("XINFO", "GROUPS", (MultiDecoder)new ListMultiDecoder2(new MultiDecoder[]{new XInfoGroupsReplayDecoder(), new ObjectListReplayDecoder(), new ObjectListReplayDecoder()}));
    private static final RedisStrictCommand<RecordId> XADD = new RedisStrictCommand("XADD", obj -> RecordId.of((String)obj.toString()));
    private static final RedisStrictCommand<String> XGROUP_STRING = new RedisStrictCommand("XGROUP");
    private static final RedisStrictCommand<Boolean> XGROUP_BOOLEAN = new RedisStrictCommand("XGROUP", obj -> (Long)obj > 0L);
    private static final RedisCommand<List<ByteRecord>> XREAD = new RedisCommand("XREAD", (MultiDecoder)new ListMultiDecoder2(new MultiDecoder[]{new ByteRecordReplayDecoder2(), new ObjectDecoder(StringCodec.INSTANCE.getValueDecoder()), new ObjectDecoder((Decoder)new StreamIdDecoder()), new ObjectDecoder((Decoder)new StreamIdDecoder()), new MapEntriesDecoder((MultiDecoder)new StreamObjectMapReplayDecoder())}));
    private static final RedisCommand<List<ByteRecord>> XREAD_BLOCKING = new RedisCommand("XREAD", XREAD.getReplayMultiDecoder());
    private static final RedisCommand<List<ByteRecord>> XREADGROUP = new RedisCommand("XREADGROUP", XREAD.getReplayMultiDecoder());
    private static final RedisCommand<List<ByteRecord>> XREADGROUP_BLOCKING = new RedisCommand("XREADGROUP", XREADGROUP.getReplayMultiDecoder());

    public RedissonStreamCommands(RedissonConnection connection) {
        this.connection = connection;
    }

    private static List<String> toStringList(RecordId ... recordIds) {
        if (recordIds.length == 1) {
            return Arrays.asList(recordIds[0].getValue());
        }
        return Arrays.stream(recordIds).map(RecordId::getValue).collect(Collectors.toList());
    }

    public RecordId xAdd(MapRecord<byte[], byte[], byte[]> record) {
        return this.xAdd(record, RedisStreamCommands.XAddOptions.none());
    }

    public List<RecordId> xClaimJustId(byte[] key, String group, String newOwner, RedisStreamCommands.XClaimOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)group, (String)"Group name must not be null!");
        Assert.notNull((Object)newOwner, (String)"NewOwner must not be null!");
        Assert.notEmpty((Collection)options.getIds(), (String)"Ids collection must not be empty!");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.add(group);
        params.add(newOwner);
        params.add(Objects.requireNonNull(options.getIdleTime()).toMillis());
        params.addAll(Arrays.asList(options.getIdsAsStringArray()));
        params.add("JUSTID");
        return (List)this.connection.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)XCLAIM_JUSTID, params.toArray());
    }

    public List<ByteRecord> xClaim(byte[] key, String group, String newOwner, RedisStreamCommands.XClaimOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)group, (String)"Group name must not be null!");
        Assert.notNull((Object)newOwner, (String)"NewOwner must not be null!");
        Assert.notEmpty((Collection)options.getIds(), (String)"Ids collection must not be empty!");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.add(group);
        params.add(newOwner);
        params.add(Objects.requireNonNull(options.getIdleTime()).toMillis());
        params.addAll(Arrays.asList(options.getIdsAsStringArray()));
        return (List)this.connection.write(key, (Codec)ByteArrayCodec.INSTANCE, new RedisCommand("XCLAIM", (MultiDecoder)new ListMultiDecoder2(new MultiDecoder[]{new ByteRecordReplayDecoder(key), new ObjectDecoder((Decoder)new StreamIdDecoder()), new MapEntriesDecoder((MultiDecoder)new StreamObjectMapReplayDecoder())})), params.toArray());
    }

    public String xGroupCreate(byte[] key, String groupName, ReadOffset readOffset, boolean mkStream) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)groupName, (String)"GroupName must not be null!");
        Assert.notNull((Object)readOffset, (String)"ReadOffset must not be null!");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add("CREATE");
        params.add(key);
        params.add(groupName);
        params.add(readOffset.getOffset());
        if (mkStream) {
            params.add("MKSTREAM");
        }
        return (String)this.connection.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)XGROUP_STRING, params.toArray());
    }

    public StreamInfo.XInfoStream xInfo(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (StreamInfo.XInfoStream)this.connection.write(key, (Codec)ByteArrayCodec.INSTANCE, XINFO_STREAM, new Object[]{key});
    }

    public StreamInfo.XInfoGroups xInfoGroups(byte[] key) {
        return (StreamInfo.XInfoGroups)this.connection.write(key, (Codec)StringCodec.INSTANCE, this.XINFO_GROUPS, new Object[]{key});
    }

    public StreamInfo.XInfoConsumers xInfoConsumers(byte[] key, String groupName) {
        return (StreamInfo.XInfoConsumers)this.connection.write(key, (Codec)StringCodec.INSTANCE, new RedisCommand("XINFO", "CONSUMERS", (MultiDecoder)new ListMultiDecoder2(new MultiDecoder[]{new XInfoConsumersReplayDecoder(groupName), new ObjectListReplayDecoder(), new ObjectListReplayDecoder()})), key, groupName);
    }

    public PendingMessagesSummary xPending(byte[] key, String groupName) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)groupName, (String)"Group name must not be null!");
        return (PendingMessagesSummary)this.connection.write(key, (Codec)StringCodec.INSTANCE, new RedisCommand("XPENDING", (MultiDecoder)new ListMultiDecoder2(new MultiDecoder[]{new PendingMessagesSummaryReplayDecoder(groupName), new ObjectListReplayDecoder(), new ObjectListReplayDecoder()})), key, groupName);
    }

    public PendingMessages xPending(byte[] key, String groupName, RedisStreamCommands.XPendingOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)groupName, (String)"Group name must not be null!");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.add(groupName);
        params.add(options.getRange().getLowerBound().getValue().orElse("-"));
        params.add(options.getRange().getUpperBound().getValue().orElse("+"));
        if (options.getCount() != null) {
            params.add(options.getCount());
        } else {
            params.add(10);
        }
        if (options.getConsumerName() != null) {
            params.add(options.getConsumerName());
        }
        return (PendingMessages)this.connection.write(key, (Codec)StringCodec.INSTANCE, new RedisCommand("XPENDING", (MultiDecoder)new ListMultiDecoder2(new MultiDecoder[]{new PendingMessagesReplayDecoder(groupName, options.getRange()), new PendingMessageReplayDecoder(groupName)})), params.toArray());
    }

    public Long xAck(byte[] key, String group, RecordId ... recordIds) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)group, (String)"Group must not be null!");
        Assert.notNull((Object)recordIds, (String)"recordIds must not be null!");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.add(group);
        params.addAll(RedissonStreamCommands.toStringList(recordIds));
        return (Long)this.connection.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.XACK, params.toArray());
    }

    public RecordId xAdd(MapRecord<byte[], byte[], byte[]> record, RedisStreamCommands.XAddOptions options) {
        Assert.notNull(record, (String)"record must not be null!");
        LinkedList<Object> params = new LinkedList<Object>();
        params.add(record.getStream());
        if (options.getMaxlen() != null) {
            params.add("MAXLEN");
            params.add(options.getMaxlen());
        }
        if (!record.getId().shouldBeAutoGenerated()) {
            params.add(record.getId().getValue());
        } else {
            params.add("*");
        }
        ((Map)record.getValue()).forEach((key, value) -> {
            params.add(key);
            params.add(value);
        });
        return (RecordId)this.connection.write((byte[])record.getStream(), (Codec)StringCodec.INSTANCE, (RedisCommand<?>)XADD, params.toArray());
    }

    public Long xDel(byte[] key, RecordId ... recordIds) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)recordIds, (String)"recordIds must not be null!");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.addAll(RedissonStreamCommands.toStringList(recordIds));
        return (Long)this.connection.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.XDEL, params.toArray());
    }

    public String xGroupCreate(byte[] key, String groupName, ReadOffset readOffset) {
        return this.xGroupCreate(key, groupName, readOffset, false);
    }

    public Boolean xGroupDelConsumer(byte[] key, Consumer consumer) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)consumer, (String)"Consumer must not be null!");
        Assert.notNull((Object)consumer.getName(), (String)"Consumer name must not be null!");
        Assert.notNull((Object)consumer.getGroup(), (String)"Consumer group must not be null!");
        return (Boolean)this.connection.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)XGROUP_BOOLEAN, "DELCONSUMER", key, consumer.getGroup(), consumer.getName());
    }

    public Boolean xGroupDestroy(byte[] key, String groupName) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)groupName, (String)"GroupName must not be null!");
        return (Boolean)this.connection.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)XGROUP_BOOLEAN, "DESTROY", key, groupName);
    }

    public Long xLen(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (Long)this.connection.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.XLEN, new Object[]{key});
    }

    private List<ByteRecord> range(RedisCommand<?> rangeCommand, byte[] key, Range<String> range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        LinkedList<Object> params = new LinkedList<Object>();
        params.add(key);
        if (rangeCommand.getName().equals(RedisCommands.XRANGE.getName())) {
            params.add(range.getLowerBound().getValue().orElse("-"));
            params.add(range.getUpperBound().getValue().orElse("+"));
        } else {
            params.add(range.getUpperBound().getValue().orElse("+"));
            params.add(range.getLowerBound().getValue().orElse("-"));
        }
        if (limit.getCount() > 0) {
            params.add("COUNT");
            params.add(limit.getCount());
        }
        return (List)this.connection.write(key, (Codec)ByteArrayCodec.INSTANCE, rangeCommand, params.toArray());
    }

    public List<ByteRecord> xRange(byte[] key, Range<String> range, RedisZSetCommands.Limit limit) {
        return this.range(new RedisCommand("XRANGE", (MultiDecoder)new ListMultiDecoder2(new MultiDecoder[]{new ByteRecordReplayDecoder(key), new ObjectDecoder((Decoder)new StreamIdDecoder()), new MapEntriesDecoder((MultiDecoder)new StreamObjectMapReplayDecoder())})), key, range, limit);
    }

    public List<ByteRecord> xRead(StreamReadOptions readOptions, StreamOffset<byte[]> ... streams) {
        Assert.notNull((Object)readOptions, (String)"ReadOptions must not be null!");
        Assert.notNull(streams, (String)"StreamOffsets must not be null!");
        ArrayList<Object> params = new ArrayList<Object>();
        if (readOptions.getCount() != null && readOptions.getCount() > 0L) {
            params.add("COUNT");
            params.add(readOptions.getCount());
        }
        if (readOptions.getBlock() != null && readOptions.getBlock() > 0L) {
            params.add("BLOCK");
            params.add(readOptions.getBlock());
        }
        params.add("STREAMS");
        for (StreamOffset<byte[]> streamOffset : streams) {
            params.add(streamOffset.getKey());
        }
        for (StreamOffset<byte[]> streamOffset : streams) {
            params.add(streamOffset.getOffset().getOffset());
        }
        if (readOptions.getBlock() != null && readOptions.getBlock() > 0L) {
            return (List)this.connection.read((byte[])streams[0].getKey(), (Codec)ByteArrayCodec.INSTANCE, XREAD_BLOCKING, params.toArray());
        }
        return (List)this.connection.read((byte[])streams[0].getKey(), (Codec)ByteArrayCodec.INSTANCE, XREAD, params.toArray());
    }

    public List<ByteRecord> xReadGroup(Consumer consumer, StreamReadOptions readOptions, StreamOffset<byte[]> ... streams) {
        Assert.notNull((Object)readOptions, (String)"Consumer must not be null!");
        Assert.notNull((Object)readOptions, (String)"ReadOptions must not be null!");
        Assert.notNull(streams, (String)"StreamOffsets must not be null!");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add("GROUP");
        params.add(consumer.getGroup());
        params.add(consumer.getName());
        if (readOptions.getCount() != null && readOptions.getCount() > 0L) {
            params.add("COUNT");
            params.add(readOptions.getCount());
        }
        if (readOptions.getBlock() != null && readOptions.getBlock() > 0L) {
            params.add("BLOCK");
            params.add(readOptions.getBlock());
        }
        if (readOptions.isNoack()) {
            params.add("NOACK");
        }
        params.add("STREAMS");
        for (StreamOffset<byte[]> streamOffset : streams) {
            params.add(streamOffset.getKey());
        }
        for (StreamOffset<byte[]> streamOffset : streams) {
            params.add(streamOffset.getOffset().getOffset());
        }
        if (readOptions.getBlock() != null && readOptions.getBlock() > 0L) {
            return (List)this.connection.write((byte[])streams[0].getKey(), (Codec)ByteArrayCodec.INSTANCE, XREADGROUP_BLOCKING, params.toArray());
        }
        return (List)this.connection.write((byte[])streams[0].getKey(), (Codec)ByteArrayCodec.INSTANCE, XREADGROUP, params.toArray());
    }

    public List<ByteRecord> xRevRange(byte[] key, Range<String> range, RedisZSetCommands.Limit limit) {
        return this.range(new RedisCommand("XREVRANGE", (MultiDecoder)new ListMultiDecoder2(new MultiDecoder[]{new ByteRecordReplayDecoder(key), new ObjectDecoder((Decoder)new StreamIdDecoder()), new MapEntriesDecoder((MultiDecoder)new StreamObjectMapReplayDecoder())})), key, range, limit);
    }

    public Long xTrim(byte[] key, long count) {
        return this.xTrim(key, count, false);
    }

    public Long xTrim(byte[] key, long count, boolean approximateTrimming) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)count, (String)"Count must not be null!");
        ArrayList<Object> params = new ArrayList<Object>(4);
        params.add(key);
        params.add("MAXLEN");
        if (approximateTrimming) {
            params.add("~");
        }
        params.add(count);
        return (Long)this.connection.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.XTRIM, params.toArray());
    }

    static {
        RedisCommands.BLOCKING_COMMANDS.add(XREAD_BLOCKING);
        RedisCommands.BLOCKING_COMMANDS.add(XREADGROUP_BLOCKING);
    }

    private static class ByteRecordReplayDecoder2
    implements MultiDecoder<List<ByteRecord>> {
        private ByteRecordReplayDecoder2() {
        }

        public List<ByteRecord> decode(List<Object> parts, State state) {
            List<Object> list = parts;
            ArrayList<ByteRecord> result = new ArrayList<ByteRecord>(parts.size() / 2);
            for (List list2 : list) {
                List streamEntries = (List)list2.get(1);
                if (streamEntries.isEmpty()) continue;
                String name = (String)list2.get(0);
                for (List se : streamEntries) {
                    ByteRecord record = StreamRecords.newRecord().in((Object)name.getBytes()).withId(RecordId.of((String)se.get(0).toString())).ofBytes((Map)se.get(1));
                    result.add(record);
                }
            }
            return result;
        }
    }

    private static class ByteRecordReplayDecoder
    implements MultiDecoder<List<ByteRecord>> {
        private final byte[] key;

        ByteRecordReplayDecoder(byte[] key) {
            this.key = key;
        }

        public List<ByteRecord> decode(List<Object> parts, State state) {
            List<Object> list = parts;
            ArrayList<ByteRecord> result = new ArrayList<ByteRecord>(parts.size() / 2);
            for (List list2 : list) {
                ByteRecord record = StreamRecords.newRecord().in((Object)this.key).withId(RecordId.of((String)list2.get(0).toString())).ofBytes((Map)list2.get(1));
                result.add(record);
            }
            return result;
        }
    }

    private static class PendingMessagesReplayDecoder
    implements MultiDecoder<PendingMessages> {
        private final String groupName;
        private final Range<?> range;

        public PendingMessagesReplayDecoder(String groupName, Range<?> range) {
            this.groupName = groupName;
            this.range = range;
        }

        public PendingMessages decode(List<Object> parts, State state) {
            List<Object> pendingMessages = parts;
            return new PendingMessages(this.groupName, this.range, pendingMessages);
        }
    }

    private static class PendingMessageReplayDecoder
    implements MultiDecoder<PendingMessage> {
        private String groupName;

        public PendingMessageReplayDecoder(String groupName) {
            this.groupName = groupName;
        }

        public PendingMessage decode(List<Object> parts, State state) {
            PendingMessage pm = new PendingMessage(RecordId.of((String)parts.get(0).toString()), Consumer.from((String)this.groupName, (String)parts.get(1).toString()), Duration.of(Long.valueOf(parts.get(2).toString()), ChronoUnit.MILLIS), Long.valueOf(parts.get(3).toString()).longValue());
            return pm;
        }
    }

    private static class PendingMessagesSummaryReplayDecoder
    implements MultiDecoder<PendingMessagesSummary> {
        private final String groupName;

        public PendingMessagesSummaryReplayDecoder(String groupName) {
            this.groupName = groupName;
        }

        public PendingMessagesSummary decode(List<Object> parts, State state) {
            if (parts.isEmpty()) {
                return null;
            }
            List customerParts = (List)parts.get(3);
            if (customerParts.isEmpty()) {
                return new PendingMessagesSummary(this.groupName, 0L, Range.unbounded(), Collections.emptyMap());
            }
            Map map = customerParts.stream().collect(Collectors.toMap(e -> (String)e.get(0), e -> Long.valueOf((String)e.get(1)), (u, v) -> {
                throw new IllegalStateException("Duplicate key: " + u);
            }, LinkedHashMap::new));
            Range range = Range.open((Comparable)((Object)parts.get(1).toString()), (Comparable)((Object)parts.get(2).toString()));
            return new PendingMessagesSummary(this.groupName, ((Long)parts.get(0)).longValue(), range, map);
        }
    }

    private static class XInfoConsumersReplayDecoder
    implements MultiDecoder<StreamInfo.XInfoConsumers> {
        private final String groupName;

        public XInfoConsumersReplayDecoder(String groupName) {
            this.groupName = groupName;
        }

        public StreamInfo.XInfoConsumers decode(List<Object> parts, State state) {
            ArrayList result = new ArrayList();
            for (List list : parts) {
                HashMap res = new HashMap();
                res.put("name", list.get(1));
                res.put("pending", list.get(3));
                res.put("idle", list.get(5));
                List list2 = res.entrySet().stream().flatMap(e -> Stream.of(e.getKey(), e.getValue())).collect(Collectors.toList());
                result.add(list2);
            }
            return StreamInfo.XInfoConsumers.fromList((String)this.groupName, result);
        }
    }

    private static class XInfoGroupsReplayDecoder
    implements MultiDecoder<StreamInfo.XInfoGroups> {
        private XInfoGroupsReplayDecoder() {
        }

        public StreamInfo.XInfoGroups decode(List<Object> parts, State state) {
            ArrayList result = new ArrayList();
            for (List list : parts) {
                HashMap res = new HashMap();
                res.put("name", list.get(1));
                res.put("consumers", list.get(3));
                res.put("pending", list.get(5));
                res.put("last-delivered-id", list.get(7));
                List list2 = res.entrySet().stream().flatMap(e -> Stream.of(e.getKey(), e.getValue())).collect(Collectors.toList());
                result.add(list2);
            }
            return StreamInfo.XInfoGroups.fromList(result);
        }
    }

    private static class XInfoStreamReplayDecoder
    implements MultiDecoder<StreamInfo.XInfoStream> {
        private XInfoStreamReplayDecoder() {
        }

        public StreamInfo.XInfoStream decode(List<Object> parts, State state) {
            List lastEntry;
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("length", parts.get(1));
            res.put("radix-tree-keys", parts.get(3));
            res.put("radix-tree-nodes", parts.get(5));
            res.put("groups", parts.get(7));
            res.put("last-generated-id", parts.get(9).toString());
            List firstEntry = (List)parts.get(11);
            if (firstEntry != null) {
                StreamMessageId firstId = StreamIdConvertor.INSTANCE.convert(firstEntry.get(0));
                Map firstData = (Map)firstEntry.get(1);
                res.put("first-entry", firstData);
            }
            if ((lastEntry = (List)parts.get(13)) != null) {
                StreamMessageId lastId = StreamIdConvertor.INSTANCE.convert(lastEntry.get(0));
                Map lastData = (Map)lastEntry.get(1);
                res.put("last-entry", lastData);
            }
            List list = res.entrySet().stream().flatMap(e -> Stream.of(e.getKey(), e.getValue())).collect(Collectors.toList());
            return StreamInfo.XInfoStream.fromList(list);
        }
    }
}

