/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.HttpHost;
import org.springframework.amqp.rabbit.connection.NodeLocator;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.lang.Nullable;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriUtils;

public class RestTemplateNodeLocator
implements NodeLocator<RestTemplate> {
    private final AuthCache authCache = new BasicAuthCache();
    private final AtomicBoolean authSchemeIsSetToCache = new AtomicBoolean(false);

    @Override
    public RestTemplate createClient(String userName, String password) {
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setHttpContextFactory((httpMethod, uri) -> {
            HttpClientContext context = HttpClientContext.create();
            context.setAuthCache(this.authCache);
            return context;
        });
        RestTemplate template = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        template.getInterceptors().add(new BasicAuthenticationInterceptor(userName, password));
        return template;
    }

    @Override
    @Nullable
    public Map<String, Object> restCall(RestTemplate client, String baseUri, String vhost, String queue) {
        URI uri;
        ResponseEntity response;
        URI theBaseUri = URI.create(baseUri);
        if (!this.authSchemeIsSetToCache.getAndSet(true)) {
            this.authCache.put(HttpHost.create((URI)theBaseUri), (AuthScheme)new BasicScheme());
        }
        return (response = client.exchange(uri = theBaseUri.resolve("/api/queues/" + UriUtils.encodePathSegment((String)vhost, (Charset)StandardCharsets.UTF_8) + "/" + queue), HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){})).getStatusCode().equals((Object)HttpStatus.OK) ? (Map)response.getBody() : null;
    }
}

