/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.support;

import org.springframework.batch.item.database.support.AbstractSqlPagingQueryProvider;
import org.springframework.batch.item.database.support.SqlPagingQueryUtils;
import org.springframework.util.StringUtils;

public class HsqlPagingQueryProvider
extends AbstractSqlPagingQueryProvider {
    @Override
    public String generateFirstPageQuery(int pageSize) {
        return SqlPagingQueryUtils.generateTopSqlQuery(this, false, this.buildTopClause(pageSize));
    }

    @Override
    public String generateRemainingPagesQuery(int pageSize) {
        if (StringUtils.hasText((String)this.getGroupClause())) {
            return SqlPagingQueryUtils.generateGroupedTopSqlQuery(this, this.buildTopClause(pageSize));
        }
        return SqlPagingQueryUtils.generateTopSqlQuery(this, true, this.buildTopClause(pageSize));
    }

    private String buildTopClause(int pageSize) {
        return "TOP " + pageSize;
    }
}

