/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.jms;

import jakarta.jms.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JmsItemReader<T>
implements ItemReader<T>,
InitializingBean {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected Class<? extends T> itemType;
    protected JmsOperations jmsTemplate;

    public void setJmsTemplate(JmsOperations jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
        if (jmsTemplate instanceof JmsTemplate) {
            JmsTemplate template = (JmsTemplate)jmsTemplate;
            Assert.isTrue((template.getReceiveTimeout() != 0L ? 1 : 0) != 0, (String)"JmsTemplate must have a receive timeout!");
            Assert.isTrue((template.getDefaultDestination() != null || template.getDefaultDestinationName() != null ? 1 : 0) != 0, (String)"JmsTemplate must have a defaultDestination or defaultDestinationName!");
        }
    }

    public void setItemType(Class<? extends T> itemType) {
        this.itemType = itemType;
    }

    @Override
    @Nullable
    public T read() {
        if (this.itemType != null && this.itemType.isAssignableFrom(Message.class)) {
            return (T)this.jmsTemplate.receive();
        }
        Object result = this.jmsTemplate.receiveAndConvert();
        if (this.itemType != null && result != null) {
            Assert.state((boolean)this.itemType.isAssignableFrom(result.getClass()), (String)("Received message payload of wrong type: expected [" + String.valueOf(this.itemType) + "]"));
        }
        return (T)result;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.jmsTemplate != null ? 1 : 0) != 0, (String)"The 'jmsTemplate' is required.");
    }
}

