/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.util.Map;
import java.util.function.Function;
import org.apache.maven.artifact.Artifact;
import org.springframework.boot.buildpack.platform.build.BuildRequest;
import org.springframework.boot.buildpack.platform.docker.type.ImageName;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.io.Owner;
import org.springframework.boot.buildpack.platform.io.TarArchive;
import org.springframework.util.StringUtils;

public class Image {
    String name;
    String builder;
    String runImage;
    Map<String, String> env;
    boolean cleanCache;
    boolean verboseLogging;

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public String getBuilder() {
        return this.builder;
    }

    void setBuilder(String builder) {
        this.builder = builder;
    }

    public String getRunImage() {
        return this.runImage;
    }

    void setRunImage(String runImage) {
        this.runImage = runImage;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public boolean isCleanCache() {
        return this.cleanCache;
    }

    public boolean isVerboseLogging() {
        return this.verboseLogging;
    }

    BuildRequest getBuildRequest(Artifact artifact, Function<Owner, TarArchive> applicationContent) {
        return this.customize(BuildRequest.of((ImageReference)this.getOrDeduceName(artifact), applicationContent));
    }

    private ImageReference getOrDeduceName(Artifact artifact) {
        if (StringUtils.hasText((String)this.name)) {
            return ImageReference.of((String)this.name);
        }
        ImageName imageName = ImageName.of((String)artifact.getArtifactId());
        return ImageReference.of((ImageName)imageName, (String)artifact.getVersion());
    }

    private BuildRequest customize(BuildRequest request) {
        if (StringUtils.hasText((String)this.builder)) {
            request = request.withBuilder(ImageReference.of((String)this.builder));
        }
        if (StringUtils.hasText((String)this.runImage)) {
            request = request.withRunImage(ImageReference.of((String)this.runImage));
        }
        if (this.env != null && !this.env.isEmpty()) {
            request = request.withEnv(this.env);
        }
        request = request.withCleanCache(this.cleanCache);
        request = request.withVerboseLogging(this.verboseLogging);
        return request;
    }
}

